/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import cn.hutool.json.JSONUtil;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.usermapping.BatchMappingQueryRequest;
import com.digiwin.dap.middleware.iam.domain.usermapping.EncryptUserMappingVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.QuerySingleMappingRequest;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/mapping"})
@Validated
public class UserMappingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMappingController.class);
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private IExcelService excelService;
    @Autowired
    private AuthValidateService authValidateService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> mapUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody @Valid UserMappingVO userMappingVO) {
        this.userMappingService.map(authoredUser.getTenantSid(), userMappingVO, false);
        return ResponseEntity.status((int)201).build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/mod"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> modMapUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody @Valid UserMappingVO userMappingVO) {
        this.userMappingService.map(authoredUser.getTenantSid(), userMappingVO, false, true);
        return ResponseEntity.status((int)201).build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/force"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> forceMapUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody @Valid UserMappingVO userMappingVO) {
        this.userMappingService.map(authoredUser.getTenantSid(), userMappingVO, true);
        return ResponseEntity.status((int)201).build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/delete"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> deleteMap(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody @Valid UserMappingVO userMappingVO) {
        this.userMappingService.deleteMap(authoredUser.getTenantSid(), userMappingVO);
        return ResponseEntity.status((int)200).build();
    }

    @PostMapping(value={"/query/appuser"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> queryMappedAppUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody UserMappingVO userMappingVO) {
        Assert.hasText((String)userMappingVO.getIdentityId(), (String)"\u5fc5\u987b\u6307\u5b9a\u5e94\u7528id(IdentityId)\u65b9\u53ef\u67e5\u8be2");
        Assert.hasText((String)userMappingVO.getVerifyUserId(), (String)"\u5fc5\u987b\u6307\u5b9averifyUserId\u65b9\u53ef\u67e5\u8be2");
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USE_TENANT_LOGIN);
        }
        UserMappingQueryResultVO identityInfo = this.userMappingService.getUserByMapping(Long.valueOf(authoredUser.getTenantSid()), userMappingVO.getIdentityId(), userMappingVO.getAccount(), userMappingVO.getVerifyUserId());
        return ResponseEntity.ok((Object)identityInfo);
    }

    @PostMapping(value={"/query/app"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> queryMappedUserByApp(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody UserMappingVO userMappingVO) {
        Assert.hasText((String)userMappingVO.getIdentityId(), (String)"\u5fc5\u987b\u6307\u5b9a\u5e94\u7528id(IdentityId)\u65b9\u53ef\u67e5\u8be2");
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USE_TENANT_LOGIN);
        }
        List identityInfo = this.userMappingService.getMappedByApp(authoredUser.getTenantSid(), userMappingVO.getIdentityId(), userMappingVO.getAccount());
        return ResponseEntity.ok((Object)identityInfo);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> queryMappedUserByUserAndTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody UserMappingVO userMappingVO) {
        if (null == userMappingVO.getTenantSid() || 0L == userMappingVO.getTenantSid()) {
            if (StringUtils.isEmpty((CharSequence)userMappingVO.getTenantId())) {
                if (authoredUser.getTenantSid() == 0L) {
                    throw new BusinessException((ErrorHandler)I18nError.USE_TENANT_LOGIN);
                }
                userMappingVO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
            } else {
                Tenant tenant = (Tenant)this.tenantCrudService.findById(userMappingVO.getTenantId());
                if (tenant == null) {
                    throw new BusinessException(String.format("\u79df\u6237%s\u4e0d\u5b58\u5728", userMappingVO.getTenantId()));
                }
                userMappingVO.setTenantSid(Long.valueOf(tenant.getSid()));
            }
        }
        if (userMappingVO.getTenantSid().longValue() != authoredUser.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        if (null == userMappingVO.getUserSid() || 0L == userMappingVO.getUserSid()) {
            if (StringUtils.isEmpty((CharSequence)userMappingVO.getUserId())) {
                if (authoredUser.getSid() == 0L) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
                }
                userMappingVO.setUserSid(Long.valueOf(authoredUser.getSid()));
            } else {
                User user = (User)this.userCrudService.findById(userMappingVO.getUserId());
                if (user == null) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userMappingVO.getUserId()});
                }
                userMappingVO.setUserSid(Long.valueOf(user.getSid()));
            }
        }
        if (StringUtils.isEmpty((CharSequence)userMappingVO.getIdentityId())) {
            userMappingVO.setIdentityId(UserUtils.getSysId());
        }
        if (StringUtils.isEmpty((CharSequence)userMappingVO.getIdentityId())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        List identityInfo = this.userMappingService.getMappedByUserAndApp(userMappingVO.getTenantSid().longValue(), userMappingVO.getUserSid().longValue(), userMappingVO.getIdentityId());
        if (Boolean.TRUE.equals(userMappingVO.getQueryEmpId()) && !CollectionUtils.isEmpty((Collection)identityInfo)) {
            String userId = ((UserMappingQueryResultVO)identityInfo.get(0)).getUserId();
            this.userMappingService.populateEmp(userMappingVO.getTenantSid(), userId, identityInfo);
        }
        return ResponseEntity.ok((Object)identityInfo);
    }

    @PostMapping(value={"/query/tenant"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> queryMappedUserByCondition(@RequestBody UserMappingVO userMappingVO) {
        if (UserUtils.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USE_TENANT_LOGIN);
        }
        if (ObjectUtils.isEmpty((Object)userMappingVO.getTenantSid()) || 0L == userMappingVO.getTenantSid()) {
            userMappingVO.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        }
        if (UserUtils.getTenantSid() != userMappingVO.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        PageSerializable page = PageHelper.startPage((int)userMappingVO.getPageNum(), (int)userMappingVO.getPageSize(), (String)userMappingVO.getOrderBy()).doSelectPageSerializable(() -> this.userMappingService.getMappedByCondition(userMappingVO.getTenantSid().longValue(), userMappingVO));
        return ResponseEntity.ok((Object)page);
    }

    @PostMapping(value={"/export"})
    public ResponseEntity<?> export(@RequestBody UserMappingVO userMappingVO) {
        String id = this.excelService.exportUserMapping(UserUtils.getTenantSid(), userMappingVO);
        return ResponseEntity.ok((Object)id);
    }

    @PostMapping(value={"/import/{fileId}"})
    public ResponseEntity<?> importUserMapping(@PathVariable String fileId) {
        return ResponseEntity.ok((Object)this.excelService.importUserMapping(fileId));
    }

    @PostMapping(value={"/clear"})
    public ResponseEntity<?> clearUserMapping() {
        return ResponseEntity.ok((Object)this.userMappingService.clearUserMapping());
    }

    @PostMapping(value={"/find"})
    public StdData<?> findUserMapping(@RequestBody @Valid EncryptUserMappingVO encryptUserMappingVO) {
        String sysId;
        long tenantSid;
        long userSid;
        try {
            userSid = Long.parseLong(AES.decryptHex((String)encryptUserMappingVO.getUserSid(), (String)KeyConstant.CAS));
            tenantSid = Long.parseLong(AES.decryptHex((String)encryptUserMappingVO.getTenantSid(), (String)KeyConstant.CAS));
            sysId = AES.decryptHex((String)encryptUserMappingVO.getAppId(), (String)KeyConstant.CAS);
        }
        catch (Exception e) {
            LOGGER.error("decrypt encryptUserMappingVO failed, encryptUserMappingVO:{}", (Object)JSONUtil.toJsonStr((Object)encryptUserMappingVO), (Object)e);
            return StdData.of((int)500, (String)"\u52a0\u5bc6\u53c2\u6570\u9519\u8bef");
        }
        List identityInfo = this.userMappingService.getMappedByUserAndApp(tenantSid, userSid, sysId);
        return StdData.ok((Object)identityInfo);
    }

    @PostMapping(value={"/query/batch"})
    public StdData<?> queryMappedUserByCondition(@RequestBody @Valid List<BatchMappingQueryRequest> input) {
        return StdData.ok((Object)this.userMappingService.batchQueryMapping(UserUtils.getTenantSid(), input));
    }

    @PostMapping(value={"/query/global/single"})
    public StdData<?> queryGlobalSingle(@RequestBody QuerySingleMappingRequest request) {
        request.valid();
        List userMappingList = this.userMappingService.getByVerifyUserIdAndAppIdAndAccount(request.getVerifyUserId(), request.getAppId(), request.getAccount());
        if (CollectionUtils.isEmpty((Collection)userMappingList)) {
            return StdData.ok().build();
        }
        if (userMappingList.size() > 1) {
            throw new BusinessException((ErrorHandler)I18nError.VERIFY_USER_MAPPING_MULTI_USER_ERROR, new Object[]{request.getVerifyUserId()});
        }
        return StdData.ok(userMappingList.get(0));
    }
}

