/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.user.ResetPasswordVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByAccountVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByIdVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByOldPasswordVO;
import com.digiwin.dap.middleware.iam.domain.user.UserAccountPasswordVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.user.UpdatePasswordService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserService;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdExecution;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Objects;
import javax.validation.Valid;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/user"})
public class UserPasswordController {
    private static final Logger logger = LoggerFactory.getLogger(UserPasswordController.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UpdatePasswordService updatePasswordService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private UserService userService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @PostMapping(value={"/update/password"})
    public ResponseEntity<?> updatePassword(@RequestBody UpdatePasswordByIdVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!authoredUser.getUserId().equalsIgnoreCase(body.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_AUTHORIZATION_ERROR);
        }
        try {
            String oldPassword = AES.decrypt((String)body.getOldPassword(), (String)KeyConstant.WECHAT_UNION_ID);
            String newPassword = AES.decrypt((String)body.getNewPassword(), (String)KeyConstant.WECHAT_UNION_ID);
            if (ObjectUtils.nullSafeEquals((Object)oldPassword, (Object)newPassword)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PASSWORD_CHANGE_SAME);
            }
            if (PasswordValidator.validatePassword((String)newPassword)) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
            }
            body.setOldPassword(oldPassword);
            body.setNewPassword(newPassword);
            body.setOldPasswordHash(DigestUtils.sha256((String)oldPassword));
            body.setNewPasswordHash(DigestUtils.sha256((String)newPassword));
        }
        catch (Exception e) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/update/password", UserUtils.getSysId()).booleanValue()) {
                throw e;
            }
            logger.error("\u5bc6\u7801\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
        this.updatePasswordService.updatePasswordByOldPassword(body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/password/update/without/captcha"})
    public ResponseEntity<?> updatePasswordWithoutVerificationCode(@RequestBody UpdatePasswordByOldPasswordVO request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        String newPassword = request.getNewPassword();
        String oldPassword = request.getOldPassword();
        try {
            newPassword = AES.decrypt((String)newPassword, (String)KeyConstant.WECHAT_UNION_ID);
            oldPassword = AES.decrypt((String)oldPassword, (String)KeyConstant.WECHAT_UNION_ID);
        }
        catch (Exception e) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/password/update/without/captcha", UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPT_ERROR);
            }
            logger.error("\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
        }
        if (PasswordValidator.validatePassword((String)newPassword)) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
        }
        User operateUser = (User)this.userCrudService.findBySid(authoredUser.getSid());
        if (Objects.isNull(operateUser)) {
            throw new BusinessException((ErrorHandler)I18nError.OPERATE_PASSWORD_USER_NOT_EXIST);
        }
        if (!Objects.equals(DigestUtils.sha256((String)oldPassword), operateUser.getPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.OPERATE_PASSWORD_USER_PASSWORD_ERROR);
        }
        this.updatePasswordService.updatePasswordCore(operateUser, Boolean.valueOf(true), newPassword);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/update/password/force"})
    public ResponseEntity<?> forceUpdatePassword(@RequestBody UpdatePasswordByIdVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u5fc5\u987b\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        User updatePasswordUser = body.getSid() != 0L ? (User)this.userCrudService.findBySid(body.getSid()) : (User)this.userCrudService.findById(body.getId());
        if (updatePasswordUser == null) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_USER_NOT_EXIST);
        }
        if (!authoredUser.getUserId().equals(updatePasswordUser.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_AUTHORIZATION_ERROR);
        }
        try {
            if (ObjectUtils.isEmpty((Object)body.getNewPasswordHash())) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_NEW_EMPTY_ERROR);
            }
        }
        catch (Exception ex) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/update/password/force", UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPT_ERROR, ex.getMessage());
            }
            logger.error("\u5bc6\u7801\u89e3\u6790\u9519\u8bef", (Throwable)ex);
        }
        if (ObjectUtils.isEmpty((Object)body.getNewPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_NEW_EMPTY_ERROR);
        }
        if (PasswordValidator.validatePassword((String)body.getNewPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
        }
        this.updatePasswordService.updatePasswordCore(updatePasswordUser, Boolean.valueOf(true), body.getNewPassword());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/password/update"})
    public ResponseEntity<?> updatePassword(@RequestBody UpdatePasswordByAccountVO body) {
        if (StringUtils.isEmpty((Object)body.getAccount())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_TELEPHONE_EMPTY);
        }
        if (StringUtils.isEmpty((Object)body.getPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_PASSWORD_EMPTY);
        }
        if (StringUtils.isEmpty((Object)body.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_EMPTY);
        }
        try {
            String password = AES.decrypt((String)body.getPassword(), (String)KeyConstant.WECHAT_UNION_ID);
            if (PasswordValidator.validatePassword((String)password)) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
            }
            body.setPassword(password);
        }
        catch (Exception e) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/password/update", UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPTION_FAILED, e.getMessage());
            }
            logger.error("\u5bc6\u7801\u89e3\u5bc6\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        this.updatePasswordService.updatePasswordByVerificationCode(body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/enterprise/password/reset"})
    public StdData resetUserEnterprisePassword(@RequestBody @Valid ResetPasswordVO request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (ObjectUtils.isEmpty((Object)request.getOperatorPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        String targetUserPassword = request.getTargetUserPassword();
        String operatorPassword = request.getOperatorPassword();
        try {
            targetUserPassword = AES.decrypt((String)targetUserPassword, (String)KeyConstant.WECHAT_UNION_ID);
            operatorPassword = StringUtils.hasLength((String)operatorPassword) ? AES.decrypt((String)operatorPassword, (String)KeyConstant.WECHAT_UNION_ID) : null;
        }
        catch (Exception exception) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/enterprise/password/reset", UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPT_ERROR);
            }
            logger.error("\u5bc6\u7801\u89e3\u6790\u9519\u8bef", (Throwable)exception);
        }
        if (PasswordValidator.validatePassword((String)targetUserPassword)) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
        }
        User targetUser = (User)this.userCrudService.findBySid(request.getTargetUserSid().longValue());
        if (Objects.isNull(targetUser)) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_USER_NOT_EXIST);
        }
        if (!this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), targetUser.getSid()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/enterprise/password/reset", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)request))});
        }
        String targetUserId = authoredUser.getUserId();
        if (targetUserId.contains("@") && targetUserId.toLowerCase().endsWith("@digiwin.com")) {
            String adCode = targetUserId.split("@")[0];
            AdExecution adUser = this.ldapService.checkAccount(adCode, operatorPassword, this.envProperties.getCountry());
            if (adUser.getInfo() == null) {
                throw new BusinessException((ErrorHandler)I18nError.OPERATE_PASSWORD_USER_PASSWORD_ERROR);
            }
        } else {
            boolean operatorPasswordIsCorrect;
            User operateUser = (User)this.userCrudService.findBySid(authoredUser.getSid());
            if (Objects.isNull(operateUser)) {
                throw new BusinessException((ErrorHandler)I18nError.OPERATE_PASSWORD_USER_NOT_EXIST);
            }
            boolean bl = operatorPasswordIsCorrect = Objects.equals(DigestUtils.sha256((String)operatorPassword), operateUser.getPassword()) || StringUtils.hasLength((String)operateUser.getSalt()) && Objects.equals(operateUser.getPassword(), DigestUtils.md5Hex((String)(operatorPassword + operateUser.getSalt())));
            if (!operatorPasswordIsCorrect) {
                throw new BusinessException((ErrorHandler)I18nError.OPERATE_PASSWORD_USER_PASSWORD_ERROR);
            }
        }
        targetUser.setPassword(DigestUtils.sha256((String)targetUserPassword));
        targetUser.setChanged(false);
        this.userCrudService.update((BaseEntity)targetUser);
        return StdData.ok().build();
    }

    @GetMapping(value={"/password/change/check"})
    public ResponseEntity<?> checkPasswordChange() {
        return ResponseEntity.ok((Object)this.userService.checkPasswordChange());
    }

    @PostMapping(value={"/password/renewal"})
    public ResponseEntity<?> renewPassword() {
        this.userService.renewPassword();
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/enterprise/account/password/send"})
    public StdData sendUserEnterpriseAccountPassword(@RequestBody UserAccountPasswordVO vo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        vo.setTenantId(authoredUser.getTenantId());
        if ("dev".equalsIgnoreCase(sys.getId())) {
            this.messageService.sendDevUserEnterpriseAccountPassword(vo);
        } else if (StringUtils.hasText((String)vo.getSourceAppId())) {
            this.messageService.sendAppAccountPasswordMail(vo);
        } else {
            this.messageService.sendUserEnterpriseAccountPassword(vo);
        }
        return StdData.ok().build();
    }
}

