/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.authentication;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.ValidatedGroup;
import com.digiwin.dap.middleware.iam.constant.enums.SsoTypeEnum;
import com.digiwin.dap.middleware.iam.domain.authapp.AuthAppDTO;
import com.digiwin.dap.middleware.iam.entity.AuthApp;
import com.digiwin.dap.middleware.iam.service.authapp.AuthAppCrudService;
import com.digiwin.dap.middleware.iam.service.authapp.AuthAppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2"})
public class AuthAppController {
    @Autowired
    private AuthAppCrudService authAppCrudService;
    @Autowired
    private AuthAppService authAppService;

    @PostMapping(value={"/authapp/add"})
    public StdData<?> save(@Validated(value={ValidatedGroup.INSERT.class}) @RequestBody AuthAppDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AuthApp authApp = (AuthApp)dto.doForward();
        authApp.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)this.authAppCrudService.create((BaseEntity)authApp));
    }

    @GetMapping(value={"/authapp/find"})
    public StdData<?> find(@Validated(value={ValidatedGroup.FIND.class}) AuthAppDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AuthApp authApp = this.authAppCrudService.findBySidAndTenantSid(dto.getSid(), Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)authApp);
    }

    @GetMapping(value={"/authapp/sysid/type/find"})
    public StdData<?> findBySysIdAndType(@Validated(value={ValidatedGroup.FIND_1.class}) AuthAppDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AuthApp authApp = this.authAppCrudService.findBySysIdAndTypeAndTenantSid(dto.getSysId(), dto.getType(), Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)authApp);
    }

    @PutMapping(value={"/authapp/mod"})
    public StdData<?> update(@Validated(value={ValidatedGroup.UPDATE.class}) @RequestBody AuthAppDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AuthApp oldAuthApp = this.authAppCrudService.findBySidAndTenantSid(dto.getSid(), Long.valueOf(authoredUser.getTenantSid()));
        if (oldAuthApp == null) {
            throw new BusinessException(String.format("\u67e5\u8be2sid[%s]\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539", dto.getSid()));
        }
        oldAuthApp.setSysName(dto.getSysName());
        oldAuthApp.setClientId(dto.getClientId());
        oldAuthApp.setClientSecret(dto.getClientSecret());
        oldAuthApp.setAuthUrl(dto.getAuthUrl());
        oldAuthApp.setAccessTokenUrl(dto.getAccessTokenUrl());
        oldAuthApp.setUserInfoUrl(dto.getUserInfoUrl());
        oldAuthApp.setRefreshUrl(dto.getRefreshUrl());
        oldAuthApp.setRevokeUrl(dto.getRevokeUrl());
        oldAuthApp.setUserIdAttr(dto.getUserIdAttr());
        oldAuthApp.setType(dto.getType());
        oldAuthApp.setRemark(dto.getRemark());
        this.authAppCrudService.update((BaseEntity)oldAuthApp);
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/authapp/del"})
    public StdData<?> delete(@Validated(value={ValidatedGroup.DELETE.class}) AuthAppDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.authAppCrudService.deleteBySidAndTenantSid(dto.getSid(), Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)Boolean.TRUE);
    }

    @GetMapping(value={"/authapp/oidc/tenant/sys/exist"})
    public StdData<?> exist(@RequestParam String tenantId, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        boolean existsed = this.authAppService.existsByTenantIdAndSysIdAndType(tenantId, sys.getId(), SsoTypeEnum.OIDC.getCode());
        return StdData.ok((Object)existsed);
    }

    @GetMapping(value={"/authapp/search"})
    public StdData<?> list(Page page, AuthAppDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)this.authAppService.list(page, dto));
    }
}

