/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.authentication;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTUtil;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.SsoTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.cache.UserTempTokenCacheVO;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAuthCode;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.AuthApp;
import com.digiwin.dap.middleware.iam.entity.SysSsoUrlConfig;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.AuthAppRepository;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginResponse;
import com.digiwin.dap.middleware.iam.util.SAMLUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.text.StrSubstitutor;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/iam/v2/oidc"})
public class OIDCController {
    private static final Logger logger = LoggerFactory.getLogger(OIDCController.class);
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private SysSsoUrlConfigCrudService sysSsoUrlConfigCrudService;
    @Autowired
    private AuthAppRepository authAppRepository;
    @Autowired
    private RestTemplate restTemplate;

    public static void main(String[] args) {
        OidcConfiguration configuration = new OidcConfiguration();
        configuration.setClientId("788339d7-1c44-4732-97c9-134cb201f01f");
        configuration.setSecret("we/31zi+JYa7zOugO4TbSw0hzn+hv2wmENO9AS3T84s=");
        configuration.setDiscoveryURI("https://login.microsoftonline.com/38c46e5a-21f0-46e5-940d-3ca06fd1a330/.well-known/openid-configuration");
        OidcClient client = new OidcClient(configuration);
    }

    @GetMapping(value={"/login"})
    public void login(@RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="sysId", required=false) String sysId, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys, HttpServletRequest request, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        AuthApp authApp;
        sysId = Optional.ofNullable(sysId).filter(StringUtils::hasLength).orElse(sys.getId());
        try {
            if (!StringUtils.hasText((String)tenantId) || !StringUtils.hasText((String)sysId)) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (tenant == null || !tenant.isOidcLogin()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_OIDC_SYS_NOT_EXIST);
            }
            authApp = this.authAppRepository.findByTenantSidAndSysIdAndType(tenant.getSid(), sysId, SsoTypeEnum.OIDC.getCode());
            if (authApp == null) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_OIDC_SYS_NOT_EXIST);
            }
            SysSsoUrlConfig ssoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.OIDC.getCode());
            if (ssoUrlConfig == null) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_OIDC_SYS_NOT_EXIST);
            }
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.OIDC.getCode());
        }
        catch (Exception e) {
            logger.error("\u3010oidc\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("client_id", authApp.getClientId());
            String authUrl = new StrSubstitutor(values).replace(authApp.getAuthUrl());
            response.sendRedirect(authUrl);
        }
        catch (BusinessException e) {
            logger.error("\u3010oidc\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010oidc\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)"\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    @RequestMapping(value={"/{tenantId:.+}/{sysId}"})
    public void authCallback(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="sysId") String sysId, OauthAuthCode oauthAuthCode, HttpServletRequest request, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        AuthApp authApp;
        Tenant tenant;
        try {
            tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (tenant == null || !tenant.isOidcLogin()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_OIDC_SYS_NOT_EXIST);
            }
            authApp = this.authAppRepository.findByTenantSidAndSysIdAndType(tenant.getSid(), sysId, SsoTypeEnum.OIDC.getCode());
            if (authApp == null) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_OIDC_SYS_NOT_EXIST);
            }
            SysSsoUrlConfig ssoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.OIDC.getCode());
            if (ssoUrlConfig == null) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_OIDC_SYS_NOT_EXIST);
            }
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.OIDC.getCode());
            if (Objects.isNull(sysSsoUrlConfig)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_SYS_NOT_EXIST);
            }
        }
        catch (Exception e) {
            logger.error("\u3010oidc\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            String code = oauthAuthCode.getCode();
            String accessTokenUrl = authApp.getAccessTokenUrl();
            UrlBuilder urlBuilder = UrlBuilder.of((String)accessTokenUrl).addQuery("client_id", (Object)authApp.getClientId()).addQuery("code", (Object)code).addQuery("client_secret", (Object)authApp.getClientSecret()).addQuery("grant_type", (Object)"authorization_code").addQuery("redirect_uri", (Object)(this.envProperties.getIamUri() + request.getRequestURI()));
            OAuthLoginResponse authLoginResponse = (OAuthLoginResponse)this.restTemplate.postForObject(urlBuilder.toString(), null, OAuthLoginResponse.class, new Object[0]);
            JWT jwt = JWTUtil.parseToken((String)authLoginResponse.getIdToken());
            String key = Optional.ofNullable(authApp.getUserIdAttr()).orElse("sub");
            String verifyUserId = jwt.getPayload(key).toString();
            if (Objects.isNull(verifyUserId)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_ID_MAPPING_ATTRIBUTE_NOT_EXIST);
            }
            UserMappingQueryResultVO userMappingInfo = this.userMappingService.getUserByMapping(Long.valueOf(tenant.getSid()), authApp.getType(), null, verifyUserId);
            if (Objects.isNull(userMappingInfo)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_MAPPING_NOT_EXIST);
            }
            UserTempTokenCacheVO cacheVO = new UserTempTokenCacheVO();
            cacheVO.setValue(String.join((CharSequence)":_", userMappingInfo.getUserId(), tenantId, sysId));
            cacheVO.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            String token = UUID.randomUUID().toString().toLowerCase();
            String tokenKey = String.format("iam:sso:token:%s:%s", "oidc", token);
            RedisUtils.set((String)tokenKey, (Object)cacheVO, (Duration)Duration.ofMinutes(3L));
            this.redirect(response, SAMLUtil.getSuccessCallbackUrl((String)sysSsoUrlConfig.getSuccessCallbackUrl(), (String)token, (String)verifyUserId, null));
        }
        catch (BusinessException e) {
            logger.error("\u3010oidc\u3011 \u8ba4\u8bc1\u56de\u8c03\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010oidc\u3011 \u8ba4\u8bc1\u56de\u8c03\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)"\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    private void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException ex) {
            logger.error("\u3010oidc\u3011 \u8df3\u8f6c\u5931\u8d25\u9875\u9762\u5f02\u5e38", (Throwable)ex);
        }
    }

    private void sendResponse(HttpServletResponse response, String message) {
        try {
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain; charset=UTF-8");
            PrintWriter printWriter = response.getWriter();
            printWriter.write(message);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception ex) {
            logger.error("\u3010oidc\u3011 \u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5f02\u5e38", (Throwable)ex);
        }
    }
}

