/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.base;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;

public abstract class AppBaseController {
    protected long getAppSid(SysCrudService sysCrudService, long sysSid, String sysId) {
        if (sysSid > 0L) {
            return sysSid;
        }
        if (sysSid == 0L && sysId == null) {
            throw new IllegalArgumentException("sysSid or sysId is null");
        }
        return sysCrudService.getSidById(sysId);
    }

    protected long getModuleSid(ModuleCrudService moduleCrudService, long appSid, long moduleSid, String moduleId) {
        if (moduleSid > 0L) {
            return moduleSid;
        }
        if (appSid == 0L) {
            throw new IllegalArgumentException("appSid is null");
        }
        if (moduleSid == 0L && moduleId == null) {
            throw new IllegalArgumentException("moduleSid or moduleId is null");
        }
        return moduleCrudService.getSidByUnionKey(new Object[]{moduleId, appSid});
    }

    protected long getActionSid(ActionCrudService actionCrudService, long tenantSid, long moduleSid, long actionSid, String actionId) {
        if (actionSid > 0L) {
            return actionSid;
        }
        if (moduleSid == 0L) {
            throw new IllegalArgumentException("moduleSid is null");
        }
        return actionCrudService.getSidByUnionKey(new Object[]{actionId, moduleSid, tenantSid});
    }

    protected void checkAuth(AuthoredUser authoredUser, EnvProperties envProperties, UserInRoleService userInRoleService) {
        if ("dev".equals(envProperties.getActive())) {
            return;
        }
        if (!envProperties.getManagerTenant().equals(authoredUser.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.APP_PERMISSION_ERROR);
        }
        if (!userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.APP_SUPER_ADMIN_ERROR, new Object[]{authoredUser.getUserId()});
        }
    }
}

