/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.dataplus;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusPermission;
import com.digiwin.dap.middleware.iam.domain.dataplus.OperationUnitTargetEnum;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourceConditionPermission;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourceDataPlusPermission;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.request.UserConditionPlusRequest;
import com.digiwin.dap.middleware.iam.domain.request.UserDataPlusRequest;
import com.digiwin.dap.middleware.iam.domain.roleuser.UserRoleListVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/permission"})
public class DataPlusPermissionController {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private DataPlusPolicyCrudService dataPlusPolicyCrudService;

    @GetMapping(value={"/user/condition/plus"})
    public StdData<?> conditionPlus(UserConditionPlusRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findById(body.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{body.getUserId()});
        }
        ArrayList<ResourceConditionPermission> permissions = new ArrayList<ResourceConditionPermission>();
        ResourceConditionPermission userCondition = this.dataPlusPolicyCrudService.findCondition(authoredUser.getTenantSid(), TargetType.user, user.getSid(), body.getResourceId());
        if (userCondition != null) {
            userCondition.setTargetId(user.getId());
            permissions.add(userCondition);
        }
        List userRoles = this.userInRoleCrudService.findRoleByUserSid(authoredUser.getTenantSid(), user.getSid(), true);
        for (UserRoleListVO userRole : userRoles) {
            ResourceConditionPermission roleCondition = this.dataPlusPolicyCrudService.findCondition(authoredUser.getTenantSid(), TargetType.role, userRole.getRoleSid().longValue(), body.getResourceId());
            if (roleCondition == null) continue;
            roleCondition.setTargetId(userRole.getRoleId());
            permissions.add(roleCondition);
        }
        return StdData.ok(permissions);
    }

    @GetMapping(value={"/user/data/plus"})
    public StdData<?> dataPlus(UserDataPlusRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findById(body.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{body.getUserId()});
        }
        ArrayList<ResourceDataPlusPermission> permissions = new ArrayList<ResourceDataPlusPermission>();
        DataPlusPermission userDataPlus = this.dataPlusPolicyCrudService.findDetail(authoredUser.getTenantSid(), TargetType.user.name(), user.getSid(), body.getResourceId(), true);
        if (userDataPlus != null) {
            ResourceDataPlusPermission userDataPlusPermission = new ResourceDataPlusPermission();
            userDataPlusPermission.setType(TargetType.user.name());
            userDataPlusPermission.setTargetId(user.getId());
            userDataPlusPermission.setResourceId(body.getResourceId());
            userDataPlusPermission.setDeptData(userDataPlus.getDeptData());
            userDataPlusPermission.setOperationUnits(userDataPlus.getOperationUnits());
            permissions.add(userDataPlusPermission);
        }
        List userRoles = this.userInRoleCrudService.findRoleByUserSid(authoredUser.getTenantSid(), user.getSid(), true);
        for (UserRoleListVO userRole : userRoles) {
            ResourceDataPlusPermission roleDataPlusPermission = new ResourceDataPlusPermission();
            roleDataPlusPermission.setType(TargetType.role.name());
            roleDataPlusPermission.setTargetId(userRole.getRoleId());
            roleDataPlusPermission.setResourceId(body.getResourceId());
            DataPlusPermission roleDataPlus = this.dataPlusPolicyCrudService.findDetail(authoredUser.getTenantSid(), TargetType.role.name(), userRole.getRoleSid().longValue(), body.getResourceId(), true);
            if (roleDataPlus != null) {
                roleDataPlusPermission.setDeptData(roleDataPlus.getDeptData());
                roleDataPlusPermission.setDataFilters(roleDataPlus.getDataFilters());
                roleDataPlusPermission.setEditLimits(roleDataPlus.getEditLimits());
                roleDataPlusPermission.setFieldFilters(roleDataPlus.getFieldFilters());
            }
            List operationUnits = this.dataPlusPolicyCrudService.findOperationUnits(OperationUnitTargetEnum.USER_ROLE, userRole.getSid().longValue(), true);
            roleDataPlusPermission.setOperationUnits(operationUnits);
            if (roleDataPlus == null && operationUnits == null) continue;
            permissions.add(roleDataPlusPermission);
        }
        return StdData.ok(permissions);
    }
}

