/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.dataplus;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusPermission;
import com.digiwin.dap.middleware.iam.domain.request.DataPlusPolicyAddRequest;
import com.digiwin.dap.middleware.iam.domain.request.DataPlusPolicyDelRequest;
import com.digiwin.dap.middleware.iam.domain.request.DataPlusPolicyFindRequest;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusPolicyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/data/plus/policy"})
public class DataPlusPolicyController {
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private DataPlusPolicyService dataPlusPolicyService;
    @Autowired
    private DataPlusPolicyCrudService dataPlusPolicyCrudService;

    @Transactional
    @PostMapping(value={"/batch/save"})
    public StdData<?> batchAdd(@RequestBody DataPlusPolicyAddRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.dataPlusPolicyService.saveAction(authoredUser.getTenantSid(), body.getSysSid().longValue(), body.getType(), body.getTargetSid().longValue(), body.getActionPermission());
        this.dataPlusPolicyService.saveCondition(authoredUser.getTenantSid(), body.getType(), body.getTargetSid().longValue(), body.getResourcePermission());
        this.dataPlusPolicyService.saveDataPlus(authoredUser.getTenantSid(), body.getType(), body.getTargetSid().longValue(), body.getDataPermission());
        return StdData.ok().build();
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody DataPlusPolicyDelRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Action action = (Action)this.actionCrudService.findBySid(body.getActionSid().longValue());
        if (action == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST, new Object[]{body.getActionSid()});
        }
        this.dataPlusPolicyService.delete(authoredUser.getTenantSid(), body.getSysSid().longValue(), body.getType(), body.getTargetSid().longValue(), action.getSid());
        return StdData.ok().build();
    }

    @GetMapping(value={"/find"})
    public StdData<?> find(DataPlusPolicyFindRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        DataPlusPermission dataPlusPermission = this.dataPlusPolicyCrudService.findDetail(authoredUser.getTenantSid(), body.getType(), body.getTargetSid().longValue(), body.getResourceId(), false);
        return StdData.ok((Object)dataPlusPermission);
    }
}

