/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.dataplus;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.request.ResourcePolicyDelRequest;
import com.digiwin.dap.middleware.iam.domain.request.ResourcePolicyQueryActionRequest;
import com.digiwin.dap.middleware.iam.domain.request.ResourcePolicyQueryRequest;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusPolicyCrudService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/policy"})
public class PolicyResourceController {
    @Autowired
    private DataPlusPolicyCrudService dataPlusPolicyCrudService;

    @PostMapping(value={"/resource/del"})
    public StdData<?> del(@RequestBody ResourcePolicyDelRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.dataPlusPolicyCrudService.batchDel(authoredUser.getTenantSid(), body.getType(), body.getTargetSid().longValue(), Collections.singletonList(body.getResourceId()));
        return StdData.ok().build();
    }

    @GetMapping(value={"/resource/query"})
    public StdData<?> query(ResourcePolicyQueryRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List conditions = this.dataPlusPolicyCrudService.findResourceCondition(authoredUser.getTenantSid(), body.getType(), body.getTargetSid().longValue(), body.getResourceIds());
        return StdData.ok((Object)conditions);
    }

    @GetMapping(value={"/resource/query/action"})
    public StdData<?> queryAction(ResourcePolicyQueryActionRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!CollectionUtils.isEmpty((Collection)body.getResourceIds())) {
            List conditions = this.dataPlusPolicyCrudService.findActionCondition(authoredUser.getTenantSid(), body.getType(), body.getTargetSid().longValue(), body.getResourceIds());
            return StdData.ok((Object)conditions);
        }
        return StdData.ok().build();
    }
}

