/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.dataplus;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusOperationUnitVO;
import com.digiwin.dap.middleware.iam.domain.dataplus.OperationUnitTargetEnum;
import com.digiwin.dap.middleware.iam.domain.request.RoleUserDelRequest;
import com.digiwin.dap.middleware.iam.domain.request.RoleUserListRequest;
import com.digiwin.dap.middleware.iam.domain.request.RoleUserModStatusRequest;
import com.digiwin.dap.middleware.iam.domain.request.RoleUserSaveRequest;
import com.digiwin.dap.middleware.iam.domain.roleuser.RoleUserListVO;
import com.digiwin.dap.middleware.iam.domain.roleuser.RoleUserVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusOperationUnitCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/role/user"})
public class RoleUserController {
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private DataPlusOperationUnitCrudService dataPlusOperationUnitCrudService;

    @Transactional
    @PostMapping(value={"/save"})
    public StdData<?> save(@RequestBody RoleUserSaveRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Role role = this.roleCrudService.findByTenantSidAndSid(authoredUser.getTenantSid(), body.getRoleSid().longValue());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_NOT_EXIST, new Object[]{body.getRoleSid()});
        }
        ArrayList<Long> oldRoleUserSids = new ArrayList<Long>();
        ArrayList operationUnits = new ArrayList();
        for (RoleUserVO roleUser : body.getUsers()) {
            Association newAssociation;
            User user = (User)this.userCrudService.findBySid(roleUser.getUserSid().longValue());
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{roleUser.getUserSid()});
            }
            Association oldAssociation = this.userInRoleCrudService.findByUnionKey(role.getTenantSid(), user.getSid(), role.getSid());
            if (oldAssociation == null) {
                newAssociation = roleUser.toEntity();
                newAssociation.setTenantSid(role.getTenantSid());
                newAssociation.setRoleSid(role.getSid());
                this.userInRoleCrudService.create((BaseEntity)newAssociation);
            } else {
                newAssociation = roleUser.toEntity(oldAssociation);
                oldRoleUserSids.add(newAssociation.getSid());
                this.userInRoleCrudService.update((BaseEntity)oldAssociation);
            }
            roleUser.getOperationUnits().stream().map(DataPlusOperationUnitVO::toEntity).forEach(operationUnit -> {
                operationUnit.setTenantSid(role.getTenantSid());
                operationUnit.setPolicySid(newAssociation.getSid());
                operationUnit.setType(OperationUnitTargetEnum.USER_ROLE.name());
                operationUnits.add(operationUnit);
            });
        }
        this.dataPlusOperationUnitCrudService.deleteByPolicySids(OperationUnitTargetEnum.USER_ROLE.name(), oldRoleUserSids);
        this.dataPlusOperationUnitCrudService.insertAll(operationUnits);
        return StdData.ok().build();
    }

    @Transactional
    @PostMapping(value={"/batch/del"})
    public StdData<?> batchDel(@RequestBody RoleUserDelRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        for (Long sid : body.getSids()) {
            Association association = (Association)this.userInRoleCrudService.findBySidAndTenantSid(sid.longValue(), authoredUser.getTenantSid());
            if (association == null) continue;
            this.userInRoleCrudService.deleteByUnionKey(authoredUser.getTenantSid(), association.getUserSid(), association.getRoleSid());
        }
        this.dataPlusOperationUnitCrudService.deleteByPolicySids(OperationUnitTargetEnum.USER_ROLE.name(), body.getSids());
        return StdData.ok().build();
    }

    @PostMapping(value={"/batch/mod/status"})
    public StdData<?> modStatus(@RequestBody RoleUserModStatusRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!CollectionUtils.isEmpty((Collection)body.getSids()) && body.getStatus() != null) {
            this.userInRoleCrudService.updateStatus(authoredUser.getTenantSid(), body.getStatus().booleanValue(), body.getSids());
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/list"})
    public StdData<?> list(RoleUserListRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List users = this.userInRoleCrudService.findUserByRoleSid(authoredUser.getTenantSid(), body.getRoleSid().longValue());
        List empInfos = this.remoteEocService.getEmpByUserIds(users.stream().map(RoleUserListVO::getUserId).collect(Collectors.toList()));
        Map<String, EmpInfoVO> empMap = empInfos.stream().collect(Collectors.toMap(EmpInfoVO::getUserId, a -> a, (k1, k2) -> k1));
        List sids = users.stream().map(RoleUserListVO::getSid).collect(Collectors.toList());
        List dataPlusOperationUnits = this.dataPlusOperationUnitCrudService.findByPolicySids(OperationUnitTargetEnum.USER_ROLE.name(), sids);
        Map<Long, List<DataPlusOperationUnitVO>> map = dataPlusOperationUnits.stream().map(DataPlusOperationUnitVO::new).collect(Collectors.groupingBy(DataPlusOperationUnitVO::getPolicySid));
        users.forEach(user -> {
            user.setOperationUnits((List)map.get(user.getSid()));
            EmpInfoVO empInfo = (EmpInfoVO)empMap.get(user.getUserId());
            if (empInfo != null) {
                user.setEmpId(empInfo.getId());
                user.setEmpName(empInfo.getName());
            }
        });
        return StdData.ok((Object)users);
    }
}

