/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.obsolete;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestRegisterInfo;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopLanguage;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopSys;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.sync.ApplicationSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.AuthSyncDTO;
import com.digiwin.dap.middleware.iam.mapper.DevSysMapper;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.service.dev.test.DevTestEnvService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.huawei.ProduceSyncService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CBMController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CBMController.class);
    @Autowired
    private DevTestEnvService devTestEnvService;
    @Autowired
    private DevSysService devSysService;
    @Autowired
    private ProduceSyncService produceSyncService;
    @Autowired
    private DevSysMapper devSysMapper;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private ServiceAuthorizationRecordService serviceAuthorizationRecordService;

    @PostMapping(value={"/api/iam/v2/dev/test/env/register"})
    public StdData registerTestTenantInfo(@RequestBody @Valid DevTestRegisterInfo registerInfo, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        if (null == registerInfo || null == registerInfo.getTenant() || StringUtils.isEmpty((Object)registerInfo.getTenant().getTeamId())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        Long tenantSid = this.devTestEnvService.registerTestInfoInTestArea(registerInfo, registerInfo.getTenant().getTeamId());
        return StdData.ok((Object)tenantSid);
    }

    @PostMapping(value={"/api/iam/v2/dev/test/env/register/tenant"})
    public StdData registerTestTenant(@RequestBody @Valid DevTestRegisterInfo registerInfo, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        if (null == registerInfo || null == registerInfo.getTenant() || StringUtils.isEmpty((Object)registerInfo.getTenant().getTeamId())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        Long tenantSid = this.devTestEnvService.registerTestInfoInTestArea(registerInfo, registerInfo.getTenant().getTeamId());
        return StdData.ok((Object)tenantSid);
    }

    @PostMapping(value={"/api/iam/v2/dev/app/cascade/del"})
    public StdData deleteDevSysCascade(@RequestBody AuthDataDO appInfo) {
        Boolean result = this.devSysService.deleteAppCascade(appInfo.getAppId());
        if (!result.booleanValue()) {
            return StdData.of((int)500, (String)String.format("\u5e94\u7528%s\u5df2\u88ab\u6388\u6743,\u4e0d\u80fd\u88ab\u5220\u9664", appInfo.getAppId()));
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/iam/v2/dev/app/tenant"})
    public StdData addDevAppByTenant(@RequestBody(required=false) RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        List sys = this.devSysMapper.findSysByTenant(authoredUser.getTenantSid());
        List sysIds = sys.stream().map(DevelopSys::getId).collect(Collectors.toList());
        List noneGoodsCodes = this.gmcService.getGoodsCodeNone(sysIds);
        if (body != null && body.getId() != null) {
            noneGoodsCodes.add(body.getId());
        }
        List<DevelopSys> developSys = sys.stream().filter(s -> noneGoodsCodes.contains(s.getId())).collect(Collectors.toList());
        developSys.forEach(DevelopLanguage::toLanguage);
        return StdData.ok(developSys);
    }

    @PostMapping(value={"/api/iam/v2/tenant/app/sync/update"})
    public ResponseEntity<?> saveTenantAppSync(@RequestBody ApplicationSyncDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u66f4\u65b0\u79df\u6237\u5e94\u7528\u4fe1\u606f dto={}, timeStamp={}", (Object)dto, (Object)dto.getTimeStamp());
        boolean success = this.produceSyncService.saveTenantAppSync(dto, authoredUser);
        LOGGER.info("\u66f4\u65b0\u79df\u6237\u5e94\u7528\u4fe1\u606f success={}, timeStamp={}", (Object)success, (Object)dto.getTimeStamp());
        return ResponseEntity.ok((Object)success);
    }

    @PostMapping(value={"/api/iam/v2/tenant/auth/sync/save"})
    public ResponseEntity<?> saveTenantAuthSync(@RequestBody AuthSyncDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u79df\u6237\u5e94\u7528\u6388\u6743\u4fe1\u606f\u540c\u6b65 dto={}, timeStamp={}", (Object)dto, (Object)dto.getTimeStamp());
        boolean success = this.produceSyncService.saveTenantAuthSync(dto, authoredUser);
        LOGGER.info("\u79df\u6237\u5e94\u7528\u6388\u6743\u4fe1\u606f\u540c\u6b65 success={}, timeStamp={}", (Object)success, (Object)dto.getTimeStamp());
        return ResponseEntity.ok((Object)success);
    }

    @PostMapping(value={"/api/iam/v2/service/authorization/record"})
    public StdData saveRecord(@RequestBody ServiceAuthorizationRecordDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((Object)dto.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTH_CODE_EMPTY);
        }
        if (authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_SID_EMPTY);
        }
        dto.setUserSid(Long.valueOf(authoredUser.getSid()));
        dto.setUserId(authoredUser.getUserId());
        dto.setUserName(authoredUser.getUserName());
        return StdData.ok((Object)this.serviceAuthorizationRecordService.save(dto));
    }
}

