/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.obsolete;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.tenant.AddUsersToTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.InvitedUserHistoryDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.RegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMiswsDTO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantUpdateService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.I18nUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/tenant"})
public class TenantV2Controller {
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantRegisterService tenantRegisterService;
    @Autowired
    private TenantMetadataCrudService metadataService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private TenantRelationWithUserService tenantRelationWithUserService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private TenantUpdateService tenantUpdateService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private AuthValidateService authValidateService;

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateTenant(@RequestBody RegisterTenantVO registerTenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Assert.hasText((String)registerTenantVO.getTenant().getId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        this.tenantRegisterService.updateRegisterTenantVO(registerTenantVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/update/cbm"})
    public ResponseEntity<?> updateTenant4CBM(@RequestBody RegisterTenantVO registerTenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Assert.hasText((String)registerTenantVO.getTenant().getId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        this.tenantRegisterService.updateRegisterTenantVO4CBM(registerTenantVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/update/info"})
    public StdData<?> updateTenantInfo(@RequestBody TenantDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        dto.setSid(Long.valueOf(user.getTenantSid()));
        this.tenantUpdateService.update(dto);
        return StdData.ok().build();
    }

    @GetMapping(value={"/apps/{appId}"})
    public ResponseEntity<?> getTenantsInApp(@PathVariable(value="appId") String appId) {
        Sys sys = (Sys)this.sysCrudService.findById(appId);
        Assert.notNull((Object)sys, (String)String.format("\u5e94\u7528[%s]\u4e0d\u5b58\u5728\uff01", appId));
        List sysInTenantList = this.sysInTenantCrudService.findBySysSid(sys.getSid());
        if (sysInTenantList.isEmpty()) {
            return new ResponseEntity(Collections.emptyList(), HttpStatus.OK);
        }
        List tenants = this.tenantMapper.getTenantByTenantSids(sysInTenantList.stream().map(x -> x.getTenantSid()).collect(Collectors.toList()));
        return new ResponseEntity((Object)tenants, HttpStatus.OK);
    }

    @PostMapping(value={"/apps/ids"})
    public ResponseEntity<?> getTenantsInAppIds(@RequestBody List<String> appIds) {
        return ResponseEntity.ok((Object)this.tenantQueryService.getSysTenantListMap(appIds));
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/application/purchase/list"})
    public ResponseEntity<?> purchaseApplicationList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody List<SysVO> sysVOS) {
        this.purchaseApplicationService.purchaseApplicationList(user.getTenantId(), user.getUserId(), sysVOS, Boolean.valueOf(false));
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PostMapping(value={"/application/purchase/list/{userId:.+}/{tenantId:.+}"})
    public ResponseEntity<?> purchaseApplicationListByUserId(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId, @RequestBody List<SysVO> sysVOS) {
        long tenantSid = this.tenantCrudService.getSidById(tenantId);
        if (tenantSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        if (!tenantId.equalsIgnoreCase(UserUtils.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/tenant/application/purchase/list/{userId:.+}/{tenantId:.+}", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
        }
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(tenantSid), Long.valueOf(user.getSid())) && !"virtual".equals(userId)) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN, new Object[]{userId});
        }
        this.purchaseApplicationService.purchaseApplicationList(tenantId, userId, sysVOS, Boolean.valueOf(false));
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PostMapping(value={"/metadata/value"})
    public StdData<?> getMetadataValue(@RequestBody TenantMetadataVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        String value = this.metadataService.getTenantMetadataValue(tenant.getSid(), body.getCatalogId(), body.getKey());
        return StdData.ok((Object)value);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/metadata/value/update"})
    public StdData<?> updateMetadataValue(@RequestBody TenantMetadataVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        this.tenantMetadataUpdateService.updateTenantMetadataValue(tenant.getSid(), body.getCatalogId(), body.getKey(), body.getValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata"})
    public ResponseEntity<?> getTenantMetadata(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        List metadataVOList = this.metadataService.getTenantMetadata(tenant.getSid());
        return ResponseEntity.ok((Object)metadataVOList);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/metadata/update"})
    public ResponseEntity<?> updateTenantMetadata(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody List<TenantMetadataVO> body) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        this.tenantMetadataUpdateService.update(tenant, body);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/refuse/apply"})
    public ResponseEntity<?> refuseUserApply(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody InvitedUserHistoryDTO body) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        Assert.isTrue((body.getSid() > 0L ? 1 : 0) != 0, (String)"\u9080\u8bf7\u8bb0\u5f55Sid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.tenantRelationWithUserService.tenantRefuseApply(user.getTenantSid(), body.getSid().longValue());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/add/users"})
    public ResponseEntity<?> addUser(@RequestBody AddUsersToTenantVO body) {
        Assert.hasText((String)body.getTenantId(), (String)"\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Tenant tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
        Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getTenantId()));
        for (String userId : body.getUserIds()) {
            User user = (User)this.userCrudService.findById(userId);
            Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", userId));
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenant.getSid());
            userInTenant.setUserSid(user.getSid());
            this.userInTenantCrudService.create((BaseEntity)userInTenant);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/remove/apply"})
    public ResponseEntity<?> removeUserApply(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody InvitedUserHistoryDTO body) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        Assert.isTrue((body.getSid() > 0L ? 1 : 0) != 0, (String)"\u9080\u8bf7\u8bb0\u5f55Sid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.tenantRelationWithUserService.tenantRemoveApply(user.getTenantSid(), body.getSid().longValue());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/relevantinfo"})
    public ResponseEntity<?> getTenantRelevantInfo(@RequestParam(required=false, value="tenantContent") String tenantContent, @RequestParam(required=false, value="unifiedTaxationCode") String unifiedTaxationCode) {
        List tenantRelevantInfoVOS = this.tenantQueryService.getTenantRelevantInfoVos(tenantContent, unifiedTaxationCode);
        return ResponseEntity.ok((Object)tenantRelevantInfoVOS);
    }

    @GetMapping(value={"/simple/app/{appId}"})
    public ResponseEntity<?> getTenantIdsInApp(@PathVariable(value="appId") String appId) {
        List tenantResultVOS = this.tenantQueryService.getTenantIdsByAppId(appId);
        return ResponseEntity.ok((Object)tenantResultVOS);
    }

    @PostMapping(value={"/sid"})
    public ResponseEntity<?> getTenantSid(@RequestBody List<String> tenantIds) {
        return ResponseEntity.ok((Object)this.tenantQueryService.getTenantSidsByTenantIds(tenantIds));
    }

    @Transactional
    @PostMapping(value={"/auth/consultant"})
    public StdData<?> authConsultant(@Valid @RequestBody TenantAuthDTO tenantAuthDTO) {
        ArrayList resultMapAll = new ArrayList();
        if (!UserUtils.getTenantId().equalsIgnoreCase(tenantAuthDTO.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantAuthDTO.getTenantId());
        if (null == tenant) {
            return StdData.of((int)Integer.parseInt(I18nError.ERROR_21005.getErrorCode()), (String)I18nUtils.getMessage((String)I18nError.ERROR_21005.getCode(), (Object[])new Object[]{tenantAuthDTO.getTenantId()}, (String)"", (Locale)LocaleContextHolder.getLocale()));
        }
        User user = this.userRepository.findFirstByEmailAndType(tenantAuthDTO.getEmail(), Integer.valueOf(0));
        if (null == user) {
            return StdData.of((int)Integer.parseInt(I18nError.ERROR_21001.getErrorCode()), (String)I18nUtils.getMessage((String)I18nError.ERROR_21001.getCode(), (Object[])new Object[]{tenantAuthDTO.getEmail()}, (String)"", (Locale)LocaleContextHolder.getLocale()));
        }
        List tenantList = this.tenantCrudService.findBySourceTenantSid(tenant.getSid());
        tenantList.add(tenant);
        for (Tenant t : tenantList) {
            I18nError i18nError = this.userInTenantOperationService.operateUserInTenant(tenantAuthDTO, t, user);
            if (null == i18nError) continue;
            if (t.getId().equals(tenant.getId())) {
                return StdData.of((int)Integer.parseInt(i18nError.getErrorCode()), (String)I18nUtils.getMessage((String)i18nError.getCode(), null, (String)"", (Locale)LocaleContextHolder.getLocale()));
            }
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("tenantId", t.getId());
            resultMap.put("code", i18nError.getErrorCode());
            resultMap.put("message", I18nUtils.getMessage((String)i18nError.getCode(), null, (String)"", (Locale)LocaleContextHolder.getLocale()));
            resultMapAll.add(resultMap);
        }
        return StdData.ok(resultMapAll);
    }

    @PostMapping(value={"/auth"})
    public StdData<?> getTenantAuthsInDate(@RequestBody(required=false) TenantAuthDTO tenantAuthDTO) {
        if (null == tenantAuthDTO) {
            tenantAuthDTO = new TenantAuthDTO();
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (StringUtils.isEmpty((Object)tenantAuthDTO.getBeginTime())) {
            tenantAuthDTO.setBeginTime(df.format(LocalDateTime.now().minusDays(10L)));
        }
        if (StringUtils.isEmpty((Object)tenantAuthDTO.getEndTime())) {
            tenantAuthDTO.setEndTime(df.format(LocalDateTime.now()));
        }
        return StdData.ok((Object)this.tenantService.getTenantAuthsInDate(tenantAuthDTO));
    }

    @PostMapping(value={"/misws"})
    public StdData<?> getTenantFromMisws(@RequestBody TenantMiswsDTO tenantMiswsDTO) {
        Assert.hasText((String)tenantMiswsDTO.getUserEmail(), (String)"\u7528\u6237\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)this.tenantService.getTenantMiswsInfoList(tenantMiswsDTO));
    }
}

