/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.obsolete;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.StopTypeEnum;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.ActivateUserVO;
import com.digiwin.dap.middleware.iam.domain.user.DisableUserVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryParameterVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByAccountVO;
import com.digiwin.dap.middleware.iam.domain.user.UserAndTenantSimpleInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserBindingWeChatVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserWithOrgsVO;
import com.digiwin.dap.middleware.iam.domain.user.WeChatRegisterUserVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.RegisterService;
import com.digiwin.dap.middleware.iam.service.user.UpdatePasswordService;
import com.digiwin.dap.middleware.iam.service.user.UserBindingWeChatService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryForWeChatService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.obsolete.service.UserV2Service;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/user"})
public class UserV2Controller {
    private static final Logger logger = LoggerFactory.getLogger(UserV2Controller.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RegisterService registerService;
    @Autowired
    private UpdatePasswordService updatePasswordService;
    @Autowired
    private UserInOrgCrudService userInOrgCrudService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private UserInTenantQueryService userInTenantQueryService;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private IdentityService defaultIdentityService;
    @Autowired
    private UserQueryForWeChatService userQueryForWeChatService;
    @Autowired
    private UserBindingWeChatService userBindingWeChatService;
    @Autowired
    private UserV2Service userV2Service;
    @Autowired
    private ServiceAuthorizationRecordService serviceAuthorizationRecordService;
    @Autowired
    private RemoteLMCService remoteLMCService;

    @PostMapping(value={"/register/email"})
    public ResponseEntity<?> registerByEmail(@RequestBody RegisterUserVO body) {
        if (StringUtils.hasLength((String)body.getEmail())) {
            this.checkInsideEmail(body.getEmail());
        }
        try {
            if (StringUtils.hasText((String)body.getPasswordHash())) {
                String password = AES.decrypt((String)body.getPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
                body.setPassword(password);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5bc6\u7801\u5931\u8d25", (Throwable)e);
        }
        this.registerService.registerByEmailActivationLink(body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/register/mobilephone"})
    public ResponseEntity<?> registerByMobilePhone(@RequestBody RegisterUserVO body, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) Sys sys) {
        try {
            if (StringUtils.hasText((String)body.getPasswordHash())) {
                String password = AES.decrypt((String)body.getPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
                body.setPassword(password);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5bc6\u7801\u5931\u8d25", (Throwable)e);
        }
        this.registerService.registerByTelephoneVerifyCode(body);
        LoginUser loginUser = new LoginUser(body.getId(), sys, body.getPassword());
        loginUser.setGclid(body.getGclid());
        IamAuthoredUser user = this.defaultIdentityService.login(loginUser);
        this.remoteLMCService.saveAgreeAgreementChangeLog(UserUtils.getAuthoredSys(), (AuthoredUser)user, user.getAgreeAgreement());
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/activate"})
    public ResponseEntity<?> activateUser(@RequestBody ActivateUserVO body) {
        if (body.getSid() == 0L) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Strings.isBlank((String)body.getActivateCode())) {
            throw new IllegalArgumentException("\u6fc0\u6d3b\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Strings.isBlank((String)body.getAccount())) {
            throw new IllegalArgumentException("\u90ae\u7bb1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.registerService.activateUser(body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/apply/activate"})
    public ResponseEntity<?> applyActivate(@RequestBody ActivateUserVO body) {
        Assert.notNull((Object)body.getAccount(), (String)"\u90ae\u7bb1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue((boolean)StringUtil.checkEmail((String)body.getAccount()), (String)String.format("\u90ae\u7bb1\u8d26\u53f7[%s]\u683c\u5f0f\u4e0d\u89c4\u8303\uff01", body.getAccount()));
        this.registerService.applyActivate(body.getAccount());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/isconfirm"})
    public ResponseEntity<?> checkUserIsConfirm(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff01");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        Assert.notNull((Object)tenant, (String)"\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4e0d\u5b58\u5728\uff01");
        int isConfirm = tenant.getConfirm();
        return new ResponseEntity((Object)isConfirm, HttpStatus.OK);
    }

    @PostMapping(value={"/isenterprise"})
    public ResponseEntity<?> checkUserIsEnterprise(@RequestBody RequestParameterVO body) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        long userSid = body.getSid();
        if (body.getSid() == 0L) {
            userSid = this.userCrudService.getSidById(body.getId());
        }
        boolean isEnterprise = this.userCrudService.isEnterprise(userSid);
        return new ResponseEntity((Object)isEnterprise, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update/headimageurl"})
    public ResponseEntity<?> updateUserImageUrl(@RequestBody UserInfo body) {
        if (body.getSid() != UserUtils.getUserSid()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
        }
        User user = (User)this.userCrudService.findBySid(body.getSid());
        Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728", body.getSid()));
        user.setHeadImageUrl(body.getHeadImageUrl());
        this.userCrudService.update((BaseEntity)user);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/enable"})
    public ResponseEntity<?> enableUser(@RequestBody DisableUserVO body) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        User user = body.getSid() == 0L ? (User)this.userCrudService.findById(body.getId()) : (User)this.userCrudService.findBySid(body.getSid());
        if (user != null) {
            user.setDisabled(false);
            user.setDeleted(false);
            this.userCrudService.update((BaseEntity)user);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/mobilephone/canused"})
    public ResponseEntity<?> checkMobilePhoneCanUsed(@RequestBody Map<String, String> body) {
        boolean flag;
        String telephoneKey = "telephone";
        if (!body.containsKey(telephoneKey)) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isInt((String)body.get(telephoneKey))) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u4e0d\u89c4\u8303\uff01");
        }
        String userId = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(body.get(telephoneKey), body.get(telephoneKey), body.get(telephoneKey), Integer.valueOf(0));
        boolean bl = flag = Objects.nonNull(user) && !userId.equals(user.getId());
        if (flag) {
            result.put("status", true);
            result.put("message", "");
        } else {
            result.put("status", false);
            result.put("message", "\u5df2\u88ab\u7528\u6236\u4f7f\u7528");
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PostMapping(value={"/org"})
    public ResponseEntity<?> getOrgInUser(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (body.getSid() == 0L) {
            body.setSid(this.userCrudService.getSidById(body.getId()));
        }
        User user = (User)this.userCrudService.findBySid(body.getSid());
        Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getSid()));
        List queryUserInOrgResultVOList = this.userInOrgCrudService.getUserInOrgByUser(authoredUser.getTenantSid(), user.getSid());
        UserWithOrgsVO userWithOrgsVO = new UserWithOrgsVO(user, queryUserInOrgResultVOList);
        return new ResponseEntity((Object)userWithOrgsVO, HttpStatus.OK);
    }

    @PostMapping(value={"/org/simple"})
    public ResponseEntity<?> getOrgInUserSimple(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (body.getSid() == 0L) {
            body.setSid(this.userCrudService.getSidById(body.getId()));
        }
        if (authoredUser.getSid() != body.getSid()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
        }
        User user = (User)this.userCrudService.findBySid(body.getSid());
        Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getSid()));
        List orgInUserVOS = this.userInOrgCrudService.getOrgInUserVO(authoredUser.getTenantSid(), user.getSid());
        return new ResponseEntity((Object)orgInUserVOS, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/org/update"})
    public ResponseEntity<?> updateUserInOrgByUser(@RequestBody UserWithOrgsVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        if (body.getSid() == 0L && ObjectUtils.isEmpty((Object)body.getId())) {
            throw new IllegalArgumentException("user.Id\u548cuser.Sid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (body.getSid() == 0L) {
            body.setSid(this.userCrudService.getSidById(body.getId()));
        }
        User user = (User)this.userCrudService.findBySid(body.getSid());
        Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getId()));
        if (!"onlyAppend".equals(body.getUpdateMode())) {
            body.setUpdateMode("all");
        }
        Assert.notNull((Object)body.getUserInOrgs(), (String)"userInOrgs\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (QueryUserInOrgResultVO queryUserInOrgResultVO : body.getUserInOrgs()) {
            if (queryUserInOrgResultVO.getOrgSid() != 0L || queryUserInOrgResultVO.getOrgUri() != null) continue;
            throw new IllegalArgumentException("\u7ec4\u7ec7Sid\u548c\u7ec4\u7ec7uri\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        List queryRoleResultVOList = this.userInRoleMapper.queryUserInRoleByUser(authoredUser.getTenantSid(), user.getSid());
        HashMap<Long, QueryRoleResultVO> userInRoleVOMap = new HashMap<Long, QueryRoleResultVO>();
        for (QueryRoleResultVO queryRoleResultVO : queryRoleResultVOList) {
            userInRoleVOMap.put(queryRoleResultVO.getSid(), queryRoleResultVO);
        }
        int[] ids = new int[body.getUserInOrgs().size()];
        for (QueryUserInOrgResultVO userInOrg : body.getUserInOrgs()) {
            if (userInOrg.getOrgSid() == 0L) {
                long orgSid = this.orgQueryService.getOrgSidByUri(authoredUser.getTenantSid(), userInOrg.getOrgUri());
                userInOrg.setOrgSid(orgSid);
            }
            Org org = (Org)this.orgCrudService.findBySid(userInOrg.getOrgSid());
            Assert.notNull((Object)org, (String)String.format("\u7ec4\u7ec7[%s]\u4e0d\u5b58\u5728\uff01", userInOrg.getOrgSid()));
            if (!ObjectUtils.isEmpty((Object)userInOrg.getRoleId()) && !userInOrg.getRoleId().equals("[empty]")) {
                QueryRoleResultVO userInRoleDB = this.userInRoleMapper.queryUserInRoleByRoleId(authoredUser.getTenantSid(), userInOrg.getRoleId());
                Assert.notNull((Object)userInRoleDB, (String)String.format("\u6b64\u89d2\u8272[%s]\u4e0d\u5b58\u5728\uff01", userInOrg.getRoleId()));
                if (!userInRoleVOMap.containsKey(userInRoleDB.getSid())) {
                    throw new BusinessException((ErrorHandler)I18nError.ROLE_USER_RELATION_NOT_EXIST, new Object[]{userInRoleDB.getSid()});
                }
                userInOrg.setRoleName(userInRoleDB.getName());
                userInOrg.setRoleSid(userInRoleDB.getSid());
                userInOrg.setRoleId(userInRoleDB.getId());
            } else {
                userInOrg.setRoleId("[empty]");
                userInOrg.setRoleName("[empty]");
            }
            if (!"all".equals(body.getUpdateMode())) continue;
            if (userInOrg.getPriority() < 0 || userInOrg.getPriority() > body.getUserInOrgs().size() || ids[userInOrg.getPriority()] == 1) {
                throw new IllegalArgumentException(String.format("\u4f18\u5148\u7ea7[%s]\u8bbe\u7f6e\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u5c0f\u4e8e\u6807\u7b7e\u5217\u8868\u957f\u5ea6\u4e14\u4e92\u4e0d\u76f8\u7b49\u7684\u6574\u6570!", userInOrg.getPriority()));
            }
            ids[userInOrg.getPriority()] = 1;
        }
        this.userV2Service.updateUserInOrgByUser(authoredUser.getTenantSid(), user.getSid(), body.getUpdateMode(), body.getUserInOrgs());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/tenant/query"})
    public ResponseEntity<?> queryUserCanSeeTenantAndInvitedHistory(@RequestBody QueryParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getType(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        List results = this.userInTenantQueryService.queryUserRelatedTenant(body.getType(), user, Boolean.valueOf(true));
        return new ResponseEntity((Object)results, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/refuse/invitation"})
    public ResponseEntity<?> refuseTenantInvitation(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((body.getSid() > 0L ? 1 : 0) != 0, (String)"\u9080\u8bf7\u8bb0\u5f55Sid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        long userSid = authoredUser.getSid();
        this.userInTenantOperationService.refuseTenantInvitation(userSid, body.getSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/exit/tenant"})
    public ResponseEntity<?> exitTenant(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant;
        if (body.getId() == null && body.getSid() == 0L) {
            throw new IllegalArgumentException("\u4f01\u4e1aSid\u548c\u4f01\u4e1aId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
        Assert.notNull((Object)user, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\uff01", user.getId()));
        if (body.getSid() != 0L) {
            tenant = (Tenant)this.tenantCrudService.findBySid(body.getSid());
            Assert.notNull((Object)tenant, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u8be5\u79df\u6237[%s]\uff01", body.getSid()));
        } else {
            tenant = (Tenant)this.tenantCrudService.findById(body.getId());
            Assert.notNull((Object)tenant, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u8be5\u79df\u6237[%s]\uff01", body.getId()));
        }
        this.userInTenantOperationService.exitTenant(Long.valueOf(tenant.getSid()), user);
        this.serviceAuthorizationRecordService.updateRecordStop(tenant.getSid(), user.getSid(), StopTypeEnum.ACTIVE_EXIT_STOP.getValue());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/register/wechat"})
    public ResponseEntity<?> registerByWeChat(@RequestBody @Valid WeChatRegisterUserVO weChatRegisterUserVO, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device) {
        this.registerService.registerByWeChat(weChatRegisterUserVO);
        IamAuthoredUser authoredUser = this.userQueryForWeChatService.getIamAuthoredUser(weChatRegisterUserVO.getOpenId(), device);
        this.remoteLMCService.saveAgreeAgreementChangeLog(UserUtils.getAuthoredSys(), (AuthoredUser)authoredUser, authoredUser.getAgreeAgreement());
        return new ResponseEntity((Object)authoredUser, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/binding/openid"})
    public ResponseEntity<?> userBindingWeChat(@RequestBody @Valid UserBindingWeChatVO userBindingWeChatVO, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device) {
        this.userBindingWeChatService.bindingWeChat(userBindingWeChatVO);
        IamAuthoredUser authoredUser = this.userQueryForWeChatService.getIamAuthoredUser(userBindingWeChatVO.getOpenId(), device);
        return new ResponseEntity((Object)authoredUser, HttpStatus.OK);
    }

    @GetMapping(value={"/{userSid}/tenant/{tenantSid}/simple"})
    public ResponseEntity<?> getUserAndTenantSimpleInfo(@PathVariable(value="userSid") long userSid, @PathVariable(value="tenantSid") long tenantSid) {
        if (UserUtils.getTenantSid() != tenantSid) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        UserAndTenantSimpleInfo userAndTenantSimpleInfo = this.userQueryService.getUserAndTenantSimpleInfo(userSid, tenantSid);
        return ResponseEntity.ok((Object)userAndTenantSimpleInfo);
    }

    private void checkInsideEmail(String email) {
        if (!ObjectUtils.isEmpty((Object)email) && 0 == this.envProperties.getCloud() && email.toLowerCase().contains("@digiwin.com")) {
            throw new BusinessException((ErrorHandler)I18nError.USER_REGISTER_ERROR, new Object[]{email});
        }
    }

    @PostMapping(value={"/joined/tenants"})
    public ResponseEntity<?> userBindingWeChat(@RequestBody UpdatePasswordByAccountVO vo) {
        if (ObjectUtils.isEmpty((Object)vo.getAccount())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_TELEPHONE_EMPTY);
        }
        List result = this.userQueryService.getUserJoinedTenants(vo.getAccount());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

