/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.service;

import com.digiwin.dap.middleware.iam.domain.auth.AccessTenant;
import com.digiwin.dap.middleware.iam.domain.auth.AccessUser;
import com.digiwin.dap.middleware.iam.support.ram.AccessSecurityService;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/identity"})
public class SpAccessController {
    private static final Logger logger = LoggerFactory.getLogger(SpAccessController.class);
    @Autowired
    private AccessSecurityService accessSecurityService;

    @PostMapping(value={"/access/analyze"})
    public ResponseEntity<?> accessUser(@Valid @RequestBody AccessUser body) throws Exception {
        body.afterPropertiesSet();
        boolean noneCheck = this.accessSecurityService.noneCheck(body.getAppId(), body.getMethod(), body.path());
        if (!noneCheck) {
            this.accessSecurityService.serviceCheck(body);
        }
        return ResponseEntity.ok((Object)body);
    }

    @PostMapping(value={"/trust/analyze"})
    public ResponseEntity<?> accessTenant(@Valid @RequestBody AccessTenant body) throws Exception {
        body.afterPropertiesSet();
        boolean trust = this.accessSecurityService.trustChainCheck(body);
        if (!trust) {
            this.accessSecurityService.authCheck(body);
        }
        return ResponseEntity.ok((Object)body);
    }
}

