/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.service;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.service.permission.AppWithApiRelationVO;
import com.digiwin.dap.middleware.iam.entity.ServiceMetadataApi;
import com.digiwin.dap.middleware.iam.service.service.permission.SpMetadataApiRelationService;
import com.digiwin.dap.middleware.iam.service.service.permission.SpMetadataApiService;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.github.pagehelper.PageSerializable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/service/permission"})
public class SpMetadataController {
    private Logger logger = LoggerFactory.getLogger(SpMetadataController.class);
    @Autowired
    private SpMetadataApiService spMetadataApiService;
    @Autowired
    private SpMetadataApiRelationService spMetadataApiRelationService;
    @Autowired
    private RamService ramService;

    @PostMapping(value={"/metadata/api/import"})
    @Transactional
    public StdData importMetadataApi(@RequestBody List<ServiceMetadataApi> serviceMetadataApiList) {
        if (serviceMetadataApiList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        this.spMetadataApiService.importMetadataApis(serviceMetadataApiList);
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/api/delete"})
    @Transactional
    public StdData deleteMetadataApi(@RequestBody List<Long> apiSids) {
        this.spMetadataApiService.delete(apiSids);
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/api/anonymous"})
    @Transactional
    public StdData updateMetadataApiWhiteList(@RequestBody List<ServiceMetadataApi> apiList) {
        this.spMetadataApiService.updateWhiteApis(apiList);
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/apis"})
    public StdData getList(@RequestParam(required=false) String app, @RequestParam(required=false) String path, @RequestParam(required=false) String content, @RequestParam(required=false) Boolean anonymous, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="10") Integer pageSize, @RequestParam(required=false, defaultValue="create_date desc,app,method,path") String orderBy) {
        PageSerializable pageSerializable = this.spMetadataApiService.getList(app, path, anonymous, content, pageNum, pageSize, orderBy);
        return StdData.ok((Object)pageSerializable);
    }

    @GetMapping(value={"/metadata/api/export"})
    public void exportApis(@RequestParam String app, HttpServletResponse response) throws Exception {
        List serviceApis = this.spMetadataApiService.exportApis(app);
        String jsonString = JsonUtils.createObjectMapper().writeValueAsString((Object)serviceApis);
        ServletOutputStream out = response.getOutputStream();
        String fileName = String.format("%s_api_metadata_%s", app, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        response.setContentType("application/force-download");
        response.addHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(String.format("%s.json", fileName), "utf-8"));
        File file = File.createTempFile(fileName, ".json");
        file.deleteOnExit();
        boolean fileCreated = file.createNewFile();
        if (!fileCreated) {
            this.logger.error("file not created");
        }
        try (OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
             FileInputStream fis = new FileInputStream(file);){
            write.write(jsonString);
            ((Writer)write).flush();
            ((Writer)write).close();
            ServletOutputStream os = response.getOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = fis.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            fis.close();
            os.close();
        }
    }

    @PostMapping(value={"/metadata/api/relation"})
    @Transactional
    public StdData relatedAppWithApi(@RequestBody @Valid AppWithApiRelationVO appWithApiRelationVO) {
        this.spMetadataApiRelationService.save(appWithApiRelationVO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/api/relation/delete"})
    @Transactional
    public StdData deleteAppWithApiRelation(@RequestBody List<Long> sids) {
        this.spMetadataApiRelationService.delete(sids);
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/relation/api"})
    public StdData getRelations(@RequestParam Long dataSid, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="9999") Integer pageSize) {
        return StdData.ok((Object)this.spMetadataApiRelationService.getList(dataSid, pageNum, pageSize));
    }

    @GetMapping(value={"/metadata/relation"})
    public StdData getRelatedAppInfo(@RequestParam Long apiSid) {
        return StdData.ok((Object)this.spMetadataApiRelationService.getRelationInfo(apiSid));
    }

    @GetMapping(value={"/goods/metadata/relation/api"})
    public StdData<?> getGoodsRelation(@RequestParam String uri, @RequestParam(required=false, defaultValue="0") Boolean showAll, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="10") Integer pageSize) {
        return StdData.ok((Object)this.ramService.getGoodsRelatedApis(uri, showAll, pageNum, pageSize));
    }
}

