/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.service;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.service.permission.TenantTrustRelationConditionVO;
import com.digiwin.dap.middleware.iam.domain.service.permission.TenantTrustRelationVO;
import com.digiwin.dap.middleware.iam.entity.ServiceTenantTrustRelation;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.ServicePermissionMapper;
import com.digiwin.dap.middleware.iam.service.service.permission.SpTenantTrustRelationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/service/permission"})
public class SpTenantTrustRelationController {
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ServicePermissionMapper servicePermissionMapper;
    @Autowired
    private SpTenantTrustRelationService spTenantTrustRelationService;

    @PostMapping(value={"/tenant/trust/relation/add"})
    public StdData<?> addRelation(@RequestBody TenantTrustRelationVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setOwnerSid(Long.valueOf(authoredUser.getTenantSid()));
        body.setOwnerId(authoredUser.getTenantId());
        if (body.getOwnerSid().equals(body.getTargetSid())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANTS_NOT_NEED_TRUST_THEMSELVES);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(body.getTargetSid().longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{String.format("%s(%s)", body.getTargetId(), body.getTargetSid())});
        }
        body.setTargetId(tenant.getId());
        ServiceTenantTrustRelation tenantTrustRelation = this.spTenantTrustRelationService.findByOwnerSidAndTargetId(body.getOwnerSid().longValue(), body.getTargetSid().longValue());
        if (tenantTrustRelation == null) {
            this.spTenantTrustRelationService.create((BaseEntity)body.doForward());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/tenant/trust/relation/del"})
    public StdData<?> delRelation(@RequestBody TenantTrustRelationVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        ServiceTenantTrustRelation tenantTrustRelation = (ServiceTenantTrustRelation)this.spTenantTrustRelationService.findBySid(body.getSid().longValue());
        if (tenantTrustRelation != null) {
            if (tenantTrustRelation.getOwnerSid().longValue() != authoredUser.getTenantSid()) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_DELETE_ERROR3);
            }
            this.spTenantTrustRelationService.deleteById(body.getSid().longValue());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/tenant/trust/relation/find"})
    public StdData<?> findRelation(@RequestBody TenantTrustRelationConditionVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setOwnerSid(Long.valueOf(authoredUser.getTenantSid()));
        List page = this.servicePermissionMapper.findByPage(body, body.getPageNum().intValue(), body.getPageSize().intValue());
        return StdData.ok((Object)new PageSerializable(page));
    }
}

