/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.upgrade;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.support.dump.escloud.EsCloudService;
import com.digiwin.dap.middleware.lmc.service.LogLevelService;
import com.digiwin.dap.middleware.lmc.service.impl.LogLevelServiceImpl;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/console"})
public class ConsoleController {
    @Autowired
    private EsCloudService esCloudService;
    private static LogLevelService logLevelService = LogLevelServiceImpl.logLevelInstance();

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/esc/function/repair"})
    public ResponseEntity<?> repairFunction() {
        return ResponseEntity.ok((Object)this.esCloudService.repairFunction());
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/esc/function/repair"})
    public ResponseEntity<?> repairFunctionDel(@RequestBody Map<String, String> body) {
        return ResponseEntity.ok((Object)this.esCloudService.repairFunctionDel(body.get("hash")));
    }

    @PutMapping(value={"/log/{logLevel}"})
    public ResponseEntity<?> updateLogLevel(@PathVariable String logLevel) {
        String log4j2Level = logLevelService.updateLogLevel(logLevel);
        return ResponseEntity.ok((Object)StdData.ok((Object)log4j2Level));
    }
}

