/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.upgrade;

import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.stream.producer.domain.TenantMessageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/email/test"})
public class EmailTestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailTestController.class);
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/register"})
    public ResponseEntity<?> getAllCreatedTenant(@RequestBody Tenant tenant) {
        this.messageService.sendRegisterMessage(tenant, "");
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/confirm"})
    public ResponseEntity<?> confirmTenant(@RequestBody TenantAuditVO tenantAuditVO) {
        this.messageService.sendConfirmSuccessMessage(tenantAuditVO);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/refuse"})
    public ResponseEntity<?> refuseTenant(@RequestBody TenantAuditVO tenantAuditVO) {
        this.messageService.sendConfirmFailMessage(tenantAuditVO);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/cancel"})
    public ResponseEntity<?> cancelTenant(@RequestBody TenantAuditVO tenantAuditVO) {
        this.messageService.sendCancelTenantMessage(tenantAuditVO.getSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/invite"})
    public ResponseEntity<?> invite(@RequestBody TenantMessageInfo tenantMessageInfo) {
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/apply"})
    public ResponseEntity<?> apply(@RequestBody TenantMessageInfo tenantMessageInfo) {
        this.messageService.sendApplyMessage(tenantMessageInfo.getUserSid(), tenantMessageInfo.getSid(), null);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/applyJoin"})
    public ResponseEntity<?> applyJoin(@RequestBody TenantMessageInfo tenantMessageInfo) {
        this.messageService.sendApplyJoinTenantMessage(tenantMessageInfo.getUserSid(), tenantMessageInfo.getSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/refuseJoin"})
    public ResponseEntity<?> refuseJoin(@RequestBody TenantMessageInfo tenantMessageInfo) {
        this.messageService.sendRefuseJoinTenantMessage(tenantMessageInfo.getUserSid(), tenantMessageInfo.getSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/log/{count}"})
    public ResponseEntity<?> testLogInfo(@PathVariable Integer count) {
        for (int i = 0; i < count; ++i) {
            LOGGER.info("count={}, \u6253\u5370\u6d4b\u8bd5\u7684\u65e5\u5fd7\u957f\u5ea6\u662f50\u6587\u5b57\u6253\u5370\u6d4b\u8bd5\u7684\u65e5\u5fd7\u957f\u5ea6\u662f50\u4e2a\u6587\u5b57\u6253\u5370\u6d4b\u8bd5\u7684\u65e5\u5fd7\u957f\u5ea6\u662f50\u4e2a\u6587\u5b57", (Object)count);
        }
        return ResponseEntity.ok((Object)count);
    }
}

