/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.upgrade;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.domain.ValidableList;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.UpdatePasswordVO;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.UserBasicInfo;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.UserImportInfo;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.UserWithTenantVo;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadataSyncVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.user.DingTalkImportInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.entity.SyncTenantAuthScope;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.SyncTenantAuthScopeRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.authentication.TenantCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.initialize.ImportDataService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.PurchaseService;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/integrate/import"})
public class IntegrateImportController {
    private static final Logger logger = LoggerFactory.getLogger(IntegrateImportController.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private ImportDataService importDataService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserBasicInfoUpdateService userBasicInfoUpdateService;
    @Autowired
    private TenantCertificationCrudService tenantCertificationCrudService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PurchaseService purchaseService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private SyncTenantAuthScopeRepository syncTenantAuthScopeRepository;
    @Autowired
    private OtherValidateService otherValidateService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private ChangeLogService changeLogService;

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/escloud/tenant"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> importEscloudTenants(@RequestBody @Validated ValidableList<UserBasicInfo> body) {
        Boolean allowed = (Boolean)RedisUtils.get((Object)"escloud_import_tenant_allowed", Boolean.TYPE);
        ArrayList usersMapList = new ArrayList();
        if (allowed == null || allowed.booleanValue()) {
            for (UserBasicInfo current : body) {
                logger.info(String.format("0.\u670d\u52a1\u4e91\u540c\u6b65\u79df\u6237\u63a5\u53e3,\u540c\u6b65\u79df\u6237\u4fe1\u606f\uff0c%s\uff01", JsonUtils.objToJson((Object)current)));
                UserImportInfo userInfo = current.getUser();
                UserImportInfo newUserInfo = new UserImportInfo();
                org.springframework.beans.BeanUtils.copyProperties((Object)userInfo, (Object)newUserInfo);
                User user = this.generateServiceCloudUser(newUserInfo);
                if (!"ServiceCloud".equalsIgnoreCase(user.getComeFrom())) {
                    HashMap<String, String> userMap = new HashMap<String, String>();
                    userMap.put("serviceCloudUserId", userInfo.getId());
                    userMap.put("digiwinUserId", user.getId());
                    usersMapList.add(userMap);
                    logger.error(String.format("0-1.\u670d\u52a1\u4e91\u540c\u6b65\u79df\u6237\u63a5\u53e3,\u7528\u6237%s\u5df2\u5728\u9f0e\u6377\u4e91\u6ce8\u518c\uff0c\u4e0d\u80fd\u88ab\u670d\u52a1\u4e91\u7528\u6237%s\u66f4\u65b0", user.getId(), userInfo.getId()));
                }
                Tenant tenant = this.importDataService.synDataFromDefaultTenant(userInfo, user);
                if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
                    TenantCertification certification = this.tenantCertificationCrudService.findByTenantSid(tenant.getSid());
                    if (certification == null) {
                        certification = new TenantCertification();
                        certification.setPassed(true);
                        certification.setTenantSid(tenant.getSid());
                        this.tenantCertificationCrudService.create((BaseEntity)certification);
                    } else {
                        certification.setPassed(true);
                        this.tenantCertificationCrudService.update((BaseEntity)certification);
                    }
                }
                logger.info("3.\u5f00\u59cb\u540c\u6b65\u79df\u6237\u4e0b\u7684\u89d2\u8272\u4fe1\u606f\uff0c%s\uff01", (Object)JsonUtils.objToJson((Object)current.getRoleInfo()));
                this.importDataService.updateTenantRoles(tenant, current.getRoleInfo(), Boolean.valueOf(false), null);
                logger.info("4.\u5f00\u59cb\u540c\u6b65\u79df\u6237\u4e0b\u7684\u5f52\u6237\u4fe1\u606f\uff0c%s\uff01", (Object)JsonUtils.objToJson((Object)current.getRoleInfo()));
                this.importDataService.updateUserMapping(Long.valueOf(tenant.getSid()), Long.valueOf(user.getSid()), user.getId(), current.getMappingInfo());
            }
        } else {
            throw new BusinessException((ErrorHandler)I18nError.PLEASE_VISIT_DURING_SERVICE_HOURS);
        }
        return ResponseEntity.ok(usersMapList);
    }

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/escloud"})
    public ResponseEntity<?> importEscloudData(@RequestBody @Valid ValidableList<UserBasicInfo> body) {
        ArrayList usersMapList = new ArrayList();
        try {
            for (UserBasicInfo current : body) {
                logger.info("==============0.\u670d\u52a1\u4e91\u540c\u6b65\u7528\u6237\u63a5\u53e3,\u7528\u6237[{}]\u6570\u636e\u5f00\u59cb\u5bfc\u5165\uff01================UserBasicInfo\uff1a{}", (Object)current.getUser().getId(), (Object)JsonUtils.writeValue((Object)current));
                UserImportInfo userInfo = current.getUser();
                UserImportInfo newUserInfo = new UserImportInfo();
                org.springframework.beans.BeanUtils.copyProperties((Object)userInfo, (Object)newUserInfo);
                User user = this.generateServiceCloudUser(newUserInfo);
                if (!"ServiceCloud".equalsIgnoreCase(user.getComeFrom())) {
                    HashMap<String, String> userMap = new HashMap<String, String>();
                    userMap.put("serviceCloudUserId", userInfo.getId());
                    userMap.put("digiwinUserId", user.getId());
                    usersMapList.add(userMap);
                    logger.error("0-1.\u670d\u52a1\u4e91\u540c\u6b65\u7528\u6237\u63a5\u53e3,\u7528\u6237{}\u5df2\u5728\u9f0e\u6377\u4e91\u6ce8\u518c\uff0c\u4e0d\u80fd\u88ab\u670d\u52a1\u4e91\u7528\u6237{}\u66f4\u65b0", (Object)user.getId(), (Object)userInfo.getId());
                }
                logger.info("0-2.\u7528\u6237[{}]\u7528\u6237\u4fe1\u606f\u5bfc\u5165\u6210\u529f\uff01", (Object)current.getUser().getId());
                Tenant tenant = this.importDataService.updateTenant(userInfo.getTenantId(), userInfo.getTenantName(), user);
                logger.info("1.\u7528\u6237[{}]\u7ed1\u5b9a\u89d2\u8272[{}]\u4fe1\u606f\uff01", (Object)current.getUser().getId(), (Object)JsonUtils.objToJson((Object)current.getRoleInfo()));
                this.importDataService.updateUserRoles(tenant, user, current.getRoleInfo());
                logger.info("2.\u7528\u6237[{}]\u7ed1\u5b9a\u5f52\u6237[{}]\u4fe1\u606f\uff01", (Object)current.getUser().getId(), (Object)JsonUtils.objToJson((Object)current.getMappingInfo()));
                this.importDataService.updateUserMapping(Long.valueOf(tenant.getSid()), Long.valueOf(user.getSid()), user.getId(), current.getMappingInfo());
                this.importDataService.updateDigiwinDefaultOrg(tenant, user, "root");
                logger.info("=================\u7528\u6237[{}]\u6570\u636e\u5bfc\u5165\u7ed3\u675f\uff01=======================", (Object)current.getUser().getId());
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return ResponseEntity.ok(usersMapList);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/escloud/update"})
    public ResponseEntity<?> updateEscloudUser(@RequestBody @Valid UserBasicInfo body) {
        UserImportInfo userInfo = body.getUser();
        Assert.notNull((Object)userInfo.getOldId(), (String)"\u539f\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = (User)this.userCrudService.findById(userInfo.getOldId());
        Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\u65e0\u6cd5\u4fee\u6539\uff01", userInfo.getOldId()));
        if (this.userCrudService.existsById(userInfo.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_9, new Object[]{userInfo.getId(), userInfo.getOldId(), userInfo.getId()});
        }
        userInfo.setSid(user.getSid());
        userInfo.setComeFrom("ServiceCloud");
        this.userBasicInfoUpdateService.updateUser((UserInfo)userInfo);
        Tenant tenant = this.importDataService.updateTenant(userInfo.getTenantId(), userInfo.getTenantName(), user);
        this.importDataService.updateUserMapping(Long.valueOf(tenant.getSid()), Long.valueOf(user.getSid()), user.getId(), body.getMappingInfo());
        this.importDataService.updateUserRoles(tenant, user, body.getRoleInfo());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/escloud/update/potential"})
    public ResponseEntity<?> importEscloudPotentialData(@RequestBody ValidableList<UserImportInfo> body) {
        ArrayList usersMapList = new ArrayList();
        try {
            List tenantIds = body.stream().map(UserImportInfo::getTenantId).collect(Collectors.toList());
            List tenants = this.tenantRepository.findInIds(tenantIds);
            ArrayList<Tenant> changeTenants = new ArrayList<Tenant>();
            for (UserImportInfo current : body) {
                Tenant tenant = tenants.stream().filter(t -> t.getId().equals(current.getTenantId())).findFirst().orElse(null);
                if (tenant == null || ObjectUtil.equal((Object)current.getPotentialCustomerId(), (Object)tenant.getPotentialCustomerId())) continue;
                Tenant newTenant = new Tenant();
                org.springframework.beans.BeanUtils.copyProperties((Object)tenant, (Object)newTenant);
                changeTenants.add(newTenant);
                newTenant.setPotentialCustomerId(current.getPotentialCustomerId());
            }
            this.tenantCrudService.saveAll(changeTenants);
            this.changeLogService.batchSaveTenantChangeLog(tenants, changeTenants, ChangeTypeEnum.TENANT_POTENTIAL_CUSTOMER_ID_UPDATE.getName(), Arrays.asList("potentialCustomerId"));
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return ResponseEntity.ok(usersMapList);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/escloud/update/password"})
    public ResponseEntity<?> updateEscloudUserPassword(@RequestBody UpdatePasswordVO body) {
        Assert.notNull((Object)body.getId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)body.getSalt(), (String)"\u968f\u673a\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)body.getPasswordHash(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = (User)this.userCrudService.findById(body.getId());
        if (user != null) {
            String serviceCloud = "ServiceCloud";
            if (user.getComeFrom() != null && "ServiceCloud".equals(user.getComeFrom())) {
                user.setSalt(body.getSalt());
                user.setPassword(body.getPasswordHash());
                user.setChanged(true);
                EntityUtils.setModifyFields((BaseEntity)user);
                this.userRepository.save((Object)user);
            }
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @PostMapping(value={"/escloud/user/sync"})
    public StdData esCloudUserSync(@RequestBody UpdatePasswordVO updatePasswordVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!(StringUtils.hasLength((String)updatePasswordVO.getId()) && StringUtils.hasLength((String)updatePasswordVO.getPasswordHash()) && StringUtils.hasLength((String)updatePasswordVO.getSalt()))) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        List whiteList = this.whiteListService.getWhiteList("SERVICE_CLOUD_SYNC_PASSWORD_USER");
        if (!whiteList.contains(authoredUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_RESET_PASSWORD, new Object[]{authoredUser.getUserId()});
        }
        User user = (User)this.userCrudService.findById(updatePasswordVO.getId());
        if (Objects.isNull(user)) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        if (!StringUtils.hasLength((String)user.getComeFrom()) || !"ServiceCloud".equals(user.getComeFrom())) {
            throw new BusinessException("User come from not ServiceCloud");
        }
        User oldUser = new User();
        org.springframework.beans.BeanUtils.copyProperties((Object)user, (Object)oldUser);
        user.setSalt(updatePasswordVO.getSalt());
        user.setPassword(updatePasswordVO.getPasswordHash());
        user.setChanged(true);
        EntityUtils.setModifyFields((BaseEntity)user);
        this.userRepository.save((Object)user);
        this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_PASSWORD_UPDATE.getName(), (Object)oldUser, (Object)user, Arrays.asList(ChangeTypeEnum.USER_PASSWORD_UPDATE.getPrimaryKey()), Arrays.asList("salt", "password", "changed"));
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/fii/tenant"})
    public ResponseEntity<?> importFiiTenant(@RequestBody UserWithTenantVo body) {
        User user = this.generateUser(body.getUserInfo(), "fii");
        TenantVO tenantVO = new TenantVO();
        tenantVO.setComeFrom("FII");
        BeanUtils.mergeDifferentTypeObject((Object)body.getTenantInfo(), (Object)tenantVO);
        TenantCertification tenantCertification = new TenantCertification();
        BeanUtils.mergeDifferentTypeObject((Object)body.getTenantInfo(), (Object)tenantCertification);
        this.importDataService.createTenant(tenantVO, tenantCertification, user);
        Tenant dbTenant = (Tenant)this.tenantCrudService.findById(tenantVO.getId());
        if (body.getMappingInfo() != null) {
            this.importDataService.updateUserMapping(Long.valueOf(dbTenant.getSid()), Long.valueOf(user.getSid()), user.getId(), Arrays.asList(body.getMappingInfo()));
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/fii/user"})
    public ResponseEntity<?> importFiiUser(@RequestBody List<UserImportInfo> body) {
        for (UserImportInfo current : body) {
            Assert.notNull((Object)current.getTenantId(), (String)String.format("\u7528\u6237[%s]\u7684\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01", current.getId()));
            Tenant dbTenant = (Tenant)this.tenantCrudService.findById(current.getTenantId());
            Assert.notNull((Object)dbTenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", current.getId()));
            User user = this.generateUser((UserInfo)current, "fii");
            if (current.getMappingInfo() != null) {
                this.importDataService.updateUserMapping(Long.valueOf(dbTenant.getSid()), Long.valueOf(user.getSid()), user.getId(), Arrays.asList(current.getMappingInfo()));
            }
            if (this.userInTenantCrudService.existsByUnionKey(dbTenant.getSid(), user.getSid())) continue;
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setUserSid(user.getSid());
            userInTenant.setTenantSid(dbTenant.getSid());
            this.userInTenantCrudService.create((BaseEntity)userInTenant);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/huawei/tenant"})
    public ResponseEntity<?> importHuaWeiTenant(@RequestBody UserWithTenantVo body) {
        User user = this.generateUserForHuaWei(body.getUserInfo(), "HuaWei");
        TenantVO tenantVO = new TenantVO();
        tenantVO.setComeFrom("HuaWei");
        BeanUtils.mergeDifferentTypeObject((Object)body.getTenantInfo(), (Object)tenantVO);
        TenantCertification tenantCertification = new TenantCertification();
        BeanUtils.mergeDifferentTypeObject((Object)body.getTenantInfo(), (Object)tenantCertification);
        if (this.tenantCrudService.existsById(tenantVO.getId())) {
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantVO.getId());
            if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), user.getSid())) {
                UserInTenant userInTenant = new UserInTenant(user.getSid(), tenant.getSid());
                this.userInTenantCrudService.create((BaseEntity)userInTenant);
                ArrayList<String> roles = new ArrayList<String>();
                roles.add("superadmin");
                this.userInRoleService.updateUserInRoleByUser(Long.valueOf(tenant.getSid()), Long.valueOf(user.getSid()), roles);
                return ResponseEntity.ok((Object)new UserInfo(user));
            }
            return ResponseEntity.ok((Object)new UserInfo(user));
        }
        this.importDataService.createTenant(tenantVO, tenantCertification, user);
        Tenant dbTenant = (Tenant)this.tenantCrudService.findById(tenantVO.getId());
        if (body.getMappingInfo() != null) {
            this.importDataService.updateUserMapping(Long.valueOf(dbTenant.getSid()), Long.valueOf(user.getSid()), user.getId(), Arrays.asList(body.getMappingInfo()));
        }
        return ResponseEntity.ok((Object)new UserInfo(user));
    }

    @PostMapping(value={"/sync/dingtalk", "/sync/thirdplatform"})
    public ResponseEntity<?> syncTenantAuthInfo(@RequestBody DingTalkImportInfo dingTalkImportInfo) {
        try {
            Long tenantSid;
            StdData tenantInfo = this.importDingTalkTenant(dingTalkImportInfo);
            Map map = (Map)tenantInfo.getData();
            if (map.containsKey("tenantSid")) {
                tenantSid = (Long)map.get("tenantSid");
            } else {
                tenantSid = 0L;
                logger.error("\u540c\u6b65\u79df\u6237\u6388\u6743\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a{}", (Object)JsonUtils.objToJson((Object)dingTalkImportInfo));
            }
            SyncTenantAuthScope syncTenantAuthScope = this.syncTenantAuthScopeRepository.findByTenantSidAndPlatformAndAuthApp(tenantSid, dingTalkImportInfo.getComeFrom(), dingTalkImportInfo.getAuth().getAppId());
            if (null == syncTenantAuthScope) {
                syncTenantAuthScope = new SyncTenantAuthScope();
                syncTenantAuthScope.setTenantSid(tenantSid);
                syncTenantAuthScope.setPlatform(dingTalkImportInfo.getComeFrom());
                syncTenantAuthScope.setAuthApp(dingTalkImportInfo.getAuth().getAppId());
                syncTenantAuthScope.setOrgs(JsonUtils.objToJson((Object)dingTalkImportInfo.getOrgs()));
                syncTenantAuthScope.setUserIds(JsonUtils.objToJson((Object)dingTalkImportInfo.getUserIds()));
                syncTenantAuthScope.setTryoutType(dingTalkImportInfo.getTryoutType());
                syncTenantAuthScope.setStrategyCode((String)Optional.ofNullable(dingTalkImportInfo.getAuth()).map(AuthDataDO::getStrategyCode).orElse(null));
            } else {
                syncTenantAuthScope.setOrgs(JsonUtils.objToJson((Object)dingTalkImportInfo.getOrgs()));
                syncTenantAuthScope.setUserIds(JsonUtils.objToJson((Object)dingTalkImportInfo.getUserIds()));
                if (StringUtils.hasText((String)dingTalkImportInfo.getTryoutType()) && !dingTalkImportInfo.getTryoutType().equalsIgnoreCase(syncTenantAuthScope.getTryoutType()) && !"enterprise_tryout".equalsIgnoreCase(syncTenantAuthScope.getTryoutType())) {
                    syncTenantAuthScope.setTryoutType(dingTalkImportInfo.getTryoutType());
                }
                if (!StringUtils.hasText((String)syncTenantAuthScope.getStrategyCode()) || Boolean.TRUE.equals(Optional.ofNullable(dingTalkImportInfo.getAuth()).map(AuthDataDO::getUpdateTenantAuth).orElse(false))) {
                    syncTenantAuthScope.setStrategyCode((String)Optional.ofNullable(dingTalkImportInfo.getAuth()).map(AuthDataDO::getStrategyCode).orElse(null));
                }
            }
            this.syncTenantAuthScopeRepository.save((Object)syncTenantAuthScope);
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @PostMapping(value={"/dingtalk", "/thirdplatform"})
    public StdData<?> importDingTalkTenant(@RequestBody DingTalkImportInfo userImportInfo) throws JsonProcessingException {
        logger.info("0.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6c47\u5165\u7528\u6237\u4fe1\u606f,\u4fe1\u606f\u4e3a\uff1a {}", (Object)userImportInfo.getComeFrom(), (Object)JsonUtils.createObjectMapper().writeValueAsString((Object)userImportInfo));
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.otherValidateService.checkOAuthImportUserInfo(userImportInfo, Boolean.valueOf(false));
        if (0 == userImportInfo.getAction()) {
            logger.info("1.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6ce8\u518c\u7528\u6237\u79df\u6237", (Object)userImportInfo.getComeFrom());
            DingTalkImportInfo registerResult = this.importDataService.importDingTalk(userImportInfo);
            logger.info("1.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5b8c\u6210\u6ce8\u518c\u7528\u6237\u79df\u6237", (Object)userImportInfo.getComeFrom());
            Tenant tenant = registerResult.getTenant();
            String appId = userImportInfo.getAuth().getAppId();
            List<Object> userIds = new ArrayList();
            if (userImportInfo.getAuthUser().booleanValue()) {
                userIds = userImportInfo.getUsers().stream().map(UserInfo::getId).collect(Collectors.toList());
            }
            logger.info("2.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6ce8\u518c\u79df\u6237\u4e0b{}\u5e94\u7528{}\u7684\u6388\u6743\uff0c\u6388\u6743\u4fe1\u606f\uff1a{},\u6388\u6743\u7528\u6237:{}", new Object[]{userImportInfo.getComeFrom(), tenant.getId(), appId, JsonUtils.writeValue((Object)userImportInfo.getAuth()), JsonUtils.writeValue(userIds)});
            if (userImportInfo.getAuthTenant().booleanValue() || userImportInfo.getAuthUser().booleanValue()) {
                userImportInfo.getAuth().setMemo(userImportInfo.getComeFrom());
                try {
                    this.purchaseService.purchaseAuth(tenant, userImportInfo.getAuth(), userIds);
                }
                catch (Exception ex) {
                    logger.error("2.\u5f00\u901a\u5e94\u7528\u6388\u6743\u5931\u8d25", (Throwable)ex);
                }
            }
            logger.info("2.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u6388\u6743\u6210\u529f", (Object)userImportInfo.getComeFrom());
            this.importDataService.bindEmps(userImportInfo, tenant, registerResult.getEoc());
            result.put("tenantSid", tenant.getSid());
            result.put("tenantId", tenant.getId());
        } else {
            Long tenantSid;
            if (StringUtils.hasLength((String)userImportInfo.getTenantId())) {
                Tenant tenant = (Tenant)this.tenantCrudService.findById(userImportInfo.getTenantId());
                if (tenant == null) {
                    throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{userImportInfo.getTenantId()});
                }
                tenantSid = tenant.getSid();
            } else {
                tenantSid = 0L;
            }
            logger.info("1.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u7ed1\u5b9a\u5f52\u6237\u4fe1\u606f", (Object)userImportInfo.getComeFrom());
            String mapResult = this.map(userImportInfo, tenantSid, userImportInfo.getAuth().getAppId());
            logger.info("1.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5b8c\u6210\u7ed1\u5b9a\u5f52\u6237\u4fe1\u606f", (Object)userImportInfo.getComeFrom());
            if (StringUtils.hasText((String)mapResult)) {
                return StdData.of((int)2000, (String)mapResult);
            }
        }
        return StdData.ok(result);
    }

    @PostMapping(value={"/dingtalk/with/apps"})
    public StdData<?> importDingTalkTenantWithApps(@RequestBody DingTalkImportInfo userImportInfo) throws JsonProcessingException {
        logger.info("0.\u5f00\u59cb\u6279\u91cf\u6c47\u5165\u9489\u9489\u7528\u6237\u4fe1\u606f,\u4fe1\u606f\u4e3a\uff1a {}", (Object)JsonUtils.createObjectMapper().writeValueAsString((Object)userImportInfo));
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.otherValidateService.checkOAuthImportUserInfo(userImportInfo, Boolean.valueOf(true));
        if (0 == userImportInfo.getAction()) {
            logger.info("1.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6279\u91cf\u6ce8\u518c\u7528\u6237\u79df\u6237", (Object)userImportInfo.getComeFrom());
            DingTalkImportInfo registerResult = this.importDataService.importDingTalk(userImportInfo);
            logger.info("1.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6279\u91cf\u6ce8\u518c\u7528\u6237\u79df\u6237", (Object)userImportInfo.getComeFrom());
            List<Object> userIds = new ArrayList();
            if (userImportInfo.getAuthUser().booleanValue()) {
                userIds = userImportInfo.getUsers().stream().map(UserInfo::getId).collect(Collectors.toList());
            }
            logger.info("2.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6279\u91cf\u6ce8\u518c\u79df\u6237\u4e0b{}\u5e94\u7528\u7684\u6388\u6743\uff0c\u6388\u6743\u4fe1\u606f\uff1a{},\u6388\u6743\u7528\u6237:{}", new Object[]{userImportInfo.getComeFrom(), registerResult.getTenant().getId(), JsonUtils.writeValue((Object)userImportInfo.getAuths()), JsonUtils.writeValue(userIds)});
            if (userImportInfo.getAuthTenant().booleanValue() || userImportInfo.getAuthUser().booleanValue()) {
                userImportInfo.getAuths().forEach(a -> a.setMemo(userImportInfo.getComeFrom()));
                this.purchaseService.batchPurchaseAuth(registerResult.getTenant(), userImportInfo.getAuths(), userIds);
            }
            logger.info("2.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u6279\u91cf\u6388\u6743\u6210\u529f", (Object)userImportInfo.getComeFrom());
            this.importDataService.bindEmps(userImportInfo, registerResult.getTenant(), registerResult.getEoc());
            result.put("tenantSid", registerResult.getTenant().getSid());
            result.put("tenantId", registerResult.getTenant().getId());
        } else {
            Long tenantSid;
            if (StringUtils.hasLength((String)userImportInfo.getTenantId())) {
                Tenant tenant = (Tenant)this.tenantCrudService.findById(userImportInfo.getTenantId());
                if (tenant == null) {
                    throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{userImportInfo.getTenantId()});
                }
                tenantSid = tenant.getSid();
            } else {
                tenantSid = 0L;
            }
            ArrayList errorResult = new ArrayList();
            userImportInfo.getAuths().forEach(a -> {
                String mapResult = this.map(userImportInfo, tenantSid, a.getAppId());
                if (StringUtils.hasText((String)mapResult)) {
                    errorResult.add(mapResult);
                }
            });
            if (!errorResult.isEmpty()) {
                return StdData.of((int)20000, (String)String.join((CharSequence)",", errorResult));
            }
        }
        return StdData.ok(result);
    }

    @PostMapping(value={"metadata/sync"})
    public StdData<?> syncUserMetadata(@RequestBody MetadataSyncVO vo) {
        if (!"line".equals(vo.getSyncType())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        List mappingList = this.userMappingService.getMappedByAppAndAccount(vo.getSyncTenantSid(), vo.getSyncAppId(), "line");
        this.importDataService.syncUserMetadataForLine(vo.getSyncAppId(), mappingList);
        return StdData.ok().build();
    }

    private String map(DingTalkImportInfo userImportInfo, Long tenantSid, String appId) {
        ArrayList errorUsers = new ArrayList();
        userImportInfo.getUsers().forEach(u -> {
            String userId;
            User user;
            if (StringUtils.hasLength((String)u.getTelephone())) {
                user = this.userRepository.findFirstByTelephoneAndType(u.getTelephone(), Integer.valueOf(0));
                userId = u.getTelephone();
            } else if (StringUtils.hasLength((String)u.getId())) {
                user = (User)this.userRepository.findById(u.getId());
                userId = u.getId();
            } else {
                user = this.userRepository.findFirstByEmailAndType(u.getEmail(), Integer.valueOf(0));
                userId = u.getEmail();
            }
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
            }
            UserMappingVO userMappingVO = new UserMappingVO();
            userMappingVO.setUserId(user.getId());
            userMappingVO.setIdentityId(appId);
            userMappingVO.setVerifyUserId(u.getUnionId());
            userMappingVO.setAccount(userImportInfo.getComeFrom());
            try {
                this.userMappingService.map(tenantSid.longValue(), userMappingVO, true);
            }
            catch (Exception ex) {
                logger.error(String.format("\u6620\u5c04\u7528\u6237%s\u5173\u7cfb\u5931\u8d25", u.getId()), (Throwable)ex);
                errorUsers.add(user.getId());
            }
        });
        if (errorUsers.isEmpty()) {
            return "";
        }
        return String.format("\u79df\u6237\u4e0b%s\u7684\u7528\u6237[%s]\u5f52\u6237\u5931\u8d25", tenantSid, String.join((CharSequence)"", errorUsers));
    }

    private User generateServiceCloudUser(UserImportInfo userInfo) {
        User user;
        Assert.notNull((Object)userInfo.getId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        boolean enterprise = UserTypeEnum.INTERNAL.getCode().equals(userInfo.getType());
        String telephone = userInfo.getTelephone();
        List<Object> users = new ArrayList();
        if (enterprise) {
            String[] idArr = userInfo.getId().split("\\$");
            boolean matchRule = idArr.length > 1 && Objects.equals(idArr[0], userInfo.getTenantId());
            Assert.isTrue((boolean)matchRule, (String)"\u4f01\u4e1a\u7528\u6237id\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u683c\u5f0f\u4e3a\uff1a\u79df\u6237id + $ + \u7528\u6237id\uff0c\u5982\uff1atenant001$user001");
            User user2 = (User)this.userRepository.findById(userInfo.getId());
            if (null != user2) {
                users = Collections.singletonList(user2);
            } else if (!this.tenantCrudService.existsById(userInfo.getTenantId())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{userInfo.getTenantId()});
            }
        } else {
            users = this.userCrudService.queryUserListByIdOrEmailOrTelephoneOrWechatAndType(userInfo.getId(), userInfo.getEmail(), telephone, userInfo.getWechat(), Integer.valueOf(0));
        }
        if (users.isEmpty()) {
            logger.info("1.\u670d\u52a1\u4e91\u540c\u6b65\u79df\u6237\u7528\u6237\u63a5\u53e3,\u521b\u5efa\u7528\u6237\u4fe1\u606f\uff0c{}", (Object)JsonUtils.objToJson((Object)userInfo));
            userInfo.setComeFrom("ServiceCloud");
            user = this.userBasicInfoUpdateService.create((UserInfo)userInfo, Boolean.valueOf(enterprise));
        } else {
            user = users.stream().filter(u -> u.getId().equalsIgnoreCase(userInfo.getId())).findFirst().orElse(null);
            if (!enterprise) {
                if (user == null && StringUtils.hasLength((String)userInfo.getEmail())) {
                    user = users.stream().filter(u -> userInfo.getEmail().equalsIgnoreCase(u.getEmail())).findFirst().orElse(null);
                }
                if (user == null && StringUtils.hasLength((String)telephone)) {
                    user = users.stream().filter(u -> telephone.equals(u.getTelephone())).findFirst().orElse(null);
                }
                if (user == null && StringUtils.hasLength((String)userInfo.getWechat())) {
                    user = users.stream().filter(u -> userInfo.getWechat().equalsIgnoreCase(u.getWechat())).findFirst().orElse(null);
                }
            }
            if (user == null) {
                String userTypeName = UserTypeEnum.getName((Integer)userInfo.getType());
                if (enterprise) {
                    logger.error("\u7528\u6237{}\u4e0d\u5b58\u5728,\u7c7b\u578b:{},\u624b\u673a{},\u90ae\u7bb1{},\u5fae\u4fe1{}", new Object[]{userInfo.getId(), userTypeName, userInfo.getTelephone(), userInfo.getEmail(), userInfo.getWechat()});
                } else {
                    logger.error("\u7528\u6237{},\u7c7b\u578b:{},\u624b\u673a{},\u90ae\u7bb1{},\u5fae\u4fe1{}\u4e0d\u5b58\u5728", new Object[]{userInfo.getId(), userTypeName, userInfo.getTelephone(), userInfo.getEmail(), userInfo.getWechat()});
                }
                logger.info(String.format("1.\u540c\u6b65\u79df\u6237\u4fe1\u606f\uff0c\u521b\u5efa\u7ba1\u7406\u5458\u7528\u6237\uff0c%s\uff01", JsonUtils.objToJson((Object)userInfo)));
                userInfo.setComeFrom("ServiceCloud");
                user = this.userBasicInfoUpdateService.create((UserInfo)userInfo, Boolean.valueOf(enterprise));
            } else {
                logger.info(String.format("1.\u540c\u6b65\u79df\u6237\u4fe1\u606f\uff0c\u66f4\u65b0\u7ba1\u7406\u5458\u7528\u6237\uff0c%s\uff01", JsonUtils.objToJson((Object)userInfo)));
                user = this.userBasicInfoUpdateService.updateServiceCloudUser((UserInfo)userInfo, user);
            }
        }
        return user;
    }

    private User generateUser(UserInfo userInfo, String comeFrom) {
        Assert.notNull((Object)userInfo.getId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(userInfo.getId(), userInfo.getId(), userInfo.getId(), null);
        if (user == null) {
            userInfo.setComeFrom(comeFrom);
            user = this.userBasicInfoUpdateService.create(userInfo, Boolean.valueOf(false));
        } else if (!user.getId().equals(userInfo.getId())) {
            String telephone;
            String email = StringUtils.isEmpty((Object)user.getEmail()) ? "" : user.getEmail();
            String string = telephone = StringUtils.isEmpty((Object)user.getTelephone()) ? "" : user.getTelephone();
            if (email.equals(userInfo.getEmail())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10, new Object[]{user.getEmail(), user.getId(), userInfo.getId()});
            }
            if (telephone.equals(userInfo.getTelephone())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_11, new Object[]{user.getTelephone(), user.getId(), userInfo.getId()});
            }
            userInfo.setComeFrom(comeFrom);
            user = this.userBasicInfoUpdateService.create(userInfo, Boolean.valueOf(false));
        } else {
            this.userBasicInfoUpdateService.updateUser(userInfo);
        }
        return user;
    }

    private User generateUserForHuaWei(UserInfo userInfo, String comeFrom) {
        User user;
        Assert.notNull((Object)userInfo.getId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (StringUtils.hasLength((String)userInfo.getEmail())) {
            userInfo.setAddress(userInfo.getEmail());
            userInfo.setEmail("");
        }
        if (StringUtils.hasLength((String)userInfo.getTelephone())) {
            userInfo.setAddress(userInfo.getAddress() + "/" + userInfo.getTelephone());
            userInfo.setTelephone("");
        }
        if ((user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(userInfo.getId(), userInfo.getId(), userInfo.getId(), null)) == null) {
            userInfo.setComeFrom(comeFrom);
            user = this.userBasicInfoUpdateService.create(userInfo, Boolean.valueOf(false));
        } else {
            this.userBasicInfoUpdateService.updateUser(userInfo);
        }
        return user;
    }
}

