/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.upgrade;

import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.CloudTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.migration.TenantAppUpgradeRequest;
import com.digiwin.dap.middleware.iam.domain.migration.TenantSyncRequest;
import com.digiwin.dap.middleware.iam.service.migration.MigrationService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/migration"})
public class MigrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationController.class);
    @Resource
    private MigrationService migrationService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserInRoleService userInRoleService;

    @PostMapping(value={"/ground/tenant/sync"})
    public StdData<?> syneTenantAllInfo(@RequestBody TenantSyncRequest req, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u5f00\u59cb \u540c\u6b65\u4e91\u4e0a\u79df\u6237\u8d44\u6599\u4e0b\u5730\uff0c\u6267\u884c\u4eba = {}\uff0c\u5165\u53c2\n {}", (Object)authoredUser.getUserId(), (Object)req);
        if (CloudTypeEnum.CLOUD.getCode().equals(this.envProperties.getCloud())) {
            throw new BusinessException(String.format("\u5f53\u524d\u90e8\u7f72\u73af\u5883\u4e0d\u5141\u8bb8\u884c\u8fdb\u884c\u79df\u6237\u8d44\u6599\u540c\u6b65\u5230\u4e0b\u5730\u73af\u5883, cloud=%s, deployArea=%s, iamUri=%s", this.envProperties.getCloud(), this.envProperties.getDeployArea(), this.envProperties.getIamUri()));
        }
        Assert.hasLength((String)req.getSourceCloudArea(), (String)"\u6765\u6e90\u4e91\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)req.getUserToken(), (String)"\u6765\u6e90\u4e91\u533auserToken\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)req.getTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        String msg = this.migrationService.syncTenantAllInfo(req.toDTO(), authoredUser);
        String str = "\u5b8c\u6210 \u540c\u6b65\u4e91\u4e0a\u79df\u6237\u8d44\u6599\u4e0b\u5730\uff1b";
        LOGGER.info(str);
        return StdData.ok((Object)(msg + str));
    }

    @Deprecated
    @PostMapping(value={"/tenant/app/info/upgrade"})
    public StdData<?> upgradeTenantsApps(@RequestBody TenantAppUpgradeRequest req, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u5f00\u59cb \u8fc1\u79fb\u591a\u4e2a\u79df\u6237\u4e0b\u7684\u591a\u4e2a\u5e94\u7528\u7684\u6388\u6743\u8d44\u6599\u53ca\u4f5c\u4e1a\u6743\u9650\uff0c\u6267\u884c\u4eba = {}\uff0c\u5165\u53c2\n {}", (Object)authoredUser.getUserId(), (Object)req);
        if (!Objects.equals(authoredUser.getTenantId(), "99990000")) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u8c03\u7528\u8005{}\u975e\u9f0e\u6377\u5458\u5de5\uff0c\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3", (Object[])new Object[]{authoredUser.getUserId()}));
        }
        req.checkParams();
        String msg = this.migrationService.upgradeTenantsApps(req.toDTO(), authoredUser);
        String str = "\u5b8c\u6210 \u8fc1\u79fb\u591a\u4e2a\u79df\u6237\u4e0b\u7684\u591a\u4e2a\u5e94\u7528\u7684\u6388\u6743\u8d44\u6599\u53ca\u4f5c\u4e1a\u6743\u9650\uff1b";
        LOGGER.info(str);
        return StdData.ok((Object)(msg + str));
    }
}

