/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api.upgrade;

import cn.hutool.json.JSONUtil;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.support.remote.MiswsService;
import com.digiwin.dap.middleware.iam.support.remote.domain.ResignedEmployeeDataVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ResignedEmployeeVO;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/resigned"})
public class ResignedEmployeeSyncController {
    private static final Logger logger = LoggerFactory.getLogger(ResignedEmployeeSyncController.class);
    @Autowired
    private MiswsService miswsService;
    @Autowired
    private UserMapper userMapper;

    @PostMapping(value={"/sync/{startDate}/{endDate}"})
    public ResponseEntity<?> syncResignedEmployee(@PathVariable(value="startDate") String startDate, @PathVariable(value="endDate") String endDate) {
        try {
            logger.info("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1,\u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now());
            ResignedEmployeeVO resp = this.miswsService.getResignedEmployee(startDate, endDate);
            logger.info("\u4eba\u8d44\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)JSONUtil.toJsonStr((Object)resp));
            if (!"0".equals(resp.getStatus())) {
                logger.error("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25,\u8c03\u7528\u4eba\u4e8b\u8d44\u6599\u63a5\u53e3\u5f02\u5e38");
                return ResponseEntity.ok((Object)"\u6267\u884c\u5931\u8d25");
            }
            List resignedEmployeeList = resp.getData();
            if (!CollectionUtils.isEmpty((Collection)resignedEmployeeList)) {
                List resignedEmployeeIds = resignedEmployeeList.stream().map(ResignedEmployeeDataVO::getMV020).collect(Collectors.toList());
                List partition = Lists.partition(resignedEmployeeIds, (int)100);
                partition.forEach(list -> this.userMapper.disableUserAndClearTelephoneByIds(list));
            }
            logger.info("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1\u5b8c\u6210,\u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        return ResponseEntity.ok((Object)"\u6267\u884c\u6210\u529f");
    }
}

