/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support;

import com.digiwin.dap.middle.stream.consumer.ConsumerService;
import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Service;

@Service
public class ConsumerServiceImpl
implements ConsumerService {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerServiceImpl.class);
    @Autowired
    private SysNoticeService sysNoticeService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private AuthoredUserService authoredUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(value="sysInput")
    public void receive(Message<String> message) {
        MessageHeaders headers = message.getHeaders();
        try {
            MessageBody messageBody = (MessageBody)JsonUtils.jsonToObj((String)((String)message.getPayload()), MessageBody.class);
            if (messageBody.getMsgType() != MessageType.SYS) {
                logger.error("\u6765\u81ea{}\u7684\u975e\u6cd5\u6d88\u606f{}", (Object)messageBody.getSourceId(), (Object)messageBody.getMsgType());
                return;
            }
            this.beforeSend(headers, messageBody);
            this.sysNoticeService.noticeSys(messageBody);
        }
        catch (Exception e) {
            logger.error("Consume finished with exception", (Throwable)e);
        }
        finally {
            this.afterSend(headers);
        }
    }

    private void beforeSend(MessageHeaders headers, MessageBody messageBody) {
        String userToken = (String)headers.get((Object)DapHttpHeaders.USER_TOKEN.getHeader(), String.class);
        String appToken = (String)headers.get((Object)DapHttpHeaders.APP_TOKEN.getHeader(), String.class);
        String languageTag = (String)headers.get((Object)DapHttpHeaders.ACCEPT_LANGUAGE.getHeader(), String.class);
        try {
            if (StrUtils.isNotEmpty((String)userToken)) {
                messageBody.setUserToken(userToken);
                IamAuthoredUser authoredUser = this.authoredUserService.getByUserToken(userToken);
                AppAuthContextHolder.getContext().setAuthoredUser((AuthoredUser)authoredUser);
            }
            if (StrUtils.isNotEmpty((String)appToken)) {
                AuthoredSys app = AuthoredSys.obtainApp((String)appToken);
                Sys sys = this.commonCacheService.getSysById(app.getId());
                AuthoredSys authoredSys = Sys.loginSys((Sys)sys);
                AppAuthContextHolder.getContext().setAuthoredSys(authoredSys == null ? app : authoredSys);
            }
            if (StrUtils.isNotEmpty((String)languageTag)) {
                LocaleContextHolder.setLocale((Locale)Locale.forLanguageTag(languageTag));
            }
        }
        catch (Exception e) {
            logger.error("token\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
    }

    private void afterSend(MessageHeaders headers) {
        AppAuthContextHolder.clearContext();
        LocaleContextHolder.resetLocaleContext();
    }
}

