/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.role.RoleVO;
import com.digiwin.dap.middleware.iam.domain.tenant.RegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdateUserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserInfoForKanBanVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.InvitedUserHistoryRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.stream.producer.KanBanProducerService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class KanBanAspect {
    @Autowired
    UserBasicInfoQueryService userBasicInfoQueryService;
    @Autowired
    TenantRepository tenantRepository;
    @Autowired
    InvitedUserHistoryRepository invitedUserHistoryRepository;
    @Autowired
    KanBanProducerService kanBanProducerService;
    @Autowired
    TenantQueryService tenantQueryService;
    @Autowired
    UserCrudService userCrudService;
    @Autowired
    TenantMapper tenantMapper;

    public void registerIndividualTenant() {
    }

    public void afterRegisterIndividualTenant(JoinPoint pjp) throws Throwable {
        long tenantSid = (Long)((MethodInvocationProceedingJoinPoint)pjp).proceed();
        long userSid = (Long)pjp.getArgs()[0];
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfo(tenantSid, userSid);
        this.sendKanBanMessage("insert", this.tenantRepository.findIdBySid(tenantSid), userInfoForKanBanVOS);
    }

    public void registerTenant() {
    }

    public void afterRegisterTenant(JoinPoint pjp) {
        String tenantId = ((RegisterTenantVO)pjp.getArgs()[0]).getTenant().getId();
        long tenantSid = this.tenantRepository.findSidById(tenantId);
        long userSid = ((AuthoredUser)pjp.getArgs()[1]).getSid();
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfo(tenantSid, userSid);
        this.sendKanBanMessage("insert", tenantId, userInfoForKanBanVOS);
    }

    public void confirmTenant() {
    }

    public void afterConfirmTenant(JoinPoint pjp) {
        long tenantSid = ((TenantAuditVO)pjp.getArgs()[0]).getSid();
        long userSid = this.tenantRepository.findOwnerUserSidBySid(tenantSid);
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfo(tenantSid, userSid);
        this.sendKanBanMessage("update", this.tenantRepository.findIdBySid(tenantSid), userInfoForKanBanVOS);
    }

    public void tenantAgreeApply() {
    }

    public void afterTenantAgreeApply(JoinPoint pjp) {
        long tenantSid = ((Tenant)pjp.getArgs()[0]).getSid();
        long invitedSid = (Long)pjp.getArgs()[1];
        long userSid = this.invitedUserHistoryRepository.findUserSidBySid(Long.valueOf(invitedSid));
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfo(tenantSid, userSid);
        this.sendKanBanMessage("insert", this.tenantRepository.findIdBySid(tenantSid), userInfoForKanBanVOS);
    }

    public void exitTenant() {
    }

    public void afterExitTenant(JoinPoint pjp) {
    }

    public void agreeTenantInvited() {
    }

    public void afterAgreeTenantInvited(JoinPoint pjp) {
        long userSid = (Long)pjp.getArgs()[0];
        long invitedSid = (Long)pjp.getArgs()[1];
        long tenantSid = this.invitedUserHistoryRepository.findTenantSidBySid(Long.valueOf(invitedSid));
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfo(tenantSid, userSid);
        this.sendKanBanMessage("insert", this.tenantRepository.findIdBySid(tenantSid), userInfoForKanBanVOS);
    }

    public void updateUserAllInfo() {
    }

    public void afterUpdateUserAllInfo(JoinPoint pjp) {
        long tenantSid = (Long)pjp.getArgs()[0];
        long userSid = ((UpdateUserBasicInfoVO)pjp.getArgs()[1]).getUser().getSid();
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfo(tenantSid, userSid);
        this.sendKanBanMessage("update", this.tenantRepository.findIdBySid(tenantSid), userInfoForKanBanVOS);
    }

    public void updateUser() {
    }

    public void afterUpdateUser(JoinPoint pjp) {
        String userId = ((UserInfo)pjp.getArgs()[0]).getId();
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            return;
        }
        long userSid = user.getSid();
        List tenants = this.tenantMapper.getTenantBasicInfoWithUserByJoinedUserSid(userSid);
        tenants.forEach(tenantRelationWithUserWithStatusVO -> {
            List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfo(tenantRelationWithUserWithStatusVO.getSid().longValue(), userSid);
            this.sendKanBanMessage("update", tenantRelationWithUserWithStatusVO.getId(), userInfoForKanBanVOS);
        });
    }

    public void tenantDeleteUser() {
    }

    public void afterTenantDeleteUser(JoinPoint pjp) {
    }

    public void modifyRole() {
    }

    public void afterModifyRole(JoinPoint pjp) {
        String roleId;
        long tenantSid = (Long)pjp.getArgs()[1];
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfoByRoleSid(tenantSid, roleId = ((RoleVO)pjp.getArgs()[0]).getId());
        if (userInfoForKanBanVOS.size() == 0) {
            return;
        }
        this.sendKanBanMessage("update", this.tenantRepository.findIdBySid(tenantSid), userInfoForKanBanVOS);
    }

    public void updateOrg() {
    }

    public void afterUpdateOrg(JoinPoint pjp) {
        long orgSid;
        long tenantSid = ((Org)pjp.getArgs()[0]).getTenantSid();
        List userInfoForKanBanVOS = this.userBasicInfoQueryService.getUserInfoByOrgSid(tenantSid, orgSid = ((Org)pjp.getArgs()[0]).getSid());
        if (userInfoForKanBanVOS.size() == 0) {
            return;
        }
        String tenantId = this.tenantRepository.findIdBySid(tenantSid);
        this.sendKanBanMessage("update", tenantId, userInfoForKanBanVOS);
    }

    private void sendKanBanMessage(String type, String tenantId, List<UserInfoForKanBanVO> userInfoForKanBanVOS) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("type", type);
        messageMap.put("tenantId", tenantId);
        messageMap.put("data", userInfoForKanBanVOS);
        messageMap.put("appId", this.tenantQueryService.getTenantApplication(tenantId, Collections.singletonList(GoodsCategoryEnum.APP.id())));
        this.kanBanProducerService.sendUserInfoToKanBan(messageMap);
    }
}

