/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect;

import cn.hutool.extra.servlet.ServletUtil;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.LoginHistory;
import com.digiwin.dap.middleware.iam.service.loginhistory.LoginHistoryCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.util.NetUtils;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LoginHistoryAspect {
    private static final Logger logger = LoggerFactory.getLogger(LoginHistoryAspect.class);
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private LoginHistoryCrudService loginHistoryCrudService;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.login.impl.AuthoredLoginUserServiceImpl.generate(..))", returning="obj")
    public void loginHistory2(JoinPoint joinPoint, Object obj) {
        if (!Boolean.TRUE.equals(this.envProperties.getLmcLogEnabled())) {
            return;
        }
        try {
            Object[] args = joinPoint.getArgs();
            if (args.length < 1 || !(args[0] instanceof LoginUser)) {
                return;
            }
            LoginUser loginUser = (LoginUser)args[0];
            HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            String ip = ServletUtil.getClientIPByHeader((HttpServletRequest)request, (String[])NetUtils.HEADERS);
            IamAuthoredUser authoredUser = (IamAuthoredUser)obj;
            this.remoteLMCService.addLoginLog(loginUser, ip, authoredUser.getToken(), authoredUser.getAgentUserId());
            if (StringUtils.hasText((String)loginUser.getGclid())) {
                this.dapTaskExecutor.execute(() -> this.recordLoginExpandInfo(loginUser));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void recordLoginExpandInfo(LoginUser loginUser) {
        List loginHistories = this.loginHistoryCrudService.getLoginHistoryInfos(loginUser.getUserId(), Boolean.valueOf(false));
        if (!CollectionUtils.isEmpty((Collection)loginHistories)) {
            loginHistories.forEach(h -> h.setDisabled(true));
        }
        LoginHistory loginHistory = new LoginHistory();
        loginHistory.setGclid(loginUser.getGclid());
        loginHistory.setUserId(loginUser.getUserId());
        loginHistory.setHistoryTime(LocalDateTime.now());
        loginHistory.setAppId(loginUser.getSysId());
        loginHistory.setTenantId(loginUser.getTenantId());
        loginHistories.add(loginHistory);
        this.loginHistoryCrudService.saveAll((Iterable)loginHistories);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.login.AuthoredUserService.logout(com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser,String,boolean)) && args(authoredUser,appId,clearAll)")
    public void logoutHistory(IamAuthoredUser authoredUser, String appId, boolean clearAll) {
        if (!Boolean.TRUE.equals(this.envProperties.getLmcLogEnabled())) {
            return;
        }
        try {
            if (authoredUser != null) {
                HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
                String ip = ServletUtil.getClientIPByHeader((HttpServletRequest)request, (String[])NetUtils.HEADERS);
                this.remoteLMCService.addLogoutLog((AuthoredUser)authoredUser, appId, ip, clearAll);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

