/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.entity.TenantHistory;
import com.digiwin.dap.middleware.iam.service.tenanthistory.TenantHistoryCrudService;
import java.time.LocalDateTime;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Aspect
@Component
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class TenantHistoryAspect {
    @Autowired
    private TenantHistoryCrudService tenantHistoryCrudService;
    private Logger logger = LoggerFactory.getLogger(TenantHistoryAspect.class);

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.tenant.TenantAuditService.confirm(..))")
    public void confirm(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        if (args.length > 0) {
            try {
                AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
                if (user != null) {
                    TenantAuditVO tenantAuditVO = (TenantAuditVO)args[0];
                    TenantHistory tenantHistory = new TenantHistory();
                    if (tenantAuditVO != null) {
                        tenantHistory.setAuditor(user.getSid());
                        tenantHistory.setConfirm(1);
                        tenantHistory.setTenantSid(tenantAuditVO.getSid());
                        tenantHistory.setAuditDate(LocalDateTime.now());
                        this.tenantHistoryCrudService.create((BaseEntity)tenantHistory);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u5ba1\u6838\u79df\u6237\u8bb0\u5f55\u672a\u6210\u529f\u4fdd\u5b58:" + e);
            }
        }
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.tenant.TenantAuditService.disConfirm(..))")
    public void disConfirm(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        if (args.length > 0) {
            try {
                AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
                if (user != null) {
                    TenantAuditVO tenantAuditVO = (TenantAuditVO)args[0];
                    TenantHistory tenantHistory = new TenantHistory();
                    if (tenantAuditVO != null) {
                        tenantHistory.setAuditor(user.getSid());
                        tenantHistory.setConfirm(-1);
                        tenantHistory.setTenantSid(tenantAuditVO.getSid());
                        tenantHistory.setDescription(tenantAuditVO.getExplain());
                        tenantHistory.setAuditDate(LocalDateTime.now());
                        this.tenantHistoryCrudService.create((BaseEntity)tenantHistory);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u5ba1\u6838\u79df\u6237\u8bb0\u5f55\u672a\u6210\u529f\u4fdd\u5b58:" + e);
            }
        }
    }
}

