/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.auth;

import com.digiwin.dap.middle.support.DefaultDapSecuritySupport;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.InternalInfo;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.support.auth.NoTokenLogAuthenticationFilter;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.auth.filter.OauthAccessTokenAuthenticationFilter;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.stereotype.Service;

@Service
public class IamSecuritySupport
extends DefaultDapSecuritySupport {
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private AuthoredUserService authoredUserService;

    public String[] getWhiteList() {
        return new String[]{"/api/console/v2/**", "/webjars/**", "/swagger-resources/**", "/api/iam/v2/api-docs/**", "/api/iam/v2/identity/login", "/api/iam/v2/identity/login/**", "/api/iam/v2/identity/token/refresh/app", "/api/iam/v2/identity/token/refresh/tenant", "/api/iam/v2/identity/token/refresh/user", "/api/iam/v2/identity/token/expired/user", "/api/iam/v2/identity/token/grant/ota", "/api/iam/v2/identity/token/grant/access", "/api/iam/v2/oauth/fii/**", "/api/iam/v2/user/register", "/api/iam/v2/user/register/without/captcha", "/api/iam/v2/user/register/email", "/api/iam/v2/user/register/mobilephone", "/api/iam/v2/user/exists", "/api/iam/v2/user/email/exist", "/api/iam/v2/user/mobilephone/exist", "/api/iam/v2/user/password/update", "/api/iam/v2/user/activate", "/api/iam/v2/user/apply/activate", "/api/iam/v2/authentication/user/callback", "/api/iam/v2/authentication/tenant/callback", "/api/iam/v2/tenant/exists", "/api/iam/v2/fii/**", "/api/middleware/v1/upgrade", "/api/v1/iam/identity/token/grant/access", "/api/v1/iam/env/health", "/v2/api-docs", "/swagger-resources", "/swagger-resources/**", "/configuration/ui", "/configuration/security", "/swagger-ui.html", "/webjars/**", "/api/iam/v2/upgrade/**", "/api/iam/v2/tenant/application/purchase/list/*/*", "/api/iam/v2/user/salt", "/api/iam/v2/user/isfii", "/api/iam/v2/identity/secretkey", "/api/iam/v2/email/test/**", "/checkcenter/**", "/websocket/**", "/api/iam/v2/identity/publickey", "/api/iam/v2/identity/aeskey", "/api/iam/v2/update", "/api/iam/v2/config/ad/check", "/api/iam/v2/user/openid/**", "/api/iam/v2/user/register/wechat", "/api/iam/v2/user/binding/openid", "/api/iam/v2/usermetadata/updateMedataInfo", "/api/iam/v2/permission", "/api/iam/v2/tenant/sid", "/api/iam/v2/action/copy/tosys", "/api/iam/v2/excel/export/org/**", "/api/iam/v2/excel/export/role/**", "/api/iam/v2/user/userid/**", "/api/iam/v2/user/unfreeze", "/api/iam/v3/invoice/taxno/**", "/api/iam/v2/tenant/user/ids/disable", "/api/iam/v2/user/dev/tenant", "/api/iam/v2/user/mobilephone/without/inner/exist", "/api/iam/v2/user/email/without/inner/exist", "/api/iam/v2/user/contacts", "/api/iam/v2/identity/internal/login", "/api/iam/v2/oauth2/accesstoken", "/api/iam/v2/oauth2/scope", "/api/iam/v2/oauth2/get/name", "/api/iam/v2/oauth2/refreshtoken", "/api/iam/v2/oauth/accesstoken", "/api/iam/v2/oauth/refreshtoken", "/api/iam/v2/dev/test/env/register/tenant", "/api/iam/v2/dev/test/env/exists/tenant/apps/test", "/api/iam/v2/servicer/id", "/api/iam/v2/identity/oauth/token/grant/access", "/api/iam/v2/eai", "/api/iam/v2/identity/oauth/token/access/app", "/api/iam/v2/identity/oauth/token/access", "/api/iam/v2/tenant/auth/app", "/api/iam/v2/user/add/join/tenant/custom", "/api/iam/v2/identity/oauth/token/grant/access/internal", "/api/iam/v2/user/check/user/tenant/auth", "/api/iam/v2/dev/app/synconce", "/api/iam/v2/dev/app/sync", "/api/iam/v2/tenant/intelly/sync", "/api/iam/v2/mapping/find", "/api/iam/v2/user/find", "/api/iam/v1/invite/link/search", "/api/iam/v2/user/login/failure", "/api/iam/v2/captcha/image", "/api/iam/v2/identity/token/temp/access", "/api/iam/v2/identity/oauth/token/access/token", "/api/iam/v2/tenant/info/simple", "/api/iam/v2/dev/app/secret/current", "/api/iam/v2/identity/sso/accesstoken", "/api/iam/v2/tenant/saml/exist", "/api/iam/v2/saml/sys/exist", "/api/iam/v2/saml/sys/find", "/api/iam/v2/saml/sys/add", "/api/iam/v2/saml/acs/**", "/api/iam/v2/saml/login", "/api/iam/v2/identity/token/saml/access", "/api/iam/v2/saml/sp/metadata", "/api/iam/v2/tenant/dict/data/search", "/api/iam/v2/tenant/dict/data/search/restricted", "/api/iam/v2/cas/**", "/api/iam/v2/identity/token/sso/access", "/api/iam/v2/tenant/auth", "/api/iam/v2/dev/app/id/**/prod/existed", "/api/iam/v2/sys/sso/url/cfg/add", "/api/iam/v2/tenant/cas/exist", "/api/iam/integrate/import/escloud", "/api/iam/integrate/import/escloud/tenant", "/api/iam/integrate/import/fii/tenant", "/api/iam/integrate/import/fii/user", "/api/iam/integrate/import/dingtalk", "/api/iam/integrate/import/thirdplatform", "/api/iam/integrate/import/dingtalk/with/apps", "/api/iam/integrate/import/metadata/sync", "/api/iam/v2/saml/logout/**", "/api/iam/v2/identity/cross/region/login/inner", "/api/iam/v2/authapp/oidc/tenant/sys/exist", "/api/iam/v2/oidc/login", "/api/iam/v2/oidc/*/*", "/api/iam/v2/device/id", "/api/iam/v2/app/**/tenants", "/api/iam/integrate/import/escloud/user/sync", "/api/iam/v2/tenant/simple/app/**", "/api/iam/v3/invoice/datasync/from/intracompany", "/api/app/initialize/role/permission", "/api/iam/integrate/import/escloud/update", "/api/iam/integrate/import/escloud/update/potential", "/api/iam/v2/tenant/platform/infos", "/api/iam/v2/tenant/contactinfo/**", "/api/iam/v2/user/**/tenant/**/simple", "/api/iam/v2/tenant/getname/list", "/api/iam/v2/dev/app/fullInfo/**", "/api/iam/v2/sys/backuri", "/api/iam/v2/sys/platform/backuri", "/api/iam/v2/app/default/update", "/api/iam/v2/tenant/isv/simple"};
    }

    public List<String> getAppTokenWhiteList() {
        List noCheck = super.getAppTokenWhiteList();
        noCheck.add("/api/iam/v2/oauth2/accesstoken");
        noCheck.add("/api/iam/v2/oauth2/refreshtoken");
        noCheck.add("/api/iam/v2/oauth/accesstoken");
        noCheck.add("/api/iam/v2/oauth/refreshtoken");
        noCheck.add("/api/iam/v2/oauth/tenant/info");
        noCheck.add("/api/iam/v2/oauth/user/info");
        noCheck.add("/api/iam/v2/user/current");
        noCheck.add("/api/iam/v2/eai");
        noCheck.add("/api/iam/v2/saml/acs");
        noCheck.add("/api/iam/v2/saml/sp/metadata");
        noCheck.add("/api/iam/v2/saml/login");
        noCheck.add("/api/iam/v2/saml/logout");
        noCheck.add("/api/iam/v2/sys/platform/ids");
        noCheck.add("/api/iam/v1/isv/credential/secret/current");
        noCheck.add("/api/iam/v2/cas");
        noCheck.add("/api/iam/v2/oidc/*/*");
        return noCheck;
    }

    public AuthoredSys getLoginSys(HttpServletRequest request, String appId) {
        Sys sys = this.commonCacheService.getSysById(appId);
        return Sys.loginSys((Sys)sys);
    }

    public AuthoredUser getLoginUser(InternalInfo internalInfo) {
        if (internalInfo.getSys() != null) {
            Sys sys = this.commonCacheService.getSysById(internalInfo.getSys().getId());
            AppAuthContextHolder.getContext().setAuthoredSys(Sys.loginSys((Sys)sys));
        }
        if (internalInfo.getUser() != null) {
            return (AuthoredUser)JsonUtils.convertObj((Object)internalInfo.getUser(), IamAuthoredUser.class);
        }
        return null;
    }

    public AuthoredUser getLoginUser(HttpServletRequest request, String token) {
        return this.authoredUserService.getByUserToken(token);
    }

    public AuthoredUser anonymous() {
        return new IamAuthoredUser();
    }

    public boolean allowAnonymous(String appName, String requestURI, boolean internal) {
        return super.allowAnonymous(appName, requestURI, internal) || "/api/iam/v2/identity/logout".equals(requestURI);
    }

    public void addCustomFilter(HttpSecurity http, AuthenticationManager authenticationManager) throws Exception {
        super.addCustomFilter(http, authenticationManager);
        http.addFilterBefore((Filter)new OauthAccessTokenAuthenticationFilter(authenticationManager, this.authoredUserService), UsernamePasswordAuthenticationFilter.class);
        http.addFilter((Filter)new NoTokenLogAuthenticationFilter(authenticationManager));
    }
}

