/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.config;

import com.digiwin.dap.middle.cache.limiter.RateLimiter;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Primary
public class GroundConfigAspect {
    private static final Logger logger = LoggerFactory.getLogger(GroundConfigAspect.class);
    @Autowired
    private EnvProperties envProperties;

    @Before(value="(@annotation(com.digiwin.dap.middle.cache.limiter.RateLimiter))")
    public void changeRequestToken(JoinPoint joinPoint) {
        try {
            if (0 != this.envProperties.getCloud()) {
                RateLimiter rateLimiter = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(RateLimiter.class);
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(rateLimiter);
                Field f = invocationHandler.getClass().getDeclaredField("memberValues");
                f.setAccessible(true);
                Map memberValues = (Map)f.get(invocationHandler);
                memberValues.put("requestedTokens", 1);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

