/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.escloud.impl;

import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.dump.escloud.EsCloudService;
import com.digiwin.dap.middleware.iam.util.SqlUtil;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EsCloudServiceImpl
implements EsCloudService {
    private static final int LEN = 1024;
    private static final String HASH = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    private static final String TARGET_TYPE = "role";
    private static final String[] ROLE_LIST = new String[]{"endUser", "mis"};
    private static final String[] SYS_LIST = new String[]{"ServiceCloud", "DigiwinCloud"};
    private static final Map<String, String> ROLE_APP_ACTION_MAP = new HashMap();
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private SysCrudService sysCrudService;

    public String repairFunction() {
        ArrayList<String> policies = new ArrayList<String>();
        ArrayList<String> policyOnRoles = new ArrayList<String>();
        ArrayList<String> statements = new ArrayList<String>();
        for (String sysId : SYS_LIST) {
            long sysSid = this.sysCrudService.getSidById(sysId);
            for (String roleId : ROLE_LIST) {
                String key = String.format("%s_%s", roleId, sysId);
                if (!ROLE_APP_ACTION_MAP.containsKey(key)) continue;
                List lists = this.jdbcTemplate.queryForList(String.format("select sid, tenant_sid, id, name from role where id='%s' and sid not in (select r.sid from role r join policyonrole m on m.role_sid = r.sid join policy p on p.sid = m.policy_sid where r.id='%s' and p.sys_sid= %s)", roleId, roleId, sysSid));
                ArrayList<Role> roles = new ArrayList<Role>();
                for (Object obj : lists) {
                    Map map = (Map)obj;
                    Role role = new Role();
                    role.setSid(Long.parseLong(map.get("sid").toString()));
                    role.setTenantSid(Long.parseLong(map.get("tenant_sid").toString()));
                    role.setId(map.get("id").toString());
                    role.setName(map.get("name").toString());
                    roles.add(role);
                }
                List actionSids = this.jdbcTemplate.queryForList(String.format("select a.sid from action a join module m on m.sid = a.module_sid join sys s on s.sid = m.app_sid where s.sid = %s and a.id in (%s)", sysSid, ROLE_APP_ACTION_MAP.get(key)), Long.class);
                for (Role role : roles) {
                    long policySid = SnowFlake.getInstance().newId();
                    String policyId = String.format("%s_%s_%s", "role", role.getId(), sysId);
                    policies.add(String.format("(%s, %s, '%s', '%s', %s, '%s'),", policySid, role.getTenantSid(), policyId, policyId, sysSid, HASH));
                    policyOnRoles.add(String.format("(%s, %s, %s, %s, '%s'),", SnowFlake.getInstance().newId(), role.getTenantSid(), policySid, role.getSid(), HASH));
                    for (Long actionSid : actionSids) {
                        statements.add(String.format("(%s, 'allow', %s, %s, %s, 'action', '%s'),", SnowFlake.getInstance().newId(), role.getTenantSid(), policySid, actionSid, HASH));
                    }
                }
            }
        }
        LinkedHashMap<String, String> mapSql = new LinkedHashMap<String, String>(3);
        mapSql.put("policy", "insert into policy(sid, tenant_sid, id, name, sys_sid, hash) values");
        mapSql.put("policyonrole", "insert into policyonrole(sid, tenant_sid, policy_sid, role_sid, hash) values");
        mapSql.put("statement", "insert into statement(sid, effect, tenant_sid, policy_sid, target_sid, type, hash) values");
        LinkedHashMap<String, ArrayList<String>> mapValue = new LinkedHashMap<String, ArrayList<String>>(3);
        mapValue.put("policy", policies);
        mapValue.put("policyonrole", policyOnRoles);
        mapValue.put("statement", statements);
        List results = SqlUtil.packageSql(mapSql, mapValue);
        for (String result : results) {
            this.jdbcTemplate.execute(result);
        }
        return HASH;
    }

    public Map<String, Integer> repairFunctionDel(String hash) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("policy", this.jdbcTemplate.update(String.format("delete from policy where hash = '%s'", hash)));
        map.put("policyonrole", this.jdbcTemplate.update(String.format("delete from policyonrole where hash = '%s'", hash)));
        map.put("statement", this.jdbcTemplate.update(String.format("delete from statement where hash = '%s'", hash)));
        return map;
    }

    public static void main(String[] args) {
        String sql = "insert into policy(sid, tenant_sid, id, name, sys_sid, hash) values";
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            values.add("(1, 99990000, '99990000', '\u9f0e\u6377', 111, 'hash'),");
        }
        List strings = EsCloudServiceImpl.packageSql((String)sql, values, (int)1000);
        System.out.println("strings = " + strings);
    }

    private static List<String> packageSql(String sql, List<String> values, int len) {
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        StringBuilder batchSql = new StringBuilder();
        for (String value : values) {
            if (i % len == 0) {
                batchSql.append(sql);
                batchSql.append("\n");
            }
            batchSql.append(value);
            batchSql.append("\n");
            if (++i % len != 0) continue;
            batchSql.deleteCharAt(batchSql.length() - 1);
            batchSql.deleteCharAt(batchSql.length() - 1);
            batchSql.append(";");
            results.add(batchSql.toString());
            batchSql.delete(0, batchSql.length());
        }
        if (i % len != 0) {
            batchSql.deleteCharAt(batchSql.length() - 1);
            batchSql.deleteCharAt(batchSql.length() - 1);
            batchSql.append(";");
            results.add(batchSql.toString());
        }
        return results;
    }

    static {
        ROLE_APP_ACTION_MAP.put("endUser_ServiceCloud", "'newissue','submitupdaterequestissueslist','submitupdaterequestissues'");
        ROLE_APP_ACTION_MAP.put("mis_ServiceCloud", "'askToBeController','newissue','submitupdaterequestissueslist','submitupdaterequestissues'");
        ROLE_APP_ACTION_MAP.put("endUser_DigiwinCloud", "'djc-mang-order'");
        ROLE_APP_ACTION_MAP.put("mis_DigiwinCloud", "'djc-mang-order'");
    }
}

