/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.extract.impl;

import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.app.ActionInfoVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionPolicy;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.AttachedVO;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetAction;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetVO;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.ActionMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.PolicyRepository;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleOldService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.dump.extract.BaseExtractService;
import com.digiwin.dap.middleware.iam.support.dump.extract.domain.BaseSysAction;
import com.digiwin.dap.middleware.iam.support.dump.extract.domain.BaseSysExcel;
import com.digiwin.dap.middleware.iam.support.dump.extract.domain.BaseSysModule;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.PurchaseService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.SellingStrategyVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BaseExtractServiceImpl
implements BaseExtractService {
    private static final Logger logger = LoggerFactory.getLogger(BaseExtractServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private ActionMapper actionMapper;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private PurchaseService purchaseService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private PolicyHandleOldService policyHandleOldService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private BaseExtractService baseExtractService;
    @Autowired
    private PolicyRepository policyRepository;
    @Autowired
    private AuthService authService;

    public static LocalDateTime getMaxDateTime(LocalDateTime oldDateTime, LocalDateTime newDateTime) {
        return oldDateTime.isAfter(newDateTime) ? oldDateTime : newDateTime;
    }

    public void migrationAuth1(List<String> newSysIds, List<String> tenantIds, List<BaseSysExcel> oldSysActions, boolean policy) {
        this.excelDataCheck1(newSysIds, tenantIds, oldSysActions);
        ArrayList<BaseSysAction> newSysActions = new ArrayList<BaseSysAction>();
        for (String sysId : newSysIds) {
            BaseSysAction newSysAction = new BaseSysAction();
            newSysAction.setSysSid(Long.valueOf(this.sysCrudService.getSidById(sysId)));
            newSysAction.setSysId(sysId);
            List actionIds = this.actionMapper.findActionIdBySysId(sysId);
            newSysAction.setActions(actionIds.stream().collect(Collectors.toMap(Action::getId, Action::getName, (k1, k2) -> k1)));
            Goods goods = this.gmcService.getGoodsInfoForTestEnv(sysId);
            if (goods.getSellingStrategys().isEmpty()) {
                throw new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728\u9500\u552e\u65b9\u6848\uff1a" + sysId);
            }
            newSysAction.setStrategyCode(((SellingStrategyVO)goods.getSellingStrategys().get(0)).getCode());
            newSysActions.add(newSysAction);
        }
        for (String tenantId : tenantIds) {
            List userIds;
            logger.info("begin migration1 \u5171\u6709\u79df\u6237\uff1a{}\uff0c \u5f53\u524d\u6267\u884c\u79df\u6237\uff1a{}", (Object)tenantIds.size(), (Object)tenantId);
            List oldAuths = this.cacService.queryAllAuthorization(tenantId);
            for (AuthorizationResultVO oldAuth : oldAuths) {
                userIds = this.cacService.queryAuthUser(tenantId, oldAuth.getCode());
                oldAuth.setUserIds(userIds);
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            List users = this.userMapper.getAllUsersByTenantSid(Long.valueOf(tenant.getSid()));
            userIds = users.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
            for (BaseSysAction newSysAction : newSysActions) {
                Map userModuleMap = this.baseExtractService.authTenantSys1(tenant, oldAuths, users, userIds, newSysAction, oldSysActions);
                this.policyRepository.removeByTenantSidAndSysSidAndType(tenant.getSid(), newSysAction.getSysSid().longValue(), TargetType.user.name());
                if (!policy || userModuleMap.isEmpty()) continue;
                for (Map.Entry entry : userModuleMap.entrySet()) {
                    this.baseExtractService.addOrUpdatePolicy1(tenant, (String)entry.getKey(), newSysAction, (Set)entry.getValue());
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdatePolicy1(Tenant tenant, String userId, BaseSysAction newSysAction, Set<String> modules) {
        PolicyTargetVO policySetting = new PolicyTargetVO();
        List targets = modules.stream().map(p -> new PolicyTargetAction(p, p)).collect(Collectors.toList());
        policySetting.setTargets(targets);
        policySetting.setAttachment(new AttachedVO(userId, TargetType.user.name()));
        this.policyHandleOldService.updatePolicyTarget(tenant.getSid(), newSysAction.getSysSid().longValue(), newSysAction.getSysId(), policySetting);
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Set<String>> authTenantSys1(Tenant tenant, List<AuthorizationResultVO> oldAuths, List<User> allUsers, List<String> userIds, BaseSysAction newSysAction, List<BaseSysExcel> oldSysActions) {
        List authSysIds = oldAuths.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList());
        Set newActionIds = newSysAction.getActions().keySet();
        Map sysActionMap = oldSysActions.stream().filter(p -> authSysIds.contains(p.getId()) && newActionIds.contains(p.getActionId())).collect(Collectors.groupingBy(BaseSysExcel::getId, Collectors.mapping(BaseSysExcel::getActionId, Collectors.toSet())));
        if (sysActionMap.isEmpty()) {
            logger.info("noAuthModule tenant={}, sysId={}", (Object)tenant.getId(), (Object)newSysAction.getSysId());
            return Collections.emptyMap();
        }
        Set<String> oldAuthSysIds = sysActionMap.keySet();
        Set authActionIds = sysActionMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        List oldSysAuths = oldAuths.stream().filter(p -> oldAuthSysIds.contains(p.getCode())).collect(Collectors.toList());
        HashMap modules = new HashMap();
        newSysAction.getActions().forEach((key, value) -> {
            if (authActionIds.contains(key)) {
                modules.put(key, value);
            }
        });
        int totalUserCount = userIds.size();
        LocalDateTime expiredTime = oldSysAuths.stream().map(AuthorizationResultVO::getExpiredTime).filter(Objects::nonNull).max(LocalDateTime::compareTo).orElse(null);
        List authUserIds = oldSysAuths.stream().flatMap(p -> p.getUserIds().stream()).distinct().filter(userIds::contains).collect(Collectors.toList());
        AuthDataDO authDataDO = new AuthDataDO();
        authDataDO.setAppId(newSysAction.getSysId());
        authDataDO.setStrategyCode(newSysAction.getStrategyCode());
        authDataDO.setUserNumber(Integer.valueOf(totalUserCount));
        authDataDO.setEffectiveDateTime(LocalDateTime.now());
        authDataDO.setExpiredDateTime(expiredTime);
        Set stats = sysActionMap.entrySet().stream().map(p -> (String)p.getKey() + ":" + ((Set)p.getValue()).size()).collect(Collectors.toSet());
        authDataDO.setMemo("\u5408\u8ba1(" + authActionIds.size() + "): " + stats);
        logger.info("auth: tenant={}, sysId={}, strategyCode={}, totalUserCount={}, expiredTime={}, modules={}, userId={}", new Object[]{tenant.getId(), newSysAction.getSysId(), newSysAction.getStrategyCode(), totalUserCount, expiredTime, modules.size(), authUserIds.size()});
        this.cacService.deletePurchaseGoods(tenant.getId(), newSysAction.getSysId());
        GoodsAuthDO goodsAuthDO = new GoodsAuthDO(authDataDO, tenant, authUserIds);
        List authModules = modules.entrySet().stream().map(p -> new AuthorizationModuleVO((String)p.getKey(), (String)p.getValue())).collect(Collectors.toList());
        goodsAuthDO.setModules(authModules);
        this.purchaseService.purchaseAuth(tenant.getId(), goodsAuthDO);
        SysVO sysVO = new SysVO();
        sysVO.setId(newSysAction.getSysId());
        this.purchaseApplicationService.purchaseApplication(tenant.getId(), "virtual", sysVO, false);
        return this.getUserModuleMap(authUserIds, oldSysAuths, sysActionMap);
    }

    private Map<String, Set<String>> getUserModuleMap(List<String> authUserIds, List<AuthorizationResultVO> oldSysAuths, Map<String, Set<String>> sysActionMap) {
        HashMap userSysMap = new HashMap();
        for (String authUserId : authUserIds) {
            userSysMap.put(authUserId, new HashSet());
        }
        for (AuthorizationResultVO oldSysAuth : oldSysAuths) {
            for (String userId : oldSysAuth.getUserIds()) {
                ((Set)userSysMap.get(userId)).add(oldSysAuth.getCode());
            }
        }
        HashMap<String, Set<String>> userModuleMap = new HashMap<String, Set<String>>();
        for (Map.Entry entry : userSysMap.entrySet()) {
            HashSet userModules = new HashSet();
            for (String sys : (Set)entry.getValue()) {
                userModules.addAll(sysActionMap.get(sys));
            }
            userModuleMap.put((String)entry.getKey(), userModules);
        }
        return userModuleMap;
    }

    private void excelDataCheck1(List<String> appIds, List<String> tenantIds, List<BaseSysExcel> oldSysActions) {
        Map oldAppActionIdMap = oldSysActions.stream().collect(Collectors.groupingBy(BaseSysExcel::getId, Collectors.mapping(BaseSysExcel::getActionId, Collectors.toList())));
        ArrayList<String> nullApp = new ArrayList<String>();
        for (String appId : appIds) {
            Sys sys = (Sys)this.sysCrudService.findById(appId);
            if (sys != null) continue;
            nullApp.add(appId);
        }
        if (!nullApp.isEmpty()) {
            throw new BusinessException("\u65b0\u5e94\u7528\u4e0d\u5b58\u5728\uff1a" + nullApp);
        }
        ArrayList<String> nullTenant = new ArrayList<String>();
        for (String string : tenantIds) {
            Tenant tenant = (Tenant)this.tenantCrudService.findById(string);
            if (tenant != null) continue;
            nullTenant.add(string);
        }
        if (!nullTenant.isEmpty()) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728\uff1a" + nullTenant);
        }
        for (Map.Entry entry : oldAppActionIdMap.entrySet()) {
            Sys sys = (Sys)this.sysCrudService.findById((String)entry.getKey());
            if (sys != null) continue;
            nullApp.add((String)entry.getKey());
        }
        if (!nullApp.isEmpty()) {
            throw new BusinessException("\u65e7\u5e94\u7528\u4e0d\u5b58\u5728\uff1a" + nullApp);
        }
    }

    public void migrationAuth2(List<BaseSysExcel> apps, List<String> tenantIds, List<BaseSysExcel> modules) {
        this.excelDataCheck2(apps, tenantIds, modules);
        ArrayList<BaseSysModule> sysModules = new ArrayList<BaseSysModule>();
        for (BaseSysExcel app : apps) {
            String sysId = app.getId();
            String newSysId = app.getName();
            BaseSysModule sysModule = new BaseSysModule();
            sysModule.setOldSysSid(Long.valueOf(this.sysCrudService.getSidById(sysId)));
            sysModule.setOldSysId(sysId);
            sysModule.setSysSid(Long.valueOf(this.sysCrudService.getSidById(newSysId)));
            sysModule.setSysId(newSysId);
            Goods goods = this.gmcService.getGoodsInfoForTestEnv(newSysId);
            if (goods.getSellingStrategys().isEmpty()) {
                throw new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728\u9500\u552e\u65b9\u6848\uff1a" + newSysId);
            }
            sysModule.setStrategyCode(((SellingStrategyVO)goods.getSellingStrategys().get(0)).getCode());
            sysModules.add(sysModule);
        }
        for (String tenantId : tenantIds) {
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            for (BaseSysModule sysModule : sysModules) {
                logger.info("begin migration2, tenantId: {}, {}->{}", new Object[]{tenantId, sysModule.getOldSysId(), sysModule.getSysId()});
                Map userModuleMap = this.baseExtractService.authTenantSys2(tenant, sysModule, modules);
                if (userModuleMap.isEmpty()) continue;
                for (Map.Entry entry : userModuleMap.entrySet()) {
                    User user = (User)this.userCrudService.findById((String)entry.getKey());
                    if (user == null) {
                        logger.error("migration2 user {} not exists", entry.getKey());
                        continue;
                    }
                    CalcUser calcUser = new CalcUser();
                    calcUser.setTenantSid(tenant.getSid());
                    calcUser.setTenantId(tenant.getId());
                    calcUser.setUserSid(user.getSid());
                    calcUser.setUserId(user.getId());
                    calcUser.setAppSid(sysModule.getOldSysSid().longValue());
                    calcUser.setAppId(sysModule.getOldSysId());
                    UserPermissionResult userPermission = this.authService.getUserPermission(calcUser, null);
                    List actionIds = userPermission.getPermissions().stream().map(PermissionPolicy::getId).collect(Collectors.toList());
                    List needFun = ((List)entry.getValue()).stream().filter(p -> p.getId() == null || actionIds.contains(p.getName())).collect(Collectors.toList());
                    this.baseExtractService.addOrUpdatePolicy2(tenant, user.getSid(), sysModule, needFun);
                }
            }
        }
    }

    public Map<String, List<BaseSysExcel>> authTenantSys2(Tenant tenant, BaseSysModule sysModule, List<BaseSysExcel> modules) {
        LocalDateTime expiredTime;
        int totalUserCount;
        List<String> authUserIds;
        String tenantId = tenant.getId();
        AuthorizationResultVO oldAuth = this.getAuth(tenantId, sysModule.getOldSysId());
        if (oldAuth == null || LocalDateTime.now().isAfter(oldAuth.getExpiredTime())) {
            logger.error("No need auth, tenant: {}, oldSysId: {}, expiredTime: {}", new Object[]{tenantId, sysModule.getOldSysId(), oldAuth == null ? "" : oldAuth.getExpiredTime()});
            return Collections.emptyMap();
        }
        AuthorizationResultVO newAuth = this.getAuth(tenantId, sysModule.getSysId());
        if (newAuth == null) {
            authUserIds = oldAuth.getUserIds();
            totalUserCount = oldAuth.getTotalUserCount();
            expiredTime = oldAuth.getExpiredTime();
        } else {
            authUserIds = Stream.concat(oldAuth.getUserIds().stream(), newAuth.getUserIds().stream()).distinct().collect(Collectors.toList());
            totalUserCount = Math.max(Math.max(oldAuth.getTotalUserCount(), newAuth.getTotalUserCount()), authUserIds.size());
            expiredTime = BaseExtractServiceImpl.getMaxDateTime((LocalDateTime)oldAuth.getExpiredTime(), (LocalDateTime)newAuth.getExpiredTime());
        }
        ArrayList<BaseSysExcel> validModules = new ArrayList<BaseSysExcel>();
        ArrayList<AuthorizationModuleVO> newAuthModules = new ArrayList<AuthorizationModuleVO>();
        for (AuthorizationModuleVO enabledModule : oldAuth.getEnabledModules()) {
            Optional<BaseSysExcel> first = modules.stream().filter(p -> enabledModule.getId().equals(p.getId())).findFirst();
            if (!first.isPresent()) continue;
            BaseSysExcel temp = first.get();
            if (!temp.getId().equals(temp.getActionId())) {
                newAuthModules.add(new AuthorizationModuleVO(temp.getActionId(), temp.getModuleName()));
            } else {
                newAuthModules.add(new AuthorizationModuleVO(enabledModule.getId(), enabledModule.getName()));
            }
            validModules.add(temp);
        }
        for (BaseSysExcel module : modules) {
            if (module.getId() != null) continue;
            newAuthModules.add(new AuthorizationModuleVO(module.getActionId(), module.getModuleName()));
            validModules.add(module);
        }
        AuthDataDO authDataDO = new AuthDataDO();
        authDataDO.setAppId(sysModule.getSysId());
        authDataDO.setStrategyCode(sysModule.getStrategyCode());
        authDataDO.setUserNumber(Integer.valueOf(totalUserCount));
        authDataDO.setEffectiveDateTime(LocalDateTime.now());
        authDataDO.setExpiredDateTime(expiredTime);
        authDataDO.setMemo("modules: " + newAuthModules.size() + ", oldUsers: " + oldAuth.getUserIds().size() + ", newUsers: " + (newAuth == null ? 0 : newAuth.getUserIds().size()) + ", users: " + authUserIds.size());
        GoodsAuthDO goodsAuthDO = new GoodsAuthDO(authDataDO, tenant, authUserIds);
        goodsAuthDO.setModules(newAuthModules);
        this.purchaseService.purchaseAuth(tenant.getId(), goodsAuthDO);
        SysVO sysVO = new SysVO();
        sysVO.setId(sysModule.getSysId());
        this.purchaseApplicationService.purchaseApplication(tenant.getId(), "virtual", sysVO, false);
        HashMap<String, List<BaseSysExcel>> userModuleMap = new HashMap<String, List<BaseSysExcel>>();
        authUserIds.forEach(p -> userModuleMap.put((String)p, (List<BaseSysExcel>)validModules));
        return userModuleMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdatePolicy2(Tenant tenant, long userSid, BaseSysModule sysModule, List<BaseSysExcel> moduleActions) {
        PolicyTargetVO policySetting = new PolicyTargetVO();
        List targets = moduleActions.stream().map(p -> new PolicyTargetAction(p.getActionId(), p.getActionName())).collect(Collectors.toList());
        policySetting.setTargets(targets);
        this.policyHandleOldService.savePolicyStatement(tenant.getSid(), sysModule.getSysSid().longValue(), userSid, TargetType.user.name(), policySetting, Integer.valueOf(1));
    }

    private AuthorizationResultVO getAuth(String tenantId, String sysId) {
        AuthorizationResultVO oldAuth = this.cacService.queryAllAuthorization(tenantId, sysId);
        if (oldAuth != null) {
            List oldUserIds = this.cacService.queryAuthUser(tenantId, oldAuth.getCode());
            oldAuth.setUserIds(oldUserIds);
            return oldAuth;
        }
        return null;
    }

    private void excelDataCheck2(List<BaseSysExcel> apps, List<String> tenantIds, List<BaseSysExcel> modules) {
        for (BaseSysExcel app : apps) {
            Sys oldSys = (Sys)this.sysCrudService.findById(app.getId());
            if (oldSys == null) {
                throw new BusinessException("\u65e7\u5e94\u7528\u4e0d\u5b58\u5728\uff1a" + app.getId());
            }
            for (BaseSysExcel module : modules) {
                if (module.getId() == null) continue;
                this.checkModule(oldSys, module.getId(), module.getName(), module);
            }
            Sys sys = (Sys)this.sysCrudService.findById(app.getName());
            if (sys == null) {
                throw new BusinessException("\u65b0\u5e94\u7528\u4e0d\u5b58\u5728\uff1a" + app.getName());
            }
            for (BaseSysExcel module : modules) {
                this.checkModule(sys, module.getActionId(), module.getActionName(), module);
            }
        }
        ArrayList<String> nullTenant = new ArrayList<String>();
        for (String tenantId : tenantIds) {
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (tenant != null) continue;
            nullTenant.add(tenantId);
        }
        if (!nullTenant.isEmpty()) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728\uff1a" + nullTenant);
        }
    }

    private void checkModule(Sys sys, String moduleId, String actionId, BaseSysExcel module) {
        ActionInfoVO action = this.actionMapper.findActionIdBySysSid(sys.getSid(), moduleId, actionId);
        if (action == null) {
            throw new BusinessException(String.format("\u5e94\u7528[%s]\u6a21\u7ec4[%s]\u884c\u4e3a[%s]\u4e0d\u5b58\u5728", sys.getId(), moduleId, actionId));
        }
        module.setModuleName(action.getModuleName());
    }
}

