/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.policy;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuType;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementType;
import com.digiwin.dap.middleware.iam.support.dump.policy.TempPolicy;
import com.digiwin.dap.middleware.iam.support.dump.policy.TempStatement;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PolicyUpgradeService {
    private static final int NUM = 1000;
    private static final Map<Object, Map<Object, List<TempStatement>>> tenantPolicyStatements = new HashMap();
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PolicyUpgradeService policyUpgradeService;

    private static List<TempPolicy> buildPolicy(List<Map<String, Object>> policies) {
        ArrayList<TempPolicy> tempPolicies = new ArrayList<TempPolicy>();
        for (Map<String, Object> policy : policies) {
            TempPolicy tempPolicy = new TempPolicy();
            tempPolicy.setPolicySid(String.valueOf(policy.get("sid")));
            tempPolicy.setTenantSid(String.valueOf(policy.get("tenant_sid")));
            tempPolicy.setStatementValue(String.valueOf(policy.getOrDefault("statement_value", null)));
            tempPolicies.add(tempPolicy);
        }
        return tempPolicies;
    }

    private static List<TempStatement> buildStatement(List<Map<String, Object>> statements) {
        ArrayList<TempStatement> tempStatements = new ArrayList<TempStatement>();
        for (Map<String, Object> statement : statements) {
            TempStatement tempStatement = new TempStatement();
            tempStatement.setTenantSid(String.valueOf(statement.get("tenant_sid")));
            tempStatement.setPolicySid(String.valueOf(statement.get("policy_sid")));
            tempStatement.setTargetSid(String.valueOf(statement.get("target_sid")));
            tempStatement.setEffect(String.valueOf(statement.get("effect")));
            tempStatement.setType(String.valueOf(statement.get("type")));
            tempStatements.add(tempStatement);
        }
        return tempStatements;
    }

    private static void initTenantPolicyStatements(List<Map<String, Object>> statements) {
        Map<Object, List<TempStatement>> tenantStatementMap = PolicyUpgradeService.buildStatement(statements).stream().collect(Collectors.groupingBy(TempStatement::getTenantSid));
        for (Map.Entry<Object, List<TempStatement>> entry : tenantStatementMap.entrySet()) {
            tenantPolicyStatements.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(TempStatement::getPolicySid)));
        }
    }

    private static List<TempStatement> getPolicyStatement(Object tenantSid, Object policySid) {
        Map policyStatementMap = (Map)tenantPolicyStatements.get(tenantSid);
        if (policyStatementMap == null) {
            return Collections.emptyList();
        }
        List<TempStatement> statements = policyStatementMap.getOrDefault(policySid, Collections.emptyList());
        ((Map)tenantPolicyStatements.get(tenantSid)).remove(policySid);
        return statements;
    }

    private static String getStatementValue(List<TempStatement> statements) {
        if (statements.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (TempStatement statement : statements) {
            builder.append(statement.getTargetSid()).append(":").append(PolicyUpgradeService.getEffect((Object)statement.getType(), (Object)statement.getEffect())).append(";");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private static int getEffect(Object type, Object effect) {
        if (MenuType.module.name().equals(type)) {
            if (MenuEffect.allow.name().equals(effect)) {
                return StatementType.MODULE_ALLOW.ordinal();
            }
            return StatementType.MODULE_DENY.ordinal();
        }
        if (MenuEffect.allow.name().equals(effect)) {
            return StatementType.ACTION_ALLOW.ordinal();
        }
        return StatementType.ACTION_DENY.ordinal();
    }

    public void upgrade(PrintWriter writer, String step) {
        if ("1".equals(step)) {
            this.policyUpgradeService.setStatementSid();
        }
        long sumCount = 0L;
        boolean hasNext = true;
        while (hasNext) {
            int count = this.policyUpgradeService.doUpgrade(writer, step);
            if (count == 0) {
                tenantPolicyStatements.clear();
                hasNext = false;
                continue;
            }
            writer.println("<h3>\u672c\u6b21\u66f4\u65b0\uff1a" + count + "\u6761\uff0c\u603b\u5171\u66f4\u65b0\u6210\u529f\uff1a" + (sumCount += (long)count) + "\u6761\u3002</h3>");
            writer.flush();
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int doUpgrade(PrintWriter writer, String step) {
        List policies = new ArrayList();
        if ("1".equals(step)) {
            policies = this.findPolicy();
            this.upgradePolicy(policies);
        } else if ("2".equals(step)) {
            if (this.getStatementSid() == null || this.getStatementSid() == 0L) {
                writer.write("<h3>\u5f53\u524d\u5b9e\u4f8b\u4e0d\u662f\u6267\u884cstep1\u7684\u5b9e\u4f8b\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002</h3>");
                writer.flush();
            } else {
                tenantPolicyStatements.clear();
                policies = this.findPolicyLeft();
                this.upgradePolicy(policies);
                this.policyUpgradeService.setStatementSid();
            }
        }
        return policies.size();
    }

    public List<TempPolicy> findPolicy() {
        List policies = this.jdbcTemplate.queryForList(String.format("select sid, tenant_sid from policy where statement_value is null limit %s", 1000));
        return PolicyUpgradeService.buildPolicy((List)policies);
    }

    public List<TempPolicy> findPolicyLeft() {
        List policies = this.jdbcTemplate.queryForList(String.format("select sid, tenant_sid, statement_value from policy WHERE sid IN(select distinct policy_sid from statement where sid>%s)", this.getStatementSid()));
        return PolicyUpgradeService.buildPolicy((List)policies);
    }

    public void setStatementSid() {
        Long statementSid = (Long)this.jdbcTemplate.queryForObject("SELECT MAX(sid) FROM statement", Long.class);
        RedisUtils.set((String)"iam:statement:sid", (Object)statementSid);
    }

    public Long getStatementSid() {
        Long statementSid = (Long)RedisUtils.get((Object)"iam:statement:sid", Long.class);
        if (statementSid == null) {
            return 0L;
        }
        return statementSid;
    }

    public void upgradePolicy(List<TempPolicy> policies) {
        if (!policies.isEmpty()) {
            String policySidIn = policies.stream().map(TempPolicy::getPolicySid).collect(Collectors.joining(",", "(", ")"));
            String tenantSidIn = policies.stream().map(TempPolicy::getTenantSid).distinct().collect(Collectors.joining(",", "(", ")"));
            StringBuilder builder = new StringBuilder("UPDATE policy SET statement_value = CASE sid ");
            for (TempPolicy policy : policies) {
                builder.append(" WHEN ").append(policy.getPolicySid()).append(" THEN '").append(this.getStatementValue((Object)policy.getTenantSid(), (Object)policy.getPolicySid())).append("'");
            }
            builder.append(" END WHERE sid IN ").append(policySidIn).append(" AND tenant_sid in ").append(tenantSidIn);
            this.jdbcTemplate.update(builder.toString());
        }
    }

    public String getStatementValue(Object tenantSid, Object policySid) {
        List tempStatements = this.getDbStatementTenant(tenantSid, policySid);
        return PolicyUpgradeService.getStatementValue((List)tempStatements);
    }

    public List<TempStatement> getDbStatementTenant(Object tenantSid, Object policySid) {
        if (!tenantPolicyStatements.containsKey(tenantSid)) {
            List statements = this.jdbcTemplate.queryForList(String.format("select tenant_sid, policy_sid, target_sid, effect, `type` from statement s where s.tenant_sid = %s", tenantSid));
            PolicyUpgradeService.initTenantPolicyStatements((List)statements);
        }
        return PolicyUpgradeService.getPolicyStatement((Object)tenantSid, (Object)policySid);
    }
}

