/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.policy;

import com.digiwin.dap.middleware.iam.support.dump.policy.PolicyUpgradeService;
import com.digiwin.dap.middleware.iam.support.dump.policy.UpgradePolicyServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@WebServlet(value={"/api/dapware/v1/upgrade/policy"}, asyncSupported=true)
public class UpgradePolicyServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(UpgradePolicyServlet.class);
    private String message;
    @Autowired
    private PolicyUpgradeService policyUpgradeService;
    private AtomicInteger runTime = new AtomicInteger();

    public void init() {
        this.message = "\u5f00\u59cb\u5347\u7ea7\u6570\u636e";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html;charset=utf-8");
        PrintWriter out = resp.getWriter();
        out.println("<html><body>");
        out.println("<h1>" + this.message + "</h1>");
        out.flush();
        AsyncContext asyncContext = req.startAsync();
        asyncContext.setTimeout(-1L);
        asyncContext.addListener((AsyncListener)new MyListener(this));
        String step = req.getParameter("step");
        out.println("<h3>\u5f53\u524d\u6267\u884c\u5347\u7ea7\u6b65\u9aa4" + step + "...</h3>");
        this.doWork(asyncContext, step);
        out.println("<h1>\u6570\u636e\u540e\u53f0\u5347\u7ea7\u4e2d...</h1>");
        out.println("</body></html>");
        out.flush();
    }

    public void doWork(AsyncContext ac, String step) {
        ac.start(() -> {
            try {
                long start = System.currentTimeMillis();
                PrintWriter writer = ac.getResponse().getWriter();
                this.printExecuteTime(writer);
                this.policyUpgradeService.upgrade(writer, step);
                long end = System.currentTimeMillis();
                writer.println("<h3>\u603b\u5171\u8017\u65f6\uff1a" + (end - start) / 1000L + "\u79d2</h3>");
                ac.complete();
            }
            catch (Exception e) {
                logger.error("\u6570\u636e\u5347\u7ea7\u5f02\u5e38", (Throwable)e);
            }
        });
    }

    private void printExecuteTime(PrintWriter writer) {
        this.runTime.set(0);
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            writer.println("<span>\u5df2\u7ecf\u8fc7\u53bb" + this.runTime.getAndAdd(10) + "\u79d2</span>");
            writer.flush();
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public void destroy() {
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

