/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=30800)
@Service
public class UpgradeDatabaseV37ToV38Service
extends AbstractUpdateDatabaseService {
    private static Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV37ToV38Service.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private PasswordEncoder iamPasswordEncoder;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RoleMapper roleMapper;

    public String version() {
        return "3.8.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        try {
            List roleList;
            long userSid;
            this.userMapper.updatePasswordChangedState(new ArrayList());
            User user = (User)this.userCrudService.findById("virtual");
            if (user == null) {
                user = new User();
                user.setId("virtual");
                user.setName("\u865a\u62df\u7528\u6237");
                user.setPassword(this.iamPasswordEncoder.encode((CharSequence)"virtual"));
                user.setChanged(true);
                user.setType(Integer.valueOf(0));
                user.setActivated(true);
                user.setCellphonePrefix("+86");
                user.setComeFrom("DigiwinCloud");
                user.setConfirm(true);
                user.setEnterprise(true);
                user.setReadonly(true);
                user.setVisible(true);
                userSid = this.userCrudService.create((BaseEntity)user);
            } else {
                userSid = user.getSid();
            }
            List tenantSids = this.tenantMapper.getTenants();
            if (tenantSids.size() > 0) {
                String insertSql = "insert into userrelationwithtenant(sid,tenant_sid,user_sid,visible) values ";
                this.batchUpdate(insertSql, tenantSids, "(%s,%s,%s,0)", userSid);
            }
            if ((roleList = this.roleMapper.findRoleById("superadmin")).size() > 0) {
                String insertRoleSql = "insert into association(sid,role_sid,user_sid) values";
                this.batchUpdate(insertRoleSql, roleList, "(%s,%s,%s)", userSid);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void batchUpdate(String insertHeaderSql, List<Long> valueSidList, String valueSql, long userSid) {
        ArrayList<String> insertValueSqlList = new ArrayList<String>();
        int count = (int)Math.ceil((double)valueSidList.size() / 1000.0);
        if (count > 0) {
            int beginIndex = 0;
            for (int i = 1; i < count + 1; ++i) {
                for (int j = beginIndex; j < 1000 * i && valueSidList.size() > j; ++j) {
                    long sid = SnowFlake.getInstance().newId();
                    String insertValue = String.format(valueSql, sid, valueSidList.get(j), userSid);
                    insertValueSqlList.add(insertValue);
                }
                String insertAllSql = String.format("%s%s", insertHeaderSql, String.join((CharSequence)",", insertValueSqlList));
                this.jdbcTemplate.execute(insertAllSql);
                insertValueSqlList.clear();
                beginIndex = 1000 * i;
            }
        }
    }
}

