/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=40000)
@Service
public class UpgradeDatabaseV38ToV40Service
extends AbstractUpdateDatabaseService {
    private static Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV38ToV40Service.class);
    @Autowired
    private UserMapper userMapper;

    public String version() {
        return "4.0.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        try {
            List allUsers = this.userMapper.getUsers();
            Set allKeys = RedisUtils.keys((String)"iam:token:*");
            if (allKeys != null && !allKeys.isEmpty()) {
                allKeys.forEach(allKey -> {
                    IamAuthoredUser iamAuthoredUser = (IamAuthoredUser)RedisUtils.get((Object)allKey, IamAuthoredUser.class);
                    allUsers.stream().forEach(user -> {
                        if (iamAuthoredUser.getUserId().equals(user.getId())) {
                            boolean needUpdate = false;
                            if (!user.getType().equals(iamAuthoredUser.getUserType())) {
                                iamAuthoredUser.setUserType(user.getType());
                                needUpdate = true;
                            }
                            if (user.isChanged() != iamAuthoredUser.isChanged()) {
                                iamAuthoredUser.setChanged(user.isChanged());
                                needUpdate = true;
                            }
                            needUpdate = true;
                            if (true) {
                                RedisUtils.set((String)allKey, (Object)iamAuthoredUser);
                            }
                        }
                    });
                });
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}

