/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTypeEnum;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Order(value=41300)
public class UpgradeDatabaseV412ToV413Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV412ToV413Service.class);
    @Autowired
    private WhiteListRepository whiteListRepository;
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaCrudService dataPolicySchemaCrudService;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.13.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        LOGGER.info("413\u6570\u636e\u5347\u7ea7\u5f00\u59cb {}", (Object)LocalDateTime.now());
        this.updateAgreeCertificationAgreement();
        this.createDefaultInsideAppWhite();
        this.updateDataPolicySchema();
        LOGGER.info("413\u6570\u636e\u5347\u7ea7\u7ed3\u675f {}", (Object)LocalDateTime.now());
    }

    private void updateAgreeCertificationAgreement() {
        LOGGER.info(">>>> tenant\u5347\u7ea7agreeCertificationAgreement\u5f00\u59cb {}", (Object)LocalDateTime.now());
        String updateTenantSql = "UPDATE TENANT SET agree_certification_agreement = 1";
        int updateTenant = this.jdbcTemplate.update(updateTenantSql);
        LOGGER.info("<<<< \u5347\u7ea7agreeCertificationAgreement SQL\u6267\u884c\u5b8c\u6bd5 updateTenant={}, {}", (Object)updateTenant, (Object)LocalDateTime.now());
    }

    private void createDefaultInsideAppWhite() {
        List whiteLists = this.whiteListRepository.findById("WHITE_LIST_AUTO_AUTH_TENANT_APPS");
        if (whiteLists.isEmpty()) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("WHITE_LIST_AUTO_AUTH_TENANT_APPS");
            whiteList.setName("\u9ed8\u8ba4\u5e94\u7528\u540d\u5355\uff0c\u79df\u6237\u6ce8\u518c\u4e4b\u540e\u81ea\u52a8\u7ed1\u5b9a\u5185\u90e8\u5e94\u7528\u6e05\u5355");
            whiteList.setContent("digiwincloud;whale;kanban;servicecloud;");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        }
    }

    private void updateDataPolicySchema() {
        DataPolicySchemaField dataPolicySchemaField3;
        DataPolicySchemaField dataPolicySchemaField2;
        DataPolicySchemaField dataPolicySchemaField1;
        LOGGER.info(">>>> updateDataPolicySchema\u5f00\u59cb {}", (Object)LocalDateTime.now());
        DataPolicySchema dataPolicySchema = this.dataPolicySchemaRepository.findByActionIdAndTableId(ActionIdEnum.BOSS_CONSULTATION_MANAGEMENT.getId(), "goods");
        if (dataPolicySchema == null) {
            dataPolicySchema = new DataPolicySchema();
            dataPolicySchema.setActionId(ActionIdEnum.BOSS_CONSULTATION_MANAGEMENT.getId());
            dataPolicySchema.setTableId("goods");
            dataPolicySchema.setTableName("\u5546\u54c1\u7ba1\u7406");
            dataPolicySchema.setTableNameTW("\u5546\u54c1\u7ba1\u7406");
            dataPolicySchema.setTableNameUS("Goods Management");
            long dataSchemaSid = this.dataPolicySchemaCrudService.create((BaseEntity)dataPolicySchema);
            dataPolicySchema.setSid(dataSchemaSid);
        }
        if ((dataPolicySchemaField1 = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("goodsCode", Long.valueOf(dataPolicySchema.getSid()))) == null) {
            String apiUri1 = String.format("%s/api/gmc/v2/goods/code/item", this.envProperties.getGmcUri());
            dataPolicySchemaField1 = this.createSchemaFieldEntity(dataPolicySchema.getSid(), "goodsCode", "\u5546\u54c1\u7f16\u7801", "\u5546\u54c1\u7de8\u78bc", "goods code", Integer.valueOf(1), apiUri1);
            this.dataPolicySchemaFieldRepository.save((Object)dataPolicySchemaField1);
        }
        if ((dataPolicySchemaField2 = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("productCode", Long.valueOf(dataPolicySchema.getSid()))) == null) {
            String apiUri2 = String.format("%s/api/gmc/v2/product/code/item", this.envProperties.getGmcUri());
            dataPolicySchemaField2 = this.createSchemaFieldEntity(dataPolicySchema.getSid(), "productCode", "\u5546\u54c1\u7c7b\u522b", "\u5546\u54c1\u985e\u5225", "goods type", Integer.valueOf(1), apiUri2);
            this.dataPolicySchemaFieldRepository.save((Object)dataPolicySchemaField2);
        }
        if ((dataPolicySchemaField3 = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("categoryId", Long.valueOf(dataPolicySchema.getSid()))) == null) {
            String valueParam = "{\"zh-CN\":[{\"id\":\"app\",\"name\":\"\u5e94\u7528\"},{\"id\":\"service\",\"name\":\"\u670d\u52a1\"},{\"id\":\"course\",\"name\":\"\u8bfe\u7a0b\"},{\"id\":\"package\",\"name\":\"\u5957\u88c5\u8f6f\u4ef6\"},{\"id\":\"platform\",\"name\":\"\u5e73\u53f0\u670d\u52a1\"},{\"id\":\"device\",\"name\":\"\u8bbe\u5907\u8d44\u6e90\"}],\"zh-TW\":[{\"id\":\"app\",\"name\":\"\u61c9\u7528\"},{\"id\":\"service\",\"name\":\"\u670d\u52d9\"},{\"id\":\"course\",\"name\":\"\u8ab2\u7a0b\"},{\"id\":\"package\",\"name\":\"\u5957\u88dd\u8edf\u4ef6\"},{\"id\":\"platform\",\"name\":\"\u5e73\u53f0\u670d\u52d9\"},{\"id\":\"device\",\"name\":\"\u8a2d\u5099\u8cc7\u6e90\"}],\"en-US\":[{\"id\":\"app\",\"name\":\"app\"},{\"id\":\"service\",\"name\":\"service\"},{\"id\":\"course\",\"name\":\"course\"},{\"id\":\"package\",\"name\":\"package\"},{\"id\":\"platform\",\"name\":\"platform\"},{\"id\":\"device\",\"name\":\"device\"}]}";
            dataPolicySchemaField3 = this.createSchemaFieldEntity(dataPolicySchema.getSid(), "categoryId", "\u5206\u7c7b", "\u5206\u985e", "classification", Integer.valueOf(0), valueParam);
            this.dataPolicySchemaFieldRepository.save((Object)dataPolicySchemaField3);
        }
        LOGGER.info("<<<< updateDataPolicySchema SQL\u6267\u884c\u5b8c\u6bd5, {}", (Object)LocalDateTime.now());
    }

    private DataPolicySchemaField createSchemaFieldEntity(long schemaSid, String id, String name, String nameTW, String nameUS, Integer dataSource, String values) {
        DataPolicySchemaField dataPolicySchemaField = new DataPolicySchemaField();
        dataPolicySchemaField.setSchemaSid(schemaSid);
        dataPolicySchemaField.setId(id);
        dataPolicySchemaField.setName(name);
        dataPolicySchemaField.setNameTW(nameTW);
        dataPolicySchemaField.setNameUS(nameUS);
        dataPolicySchemaField.setDataType(DataTypeEnum.STRING.toString());
        dataPolicySchemaField.setDataSource(dataSource);
        dataPolicySchemaField.setFilterType("in");
        dataPolicySchemaField.setValueParams(values);
        return dataPolicySchemaField;
    }
}

