/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Order(value=41501)
public class UpgradeDatabaseV414ToV4150001Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV414ToV4150001Service.class);
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private UserMapper userMapper;

    public String version() {
        return "4.15.0.0001";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        LOGGER.info("4150001\u6570\u636e\u5347\u7ea7\u5f00\u59cb {}", (Object)LocalDateTime.now());
        try {
            List orgs = this.orgMapper.getOrgsByTenantIdAndId("99990000", "root");
            if (!orgs.isEmpty()) {
                List userSids = this.userMapper.getUserSidsByTenantIdWithoutOrg("99990000", Long.valueOf(((Org)orgs.get(0)).getSid()));
                ArrayList<String> values = new ArrayList<String>();
                for (int i = 0; i < userSids.size(); ++i) {
                    String value = String.format("(%s,%s,%s,0)", SnowFlake.getInstance().newId(), ((Org)orgs.get(0)).getSid(), userSids.get(i));
                    values.add(value);
                }
                String executeSql = String.format("insert into userinorg(sid,org_sid,user_sid,priority) values %s;", values.stream().collect(Collectors.joining(",")));
                LOGGER.info(String.format("\u6570\u636e\u5347\u7ea7\u811a\u672c:%s", executeSql));
                this.jdbcTemplate.execute(executeSql);
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        LOGGER.info("4150001\u6570\u636e\u5347\u7ea7\u7ed3\u675f {}", (Object)LocalDateTime.now());
    }
}

