/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTypeEnum;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.entity.OauthApi;
import com.digiwin.dap.middleware.iam.entity.OauthScopeApi;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.iam.repository.MetadataColumnRepository;
import com.digiwin.dap.middleware.iam.repository.OauthApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Order(value=41500)
public class UpgradeDatabaseV414ToV415Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV414ToV415Service.class);
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaCrudService dataPolicySchemaCrudService;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private MetadataColumnRepository metadataColumnRepository;
    @Autowired
    private OauthApiRepository oauthApiRepository;
    @Autowired
    private OauthScopeRepository oauthScopeRepository;
    @Autowired
    private OauthScopeApiRepository oauthScopeApiRepository;

    public String version() {
        return "4.15.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        LOGGER.info("415\u6570\u636e\u5347\u7ea7\u5f00\u59cb {}", (Object)LocalDateTime.now());
        this.updateMetadataColumn();
        this.updateDataPolicySchema();
        this.createOAuthApi();
        LOGGER.info("415\u6570\u636e\u5347\u7ea7\u7ed3\u675f {}", (Object)LocalDateTime.now());
    }

    private void updateMetadataColumn() {
        List columnList = this.metadataColumnRepository.findByCatalogId("basic");
        Iterator iterator = columnList.iterator();
        while (iterator.hasNext()) {
            MetadataColumn next = (MetadataColumn)iterator.next();
            if ("dapAcceptLanguage".equals(next.getKey()) || "userLanguage".equals(next.getKey())) {
                next.setTypeParameter(next.getTypeParameter().replace("-", "_"));
                continue;
            }
            iterator.remove();
        }
        if (columnList.isEmpty()) {
            return;
        }
        this.metadataColumnRepository.update((Iterable)columnList);
    }

    private void updateDataPolicySchema() {
        DataPolicySchemaField dataPolicySchemaField1;
        LOGGER.info(">>>> updateDataPolicySchema\u5f00\u59cb {}", (Object)LocalDateTime.now());
        DataPolicySchema dataPolicySchema = this.dataPolicySchemaRepository.findByActionIdAndTableId(ActionIdEnum.BOSS_LETTER_STATUS.getId(), "app");
        if (dataPolicySchema == null) {
            dataPolicySchema = new DataPolicySchema();
            dataPolicySchema.setActionId(ActionIdEnum.BOSS_LETTER_STATUS.getId());
            dataPolicySchema.setTableId("app");
            dataPolicySchema.setTableName("\u5e94\u7528\u7ba1\u7406");
            dataPolicySchema.setTableNameTW("\u61c9\u7528\u7ba1\u7406");
            dataPolicySchema.setTableNameUS("App Management");
            long dataSchemaSid = this.dataPolicySchemaCrudService.create((BaseEntity)dataPolicySchema);
            dataPolicySchema.setSid(dataSchemaSid);
        }
        if ((dataPolicySchemaField1 = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("goodsCode", Long.valueOf(dataPolicySchema.getSid()))) == null) {
            String apiUri1 = "{\"zh-CN\":[{\"id\":\"Athena\",\"name\":\"\u96c5\u5178\u5a1c\"},{\"id\":\"dev\",\"name\":\"\u5f00\u53d1\u8005\u95e8\u6237\"},{\"id\":\"DigiwinCloud\",\"name\":\"\u4e91\u5e02\u573a\"},{\"id\":\"Servicer\",\"name\":\"\u670d\u52a1\u5546\"},{\"id\":\"ASSC\",\"name\":\"\u552e\u540e\u4e91\"}],\"zh-TW\":[{\"id\":\"Athena\",\"name\":\"\u96c5\u5178\u5a1c\"},{\"id\":\"dev\",\"name\":\"\u958b\u767c\u8005\u9580\u6236\"},{\"id\":\"DigiwinCloud\",\"name\":\"\u96f2\u5e02\u5834\"},{\"id\":\"Servicer\",\"name\":\"\u670d\u52d9\u5546\"},{\"id\":\"ASSC\",\"name\":\"\u552e\u5f8c\u96f2\"}],\"en-US\":[{\"id\":\"Athena\",\"name\":\"Athena\"},{\"id\":\"dev\",\"name\":\"dev\"},{\"id\":\"DigiwinCloud\",\"name\":\"DigiwinCloud\"},{\"id\":\"Servicer\",\"name\":\"Servicer\"},{\"id\":\"ASSC\",\"name\":\"ASSC\"}]}";
            dataPolicySchemaField1 = this.createSchemaFieldEntity(dataPolicySchema.getSid(), "appId", "\u6240\u5c5e\u5e94\u7528", "\u6240\u5c6c\u61c9\u7528", "Application of affiliation", Integer.valueOf(0), apiUri1);
            this.dataPolicySchemaFieldRepository.save((Object)dataPolicySchemaField1);
        }
        LOGGER.info("<<<< updateDataPolicySchema SQL\u6267\u884c\u5b8c\u6bd5, {}", (Object)LocalDateTime.now());
    }

    private DataPolicySchemaField createSchemaFieldEntity(long schemaSid, String id, String name, String nameTW, String nameUS, Integer dataSource, String values) {
        DataPolicySchemaField dataPolicySchemaField = new DataPolicySchemaField();
        dataPolicySchemaField.setSchemaSid(schemaSid);
        dataPolicySchemaField.setId(id);
        dataPolicySchemaField.setName(name);
        dataPolicySchemaField.setNameTW(nameTW);
        dataPolicySchemaField.setNameUS(nameUS);
        dataPolicySchemaField.setDataType(DataTypeEnum.STRING.toString());
        dataPolicySchemaField.setDataSource(dataSource);
        dataPolicySchemaField.setFilterType("in");
        dataPolicySchemaField.setValueParams(values);
        return dataPolicySchemaField;
    }

    private void createOAuthApi() {
        ArrayList<OauthApi> oauthApis = new ArrayList<OauthApi>(2);
        OauthApi oauthApi = new OauthApi();
        oauthApi.setApi("/api/iam/v2/oauth/user/info");
        oauthApi.setModule("iam");
        oauthApi.setMethod("GET");
        oauthApis.add(oauthApi);
        oauthApi = new OauthApi();
        oauthApi.setApi("/api/iam/v2/oauth/tenant/info");
        oauthApi.setModule("iam");
        oauthApi.setMethod("GET");
        oauthApis.add(oauthApi);
        List result = this.oauthApiRepository.saveAll(oauthApis);
        List oauthScope = this.oauthScopeRepository.findAll();
        if (!oauthScope.isEmpty()) {
            oauthScope.forEach(o -> result.forEach(a -> {
                OauthScopeApi oauthScopeApi = new OauthScopeApi();
                oauthScopeApi.setScopeSid(o.getSid());
                oauthScopeApi.setApiSid(a.getSid());
                this.oauthScopeApiRepository.save((Object)oauthScopeApi);
            }));
        }
    }
}

