/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.enums.DevPlatformEnum;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.DevSysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Order(value=41900)
@Service
public class UpgradeDatabaseV418ToV419Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV418ToV419Service.class);
    @Autowired
    private DevSysRepository devSysRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public String version() {
        return "4.19.0.0";
    }

    public void update() {
        LOGGER.info("419\u6570\u636e\u5347\u7ea7\u5f00\u59cb {}", (Object)LocalDateTime.now());
        this.updateDevSys();
        this.deleteInvalidLinkedData();
        this.updateDevCertification();
        LOGGER.info("419\u6570\u636e\u5347\u7ea7\u7ed3\u675f {}", (Object)LocalDateTime.now());
    }

    private void deleteInvalidLinkedData() {
        int deleteRows = this.jdbcTemplate.update("delete a from association a join `role` r on a.role_sid = r.sid where r.tenant_sid not in (select u.tenant_sid from userrelationwithtenant u where u.user_sid = a.user_sid)");
        LOGGER.info("deleteRows={}", (Object)deleteRows);
    }

    private void updateDevCertification() {
        List tenants = this.tenantRepository.findByConfirm(1);
        LOGGER.info("confirm = 1. tenants.size()={}", (Object)tenants.size());
        ArrayList<DevCertificationDO> certificationDOList = new ArrayList<DevCertificationDO>();
        for (Tenant tenant : tenants) {
            DevCertificationDO oldDO = this.certificationRepository.findByTenantSid(tenant.getSid());
            if (oldDO == null) {
                DevCertificationDO newDO = new DevCertificationDO();
                newDO.setTenantSid(tenant.getSid());
                newDO.setSelfUploadImage(Boolean.TRUE);
                EntityUtils.setCreateFields((BaseEntity)newDO);
                certificationDOList.add(newDO);
                continue;
            }
            if (oldDO.getSelfUploadImage() != null) continue;
            oldDO.setSelfUploadImage(Boolean.TRUE);
            certificationDOList.add(oldDO);
        }
        LOGGER.info("update certification.size()={}", (Object)certificationDOList.size());
        int update = this.jdbcTemplate.update("update tenant set team_id = '3' where team_id is null or team_id = ''");
        LOGGER.info("update tenant.size()={}", (Object)update);
        this.certificationRepository.saveAll(certificationDOList);
    }

    private void updateDevSys() {
        List list = this.devSysRepository.findAll();
        List<DevSys> collect = list.stream().filter(x -> x.getDevPlatform() == null).collect(Collectors.toList());
        collect.forEach(x -> x.setDevPlatform(DevPlatformEnum.DAP_PLATFORM.getValue()));
        LOGGER.info("update devSys.size()={}", (Object)collect.size());
        this.devSysRepository.update(collect);
    }
}

