/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.constant.enums.DictEnum;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.iam.domain.SourceTypeVO;
import com.digiwin.dap.middleware.iam.entity.Team;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.TeamRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.source.SourceTypeCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Order(value=42000)
@Service
public class UpgradeDatabaseV419ToV420Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV419ToV420Service.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SourceTypeCrudService sourceTypeCrudService;
    private static final String TEAM = DictEnum.TEAM.getId();
    private static final String SOURCE_TYPE = DictEnum.SOURCE_TYPE.getId();

    public String version() {
        return "4.20.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        LOGGER.info("420\u6570\u636e\u5347\u7ea7\u5f00\u59cb {}", (Object)LocalDateTime.now());
        this.updateDict();
        this.updateDictData();
        this.updateTenantComeFrom();
        this.updateUserComeFrom();
        LOGGER.info("420\u6570\u636e\u5347\u7ea7\u7ed3\u675f {}", (Object)LocalDateTime.now());
    }

    private void updateUserComeFrom() {
        List<User> userList = this.userRepository.findByComeFromIn(Arrays.asList("\u9489\u9489", "\u91d8\u91d8", "DingDing"));
        userList = userList.stream().filter(x -> !ComeFromEnum.DINGDING.equals((Object)x.getComeFrom())).collect(Collectors.toList());
        LOGGER.info("userList.size() = {}", (Object)userList.size());
        if (!CollectionUtils.isEmpty(userList)) {
            userList.forEach(x -> x.setComeFrom(ComeFromEnum.DINGDING.getId()));
            this.userRepository.saveAll(userList);
        }
    }

    private void updateTenantComeFrom() {
        List<Tenant> tenantList = this.tenantRepository.findByComeFromIn(Arrays.asList("\u9489\u9489", "\u91d8\u91d8", "DingDing"));
        tenantList = tenantList.stream().filter(x -> !ComeFromEnum.DINGDING.getId().equals(x.getComeFrom())).collect(Collectors.toList());
        LOGGER.info("tenantList.size() = {}", (Object)tenantList.size());
        if (!CollectionUtils.isEmpty(tenantList)) {
            tenantList.forEach(x -> x.setComeFrom(ComeFromEnum.DINGDING.getId()));
            this.tenantRepository.saveAll(tenantList);
        }
    }

    private void updateDictData() {
        List dictDataList = this.dictDataService.selectDictDataList(null);
        LOGGER.info("dictDataList.size() = {}", (Object)dictDataList.size());
        Map dictDataMap = dictDataList.stream().collect(Collectors.groupingBy(DictData::getDictId, Collectors.mapping(DictData::getDictKey, Collectors.toList())));
        List teamList = this.teamRepository.findAll();
        LOGGER.info("teamList.size() = {}", (Object)teamList.size());
        for (Team team : teamList) {
            if (Optional.ofNullable(dictDataMap.get(TEAM)).orElse(Collections.emptyList()).contains(team.getId())) continue;
            DictData data = new DictData();
            data.setDictId(TEAM);
            data.setDictKey(team.getId());
            data.setDictValue(team.getName());
            data.setRemark(team.getRemark());
            data.setCreateDate(team.getCreateDate());
            data.setCreateById(team.getCreateById());
            this.dictDataService.insertDictData(data);
        }
        List sourceTypeVOList = this.sourceTypeCrudService.findAllSource();
        boolean present = sourceTypeVOList.stream().anyMatch(x -> ComeFromEnum.DINGDING.getId().equalsIgnoreCase(x.getId()));
        if (!present) {
            SourceTypeVO typeVO = new SourceTypeVO();
            typeVO.setId(ComeFromEnum.DINGDING.getId());
            typeVO.setName("\u9489\u9489");
            sourceTypeVOList.add(typeVO);
        }
        LOGGER.info("sourceTypeVOList.size() = {}", (Object)sourceTypeVOList.size());
        for (SourceTypeVO vo : sourceTypeVOList) {
            if (Optional.ofNullable(dictDataMap.get(SOURCE_TYPE)).orElse(Collections.emptyList()).contains(vo.getId())) continue;
            DictData data = new DictData();
            data.setDictId(SOURCE_TYPE);
            data.setDictKey(vo.getId());
            data.setDictValue(vo.getName());
            this.dictDataService.insertDictData(data);
        }
    }

    private void updateDict() {
        Dict dict;
        List dictList = this.dictService.selectDictList(null);
        List dictIdList = dictList.stream().map(Dict::getId).collect(Collectors.toList());
        LOGGER.info("dictIdList = {}", dictIdList);
        if (!dictIdList.contains(TEAM)) {
            dict = new Dict();
            dict.setId(TEAM);
            dict.setName("\u56e2\u961f\u7c7b\u578b");
            dict.setRemark("\u79df\u6237\u7684\u56e2\u961f\u7c7b\u578b");
            this.dictService.insertDict(dict);
        }
        if (!dictIdList.contains(SOURCE_TYPE)) {
            dict = new Dict();
            dict.setId(SOURCE_TYPE);
            dict.setName("\u79df\u6237\u7528\u6237\u6765\u6e90");
            dict.setRemark("\u79df\u6237\u3001\u7528\u6237\u6765\u6e90\u7c7b\u578b");
            this.dictService.insertDict(dict);
        }
    }
}

