/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTypeEnum;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.entity.OauthApi;
import com.digiwin.dap.middleware.iam.entity.OauthScope;
import com.digiwin.dap.middleware.iam.entity.OauthScopeApi;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.iam.repository.OauthApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=40300)
@Service
public class UpgradeDatabaseV41ToV43Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV41ToV43Service.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OauthApiRepository oauthApiRepository;
    @Autowired
    private OauthScopeRepository oauthScopeRepository;
    @Autowired
    private OauthScopeApiRepository oauthScopeApiRepository;
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;

    public String version() {
        return "4.3.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        try {
            this.createDataPolicySchema();
            this.createOauthApi();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private void createDataPolicySchema() {
        try {
            List fields;
            List schemas = this.dataPolicySchemaRepository.findAll();
            if (!schemas.isEmpty()) {
                this.dataPolicySchemaRepository.deleteAll((Iterable)schemas);
                this.dataPolicySchemaRepository.flush();
            }
            if (!(fields = this.dataPolicySchemaFieldRepository.findAll()).isEmpty()) {
                this.dataPolicySchemaFieldRepository.deleteAll((Iterable)fields);
                this.dataPolicySchemaFieldRepository.flush();
            }
            ArrayList<DataPolicySchema> dataPolicySchemas = new ArrayList<DataPolicySchema>();
            dataPolicySchemas.add(this.createSchemaEntity(ActionIdEnum.BOSS_NOTIFIER_MANAGEMENT.getId(), "notifier", "\u901a\u77e5\u4e8b\u4ef6", "\u901a\u77e5\u4e8b\u4ef6", "Notification"));
            dataPolicySchemas.add(this.createSchemaEntity(ActionIdEnum.BOSS_GOODS_MANAGEMENT.getId(), "goods", "\u5546\u54c1\u7ba1\u7406", "\u5546\u54c1\u7ba1\u7406", "Goods Management"));
            dataPolicySchemas.add(this.createSchemaEntity(ActionIdEnum.DJC_MANG_SERVICE.getId(), "app", "\u5e94\u7528\u7ba1\u7406", "\u61c9\u7528\u7ba1\u7406", "App Management"));
            List schemasEntity = this.dataPolicySchemaRepository.saveAll(dataPolicySchemas);
            ArrayList<DataPolicySchemaField> schemaFields = new ArrayList<DataPolicySchemaField>();
            for (DataPolicySchema schema : schemasEntity) {
                String valueParam;
                if (ActionIdEnum.BOSS_NOTIFIER_MANAGEMENT.getId().equalsIgnoreCase(schema.getActionId())) {
                    valueParam = "{\"zh-CN\":[{\"id\":\"Athena\",\"name\":\"\u96c5\u5178\u5a1c\"},{\"id\":\"dev\",\"name\":\"\u5f00\u53d1\u8005\u95e8\u6237\"},{\"id\":\"DigiwinCloud\",\"name\":\"\u4e91\u5e02\u573a\"}],\"zh-TW\":[{\"id\":\"Athena\",\"name\":\"\u96c5\u5178\u5a1c\"},{\"id\":\"dev\",\"name\":\"\u958b\u767c\u8005\u9580\u6236\"},{\"id\":\"DigiwinCloud\",\"name\":\"\u96f2\u5e02\u5834\"}],\"en-US\":[{\"id\":\"Athena\",\"name\":\"Athena\"},{\"id\":\"dev\",\"name\":\"dev\"},{\"id\":\"DigiwinCloud\",\"name\":\"DigiwinCloud\"}]}";
                    schemaFields.add(this.createSchemaFieldEntity(schema.getSid(), "appId", "\u6240\u5c5e\u5e94\u7528", "\u6240\u5c6c\u61c9\u7528", "Application  of affiliation", Integer.valueOf(0), valueParam));
                    continue;
                }
                if (ActionIdEnum.BOSS_GOODS_MANAGEMENT.getId().equalsIgnoreCase(schema.getActionId())) {
                    valueParam = "{\"zh-CN\":[{\"id\":\"app\",\"name\":\"\u5e94\u7528\"},{\"id\":\"service\",\"name\":\"\u670d\u52a1\"},{\"id\":\"course\",\"name\":\"\u8bfe\u7a0b\"},{\"id\":\"package\",\"name\":\"\u5957\u88c5\u8f6f\u4ef6\"},{\"id\":\"platform\",\"name\":\"\u5e73\u53f0\u670d\u52a1\"},{\"id\":\"device\",\"name\":\"\u8bbe\u5907\u8d44\u6e90\"}],\"zh-TW\":[{\"id\":\"app\",\"name\":\"\u61c9\u7528\"},{\"id\":\"service\",\"name\":\"\u670d\u52d9\"},{\"id\":\"course\",\"name\":\"\u8ab2\u7a0b\"},{\"id\":\"package\",\"name\":\"\u5957\u88dd\u8edf\u4ef6\"},{\"id\":\"platform\",\"name\":\"\u5e73\u53f0\u670d\u52d9\"},{\"id\":\"device\",\"name\":\"\u8a2d\u5099\u8cc7\u6e90\"}],\"en-US\":[{\"id\":\"app\",\"name\":\"app\"},{\"id\":\"service\",\"name\":\"service\"},{\"id\":\"course\",\"name\":\"course\"},{\"id\":\"package\",\"name\":\"package\"},{\"id\":\"platform\",\"name\":\"platform\"},{\"id\":\"device\",\"name\":\"device\"}]}";
                    schemaFields.add(this.createSchemaFieldEntity(schema.getSid(), "categoryId", "\u5206\u7c7b", "\u5206\u985e", "classification", Integer.valueOf(0), valueParam));
                    String apiUri1 = String.format("%s/api/gmc/v2/goods/code/item", this.envProperties.getGmcUri());
                    schemaFields.add(this.createSchemaFieldEntity(schema.getSid(), "goodsCode", "\u5546\u54c1\u7f16\u7801", "\u5546\u54c1\u7de8\u78bc", "goods code", Integer.valueOf(1), apiUri1));
                    String apiUri2 = String.format("%s/api/gmc/v2/product/code/item", this.envProperties.getGmcUri());
                    schemaFields.add(this.createSchemaFieldEntity(schema.getSid(), "productCode", "\u5546\u54c1\u7c7b\u522b", "\u5546\u54c1\u985e\u5225", "goods type", Integer.valueOf(1), apiUri2));
                    continue;
                }
                if (!ActionIdEnum.DJC_MANG_SERVICE.getId().equalsIgnoreCase(schema.getActionId())) continue;
                schemaFields.add(this.createSchemaFieldEntity(schema.getSid(), "appId", "\u5e94\u7528ID", "\u61c9\u7528ID", "app id", Integer.valueOf(2), ""));
            }
            this.dataPolicySchemaFieldRepository.saveAll(schemaFields);
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u636e\u6743\u9650\u5143\u6570\u636e\u5347\u7ea7\u5931\u8d25" + e);
        }
    }

    private void createOauthApi() {
        ArrayList oauthScopes = new ArrayList();
        this.addOauthScopeEntity("user_read", "\u6388\u4e88\u8bbf\u95ee\u4e2a\u4eba\u7684\u57fa\u672c\u4fe1\u606f\u7684\u6743\u9650", "\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u6635\u79f0\u3001\u90ae\u7bb1\u3001\u624b\u673a\u53f7\u7801\u7b49\u4fe1\u606f", oauthScopes);
        this.addOauthScopeEntity("user_write", "\u6388\u4e88\u4fee\u6539\u4e2a\u4eba\u57fa\u672c\u4fe1\u606f\u7684\u6743\u9650", "\u6709\u6743\u9650\u7f16\u8f91\u7528\u6237\u57fa\u672c\u4fe1\u606f\uff0c\u5305\u62ec\u624b\u673a\u53f7\u7801\u3001\u90ae\u7bb1\u3001\u6635\u79f0\u7b49\u4fe1\u606f", oauthScopes);
        this.addOauthScopeEntity("user_all", "\u6388\u6743\u5bf9\u4e2a\u4eba\u4fe1\u606f\u7684\u8bbf\u95ee\u548c\u7f16\u8f91\u6743\u9650", "\u6709\u6743\u9650\u67e5\u770b\u548c\u7f16\u8f91\u7528\u6237\u57fa\u672c\u4fe1\u606f\uff0c\u5305\u62ec\u624b\u673a\u53f7\u7801\u3001\u90ae\u7bb1\u3001\u6635\u79f0\u7b49\u4fe1\u606f", oauthScopes);
        List scopeList = this.oauthScopeRepository.saveAll(oauthScopes);
        OauthApi oauthApi = new OauthApi();
        oauthApi.setApi("/api/iam/v2/user");
        oauthApi.setModule("iam");
        OauthApi userApi = (OauthApi)this.oauthApiRepository.save((Object)oauthApi);
        oauthApi = new OauthApi();
        oauthApi.setApi("/api/iam/v2/user/update");
        oauthApi.setModule("iam");
        OauthApi userUpdateApi = (OauthApi)this.oauthApiRepository.save((Object)oauthApi);
        oauthApi = new OauthApi();
        oauthApi.setApi("/api/iam/v2/user/mobilephone/update");
        oauthApi.setModule("iam");
        OauthApi userPhoneUpdateApi = (OauthApi)this.oauthApiRepository.save((Object)oauthApi);
        oauthApi = new OauthApi();
        oauthApi.setApi("/api/iam/v2/user/email/update");
        oauthApi.setModule("iam");
        OauthApi userEmailUpdateApi = (OauthApi)this.oauthApiRepository.save((Object)oauthApi);
        ArrayList scopeApiList = new ArrayList();
        for (OauthScope o : scopeList) {
            if ("user_read".equalsIgnoreCase(o.getId())) {
                this.addOauthScopeApi(userApi.getSid(), o.getSid(), scopeApiList);
                continue;
            }
            if ("user_write".equalsIgnoreCase(o.getId())) {
                this.addOauthScopeApi(userUpdateApi.getSid(), o.getSid(), scopeApiList);
                this.addOauthScopeApi(userPhoneUpdateApi.getSid(), o.getSid(), scopeApiList);
                this.addOauthScopeApi(userEmailUpdateApi.getSid(), o.getSid(), scopeApiList);
                continue;
            }
            if (!"user_all".equalsIgnoreCase(o.getId())) continue;
            this.addOauthScopeApi(userApi.getSid(), o.getSid(), scopeApiList);
            this.addOauthScopeApi(userUpdateApi.getSid(), o.getSid(), scopeApiList);
            this.addOauthScopeApi(userPhoneUpdateApi.getSid(), o.getSid(), scopeApiList);
            this.addOauthScopeApi(userEmailUpdateApi.getSid(), o.getSid(), scopeApiList);
        }
        this.oauthScopeApiRepository.saveAll(scopeApiList);
    }

    private void addOauthScopeEntity(String id, String name, String description, List<OauthScope> oauthScopes) {
        OauthScope oauthScope = new OauthScope();
        oauthScope.setId(id);
        oauthScope.setName(name);
        oauthScope.setDescription(description);
        oauthScopes.add(oauthScope);
    }

    private void addOauthScopeApi(long apiSid, long scopeSid, List<OauthScopeApi> scopeApiList) {
        OauthScopeApi oauthScopeApi = new OauthScopeApi();
        oauthScopeApi.setApiSid(apiSid);
        oauthScopeApi.setScopeSid(scopeSid);
        scopeApiList.add(oauthScopeApi);
    }

    private DataPolicySchemaField createSchemaFieldEntity(long schemaSid, String id, String name, String nameTW, String nameUS, Integer dataSource, String values) {
        DataPolicySchemaField dataPolicySchemaField = new DataPolicySchemaField();
        dataPolicySchemaField.setSchemaSid(schemaSid);
        dataPolicySchemaField.setId(id);
        dataPolicySchemaField.setName(name);
        dataPolicySchemaField.setNameTW(nameTW);
        dataPolicySchemaField.setNameUS(nameUS);
        dataPolicySchemaField.setDataType(DataTypeEnum.STRING.toString());
        dataPolicySchemaField.setDataSource(dataSource);
        dataPolicySchemaField.setFilterType("in");
        dataPolicySchemaField.setValueParams(values);
        return dataPolicySchemaField;
    }

    private DataPolicySchema createSchemaEntity(String actionId, String tableId, String tableName, String nameTW, String nameUS) {
        DataPolicySchema dataPolicySchema = new DataPolicySchema();
        dataPolicySchema.setActionId(actionId);
        dataPolicySchema.setTableId(tableId);
        dataPolicySchema.setTableName(tableName);
        dataPolicySchema.setTableNameTW(nameTW);
        dataPolicySchema.setTableNameUS(nameUS);
        EntityUtils.setCreateFields((BaseEntity)dataPolicySchema);
        return dataPolicySchema;
    }
}

