/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantMetadata;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.mapper.TenantMetadataMapper;
import com.digiwin.dap.middleware.iam.repository.ActionRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyRepository;
import com.digiwin.dap.middleware.iam.repository.DevAppTokenRepository;
import com.digiwin.dap.middleware.iam.repository.DevSysRepository;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Order(value=42200)
public class UpgradeDatabaseV421ToV422Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV421ToV422Service.class);
    @Autowired
    private TenantMetadataMapper tenantMetadataMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    ActionRepository actionRepository;
    @Autowired
    DataPolicyRepository dataPolicyRepository;
    @Autowired
    private DevAppTokenRepository devAppTokenRepository;
    @Autowired
    private DevSysRepository devSysRepository;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RoleCrudService roleCrudService;

    public String version() {
        return "4.22.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        this.deleteDevAppToken();
        this.upgradeTenantDefaultLanguage();
        this.createDefaultRoleForEnableTW();
    }

    private void upgradeTenantDefaultLanguage() {
        long start = System.currentTimeMillis();
        log.info("upgradeTenantDefaultLanguage start now!");
        List tenantSids = this.tenantMetadataMapper.findTenantSidMissingLanguage();
        if (CollectionUtils.isEmpty((Collection)tenantSids)) {
            return;
        }
        log.info("upgradeTenantDefaultLanguage tenant count " + tenantSids.size());
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "defaultLanguage"});
        long columnSid = column.getSid();
        String language = "zh_CN";
        String country = this.envProperties.getCountry();
        if (country.equalsIgnoreCase("tw")) {
            language = "zh_TW";
        }
        log.info("upgradeTenantDefaultLanguage language " + language);
        ArrayList<TenantMetadata> tenantMetadatas = new ArrayList<TenantMetadata>();
        for (Long tenantSid : tenantSids) {
            TenantMetadata tenantMetadata = new TenantMetadata();
            tenantMetadata.setSid(SnowFlake.getInstance().newId());
            tenantMetadata.setTenantSid(tenantSid.longValue());
            tenantMetadata.setColumnSid(columnSid);
            tenantMetadata.setValue(language);
            tenantMetadata.setCreateDate(LocalDateTime.now());
            tenantMetadata.setModifyDate(LocalDateTime.now());
            tenantMetadatas.add(tenantMetadata);
        }
        this.tenantMetadataMapper.insertMetadataOnDupUpdate(tenantMetadatas);
        log.info("upgradeTenantDefaultLanguage finished ! consume time:" + (System.currentTimeMillis() - start));
    }

    private void deleteDevAppToken() {
        List devAppTokenList = this.devAppTokenRepository.findAll();
        List devSysList = this.devSysRepository.findAll();
        log.info("devAppTokenList.size()={}, devSysList.size()={}", (Object)devAppTokenList.size(), (Object)devSysList.size());
        List idList = devSysList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        List deleteDevAppTokenList = devAppTokenList.stream().filter(x -> !idList.contains(x.getId())).collect(Collectors.toList());
        log.info("deleteDevAppTokenList = " + JsonUtils.writeValue(deleteDevAppTokenList));
        this.devAppTokenRepository.deleteAll(deleteDevAppTokenList);
        log.info("\u5220\u9664\u5783\u573e\u6570\u636e\u6210\u529f\uff01");
    }

    private void createDefaultRoleForEnableTW() {
        Role role;
        Tenant tenant = (Tenant)this.tenantCrudService.findById("99990000");
        if (tenant != null && (role = this.roleCrudService.findByTenantSidAndId(tenant.getSid(), "chang_user_admin")) == null) {
            Role superRole = this.roleCrudService.findByTenantSidAndId(tenant.getSid(), "superadmin");
            role = new Role();
            role.setId("chang_user_admin");
            role.setName("\u4ee3\u7406\u7ba1\u7406\u5458");
            role.setTenantSid(tenant.getSid());
            role.setReadonly(true);
            role.setVisible(true);
            role.setRoleCatalogSid(superRole.getRoleCatalogSid());
            this.roleCrudService.create((BaseEntity)role);
        }
    }
}

