/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.alibaba.druid.util.StringUtils;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.iam.entity.DataStatement;
import com.digiwin.dap.middleware.iam.repository.DataStatementRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Order(value=42300)
public class UpgradeDatabaseV422ToV423Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV422ToV423Service.class);
    @Autowired
    DataStatementRepository dataStatementRepository;
    @Autowired
    DictService dictService;

    public String version() {
        return "4.23.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        this.upgradeDataPolicy();
        this.upgradeISV();
        this.addDict();
    }

    private void addDict() {
        log.info("addDict start");
        Dict dict = this.dictService.selectDictById("ISV_rank");
        if (dict == null) {
            Dict newDict = new Dict();
            newDict.setId("ISV_rank");
            newDict.setName("ISV\u4f19\u4f34\u7b49\u7d1a\u985e\u578b");
            newDict.setRemark("ISV\u4f19\u4f34\u7b49\u7d1a\u985e\u578b");
            this.dictService.insertDict(newDict);
        }
        log.info("addDict finished");
    }

    private void upgradeISV() {
        log.info("upgradeISV start");
        try {
            this.jdbcTemplate.execute("update tenant set tenant.isv_apply_status=2 where sid in (select sid from (select t.sid from tenant t inner join servicer s on t.sid=s.tenant_sid where t.enterprise_type=4) a)");
            this.jdbcTemplate.execute("update tenant set tenant.enterprise_type=1 where sid in (select sid from (select t.sid from tenant t inner join servicer s on t.sid=s.tenant_sid where t.enterprise_type=4) a)");
        }
        catch (Exception e) {
            log.error("upgradeISV error", (Throwable)e);
        }
        log.info("upgradeISV finished");
    }

    private void upgradeDataPolicy() {
        log.info("upgradeDataPolicy start");
        try {
            List sids = this.jdbcTemplate.queryForList("select sid from datastatement d where filter is not null and filter !=''", Long.class);
            List allById = this.dataStatementRepository.findAllById((Iterable)sids);
            ArrayList<DataStatement> changed = new ArrayList<DataStatement>();
            for (DataStatement dataStatement : allById) {
                if (!UpgradeDatabaseV422ToV423Service.checkHistory((DataStatement)dataStatement)) continue;
                String filter = dataStatement.getFilter();
                dataStatement.setFilter("{\"default\":" + filter + "}");
                changed.add(dataStatement);
            }
            this.dataStatementRepository.update(changed);
        }
        catch (Exception e) {
            log.error("upgradeDataPolicy error", (Throwable)e);
        }
        log.info("upgradeDataPolicy finished");
    }

    private static boolean checkHistory(DataStatement dataStatement) {
        Map map = new LinkedHashMap();
        if (!StringUtils.isEmpty((String)dataStatement.getFilter())) {
            try {
                map = (Map)JsonUtils.createObjectMapper().readValue(dataStatement.getFilter(), Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map.containsKey("filterType") && map.containsKey("sid") && map.containsKey("filterValue");
    }
}

