/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.util.SpringBeanUtils;
import com.digiwin.dap.middleware.language.entity.LanguageDefault;
import com.digiwin.dap.middleware.language.repository.LanguageDefaultRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Order(value=42600)
public class UpgradeDatabaseV425ToV426Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV425ToV426Service.class);
    @Autowired
    private LanguageDefaultRepository languageDefaultRepository;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public String version() {
        return "4.26.0.0";
    }

    public void update() {
        log.info("426\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            InputStream stream = this.getClass().getResourceAsStream("/static/templates/languageDefault.json");
            List baseList = (List)JsonUtils.createObjectMapper().readValue(stream, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map<String, List<LanguageDefault>> listMap = baseList.stream().collect(Collectors.groupingBy(LanguageDefault::getDataId));
            ((UpgradeDatabaseV425ToV426Service)SpringBeanUtils.getBean(this.getClass())).initBaseLanguageResource(baseList);
            this.deleteData(listMap);
            log.info("426\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V426\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    public void deleteData(Map<String, List<LanguageDefault>> listMap) {
        String sql = "DELETE mlr FROM multi_language_resource mlr WHERE mlr.sid in(SELECT * FROM (SELECT m.sid FROM multi_language_resource m, %s r WHERE r.sid = m .data_sid AND r.id in (:ids) AND m.content in (:contents)) A)";
        HashMap<String, Collection<String>> paramsMap = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, List<LanguageDefault>> entry : listMap.entrySet()) {
            List<LanguageDefault> value = entry.getValue();
            paramsMap.put("ids", Collections.singletonList(entry.getKey().split("\\.")[1]));
            paramsMap.put("contents", value.stream().map(LanguageDefault::getContent).collect(Collectors.toSet()));
            try {
                int rows = this.namedParameterJdbcTemplate.update(String.format(sql, "name".equals(value.get(0).getFieldName()) ? "orgtype" : "role"), paramsMap);
                log.info("\u5220\u9664\u6570\u636e\u6761\u6570update={}, paramsMap={}", (Object)rows, paramsMap);
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                log.error("--->>>\u5220\u9664\u6570\u636e\u5931\u8d25paramsMap={}", paramsMap, (Object)e);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void initBaseLanguageResource(List<LanguageDefault> baseList) {
        ArrayList<LanguageDefault> insertList = new ArrayList<LanguageDefault>();
        for (LanguageDefault target : baseList) {
            LanguageDefault languageDefault = this.languageDefaultRepository.findByFieldNameAndDataIdAndLanguage(target.getFieldName(), target.getDataId(), target.getLanguage());
            if (languageDefault != null) continue;
            target.setSid(SnowFlake.getInstance().newId());
            EntityUtils.setCreateFields((BaseEntity)target);
            insertList.add(target);
        }
        log.info("\u63d2\u5165insertList.size={}", (Object)insertList.size());
        if (!CollectionUtils.isEmpty(insertList)) {
            this.languageDefaultRepository.saveAll(insertList);
        }
    }
}

