/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTypeEnum;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysNotice;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeCrudService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Order(value=42700)
public class UpgradeDatabaseV426ToV427Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV426ToV427Service.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private SysNoticeCrudService sysNoticeCrudService;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;

    public String version() {
        return "4.27.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        log.info("427\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.initSysNoticeType();
            this.initSysNotice();
            this.initNewEmcMeta();
            this.createDevAction();
            this.createDataPolicySchema();
            log.info("427\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V427\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private List<SysNoticeType> defaultType() {
        LinkedList<SysNoticeType> types = new LinkedList<SysNoticeType>();
        SysNoticeType type = new SysNoticeType();
        type.setId(SysNoticeEnum.APP_NEW.name());
        type.setPath("/api/app/initialize");
        type.setDescription("\u521d\u59cb\u5316\uff0c\u5546\u54c1\u9996\u6b21\u8d2d\u4e70\u4f1a\u8c03\u7528");
        if ("TW".equals(this.envProperties.getCountry())) {
            type.setDescription("\u521d\u59cb\u5316\uff0c\u5546\u54c1\u9996\u6b21\u8cfc\u8cb7\u6703\u8abf\u7528");
        }
        types.add(type);
        type = new SysNoticeType();
        type.setId(SysNoticeEnum.APP_RENEW.name());
        type.setPath("/api/app/tenant/renew/notices");
        type.setDescription("\u7eed\u7ea6\uff0c\u5e94\u7528\u8fc7\u671f\u518d\u6b21\u8d2d\u4e70\u4f1a\u8c03\u7528");
        if ("TW".equals(this.envProperties.getCountry())) {
            type.setDescription("\u7e8c\u7d04\uff0c\u61c9\u7528\u904e\u671f\u518d\u6b21\u8cfc\u8cb7\u6703\u8abf\u7528");
        }
        types.add(type);
        type = new SysNoticeType();
        type.setId(SysNoticeEnum.APP_EXPIRED.name());
        type.setPath("/api/app/tenant/expired/notices");
        type.setDescription("\u8fc7\u671f\uff0c\u5e94\u7528\u8fc7\u671f7\u5929\u5185\u4f1a\u8c03\u7528");
        if ("TW".equals(this.envProperties.getCountry())) {
            type.setDescription("\u904e\u671f\uff0c\u61c9\u7528\u904e\u671f7\u5929\u5167\u6703\u8abf\u7528");
        }
        types.add(type);
        type = new SysNoticeType();
        type.setId(SysNoticeEnum.APP_USER_JOINED.name());
        type.setPath("/api/app/tenant/user/joined");
        type.setDescription("\u7528\u6237\u52a0\u5165\u79df\u6237\uff0c\u5916\u90e8\u7528\u6237\u52a0\u5165\u79df\u6237\u901a\u77e5\u4ea7\u54c1\u5355\u4f4d");
        if ("TW".equals(this.envProperties.getCountry())) {
            type.setDescription("\u7528\u6236\u52a0\u5165\u79df\u6236\uff0c\u5916\u90e8\u7528\u6236\u52a0\u5165\u79df\u6236\u901a\u77e5\u7522\u54c1\u7d44\u7e54");
        }
        types.add(type);
        return types;
    }

    private void initSysNoticeType() {
        List oldNoticeTypes = this.sysNoticeTypeCrudService.findAll();
        List oldTypeIds = oldNoticeTypes.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        for (SysNoticeType noticeType : this.defaultType()) {
            if (oldTypeIds.contains(noticeType.getId())) continue;
            this.sysNoticeTypeCrudService.create((BaseEntity)noticeType);
        }
    }

    private void initSysNotice() {
        List noticeTypes = this.sysNoticeTypeCrudService.findAll();
        List sysList = this.sysCrudService.findAll();
        for (Sys sys : sysList) {
            if (StringUtils.hasText((String)sys.getBackUri())) {
                sys.setMetaUri(sys.getBackUri());
                this.sysCrudService.update((BaseEntity)sys);
            }
            if (sys.isInside()) continue;
            for (SysNoticeType noticeType : noticeTypes) {
                List notices;
                if (SysNoticeEnum.APP_USER_JOINED.name().equals(noticeType.getId()) || !(notices = this.sysNoticeCrudService.findBySysIdAndTypeId(sys.getId(), noticeType.getId())).isEmpty()) continue;
                SysNotice sysNotice = new SysNotice();
                sysNotice.setSysId(sys.getId());
                sysNotice.setTypeId(noticeType.getId());
                sysNotice.setPath(noticeType.getPath());
                sysNotice.setEnable(true);
                sysNotice.setDescription(noticeType.getDescription());
                this.sysNoticeCrudService.create((BaseEntity)sysNotice);
            }
        }
    }

    public void initNewEmcMeta() {
        try {
            DataPolicySchema notifier = this.dataPolicySchemaRepository.findByActionIdAndTableId("boss-message-center", "notifier");
            if (notifier == null) {
                DataPolicySchema old = this.dataPolicySchemaRepository.findByActionIdAndTableId("boss-notifier-management", "notifier");
                DataPolicySchema newSchema = new DataPolicySchema();
                newSchema.setActionId("boss-message-center");
                newSchema.setTableId("notifier");
                newSchema.setTableName(old.getTableName());
                newSchema.setTableNameTW(old.getTableNameTW());
                newSchema.setTableNameUS(old.getTableNameUS());
                DataPolicySchema newSchemeSaved = (DataPolicySchema)this.dataPolicySchemaRepository.save((Object)newSchema);
                DataPolicySchemaField oldField = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("appId", Long.valueOf(old.getSid()));
                DataPolicySchemaField newField = new DataPolicySchemaField();
                BeanUtils.copyProperties((Object)oldField, (Object)newField);
                newField.setSid(0L);
                newField.setSchemaSid(newSchemeSaved.getSid());
                this.dataPolicySchemaFieldRepository.save((Object)newField);
            }
            log.info("updating boss-notifier-management start");
            Sys boss = (Sys)this.sysCrudService.findById("boss");
            Optional.ofNullable(boss).ifPresent(a -> {
                Module module = (Module)this.moduleCrudService.findByUnionKey(new Object[]{"boss-operations", a.getSid()});
                if (module != null) {
                    log.info("updating boss-notifier-management module:{}", (Object)module.getSid());
                    Action oldAction = (Action)this.actionCrudService.findByUnionKey(new Object[]{"boss-notifier-management", module.getSid(), 0});
                    Action newAction = (Action)this.actionCrudService.findByUnionKey(new Object[]{"boss-message-center", module.getSid(), 0});
                    if (oldAction != null && newAction != null) {
                        String sql = String.format("update datastatement set action_sid= %s where action_sid=%s ", newAction.getSid(), oldAction.getSid());
                        log.info("updating boss-notifier-management sql:{}", (Object)sql);
                        this.jdbcTemplate.execute(sql);
                        log.info("updating boss-notifier-management success");
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("updating boss-notifier-management exception", (Throwable)e);
        }
    }

    private void createDevAction() {
        Sys sys = (Sys)this.sysCrudService.findById("dap");
        if (null == sys) {
            log.error("dev\u5e94\u7528\u4e0d\u5b58\u5728");
            return;
        }
        Module module = (Module)this.moduleCrudService.findByUnionKey(new Object[]{"dap-workbench", sys.getSid()});
        if (null == module) {
            log.error("dev\u5e94\u7528\u4e0b\u7684\u6a21\u7ec4dev-management\u4e0d\u5b58\u5728");
            return;
        }
        Action action = (Action)this.actionCrudService.findByUnionKey(new Object[]{ActionIdEnum.DEV_APPLICATION_MANAGEMENT.getId(), module.getSid(), 0});
        if (null == action) {
            action = new Action();
            action.setId(ActionIdEnum.DEV_APPLICATION_MANAGEMENT.getId());
            action.setModuleSid(module.getSid());
            action.setName("\u5e94\u7528\u7ba1\u7406-\u5e94\u7528\u6743\u9650");
            action.setParentSid(0L);
            action.setUri("dev:dev-management:dev-application-management-visual");
            action.setTenantSid(0L);
            action.setDeleted(true);
            this.actionCrudService.create((BaseEntity)action);
        }
    }

    private void createDataPolicySchema() {
        try {
            DataPolicySchemaField field;
            DataPolicySchema schema = this.dataPolicySchemaRepository.findByActionIdAndTableId(ActionIdEnum.DEV_APPLICATION_MANAGEMENT.getId(), "dev_app");
            if (null == schema) {
                schema = new DataPolicySchema(ActionIdEnum.DEV_APPLICATION_MANAGEMENT.getId(), "dev_app", "\u5e94\u7528\u7ba1\u7406", "\u5e94\u7528\u7ba1\u7406", "App Management");
                schema.setSid(SnowFlake.getInstance().newId());
                EntityUtils.setCreateFields((BaseEntity)schema);
                this.dataPolicySchemaRepository.save((Object)schema);
            }
            if (null == (field = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("devAppId", Long.valueOf(schema.getSid())))) {
                field = new DataPolicySchemaField("devAppId", "\u5e94\u7528ID", "\u61c9\u7528ID", "app Id", DataTypeEnum.STRING.toString(), Integer.valueOf(1), "in", "", schema.getSid());
                EntityUtils.setCreateFields((BaseEntity)field);
                this.dataPolicySchemaFieldRepository.save((Object)field);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u636e\u6743\u9650\u5143\u6570\u636e\u5347\u7ea7\u5931\u8d25" + e);
        }
    }
}

