/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.DevAppSecret;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.dev.appscret.DevAppSecretCrudService;
import com.digiwin.dap.middleware.iam.service.dev.apptoken.DevAppTokenCrudService;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiServiceRegisterService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Order(value=42800)
public class UpgradeDatabaseV427ToV428Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV427ToV428Service.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private EaiServiceRegisterService eaiServiceRegisterService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private WhiteListRepository whiteListRepository;
    @Autowired
    private DevAppTokenCrudService devAppTokenCrudService;
    @Autowired
    private DevAppSecretCrudService devAppSecretCrudService;

    public String version() {
        return "4.28.0.0";
    }

    public void update() {
        log.info("428\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.createRegisterServiceInfos();
            this.registerService();
            this.changeAppSecretStorage();
            log.info("428\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V428\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private void changeAppSecretStorage() {
        List all = this.devAppTokenCrudService.findAll();
        if (CollectionUtils.isEmpty((Collection)all)) {
            return;
        }
        log.info("changeAppSecretStorage all size:{}", (Object)all.size());
        List newAppSecret = all.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAppSecret())).map(a -> {
            DevAppSecret devAppSecret = new DevAppSecret();
            devAppSecret.setId(a.getId());
            devAppSecret.setAppSecret(a.getAppSecret());
            return devAppSecret;
        }).collect(Collectors.toList());
        log.info("changeAppSecretStorage newAppSecret size:{}", (Object)newAppSecret.size());
        this.devAppSecretCrudService.saveAll(newAppSecret);
    }

    private void registerService() {
        this.eaiServiceRegisterService.registerService(this.envProperties.getEaiIamUid(), this.envProperties.getEaiIamProd(), this.envProperties.getEaiIamIp(), this.envProperties.getEaiIamId(), this.whiteListService.getWhiteList("EAI_REGISTER_SERVICES"));
    }

    private void createRegisterServiceInfos() {
        List whiteLists = this.whiteListRepository.findById("EAI_REGISTER_SERVICES");
        if (whiteLists.isEmpty()) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("EAI_REGISTER_SERVICES");
            whiteList.setName("eai\u81ea\u52a8\u6ce8\u518c\u670d\u52a1\u6e05\u5355");
            whiteList.setContent("iam.user.info.get");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        } else {
            WhiteList whiteList = (WhiteList)whiteLists.get(0);
            List contents = whiteLists.stream().map(WhiteList::getContent).collect(Collectors.toList());
            if (!contents.stream().anyMatch(c -> c.contains("iam.user.info.get"))) {
                whiteList.setContent(String.format("%s;iam.user.info.get", whiteList.getContent()));
                EntityUtils.setModifyFields((BaseEntity)whiteList);
                this.whiteListRepository.save((Object)whiteList);
            }
        }
    }
}

