/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=42900)
public class UpgradeDatabaseV428ToV429Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV428ToV429Service.class);
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantCrudService tenantCrudService;

    public String version() {
        return "4.29.0.0";
    }

    public void update() {
        log.info("429\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.addDisableNoticeType();
            this.updateAthExperience();
            log.info("429\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V429\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private void updateAthExperience() {
        List all = this.tenantCrudService.findAll();
        ArrayList<Tenant> toUpdate = new ArrayList<Tenant>();
        for (Tenant tenant : all) {
            if (tenant.getId().startsWith("ath00000")) {
                tenant.setExperience(true);
                toUpdate.add(tenant);
                continue;
            }
            if (!tenant.getId().startsWith("ath-")) continue;
            tenant.setExperience(true);
            if ("TW".equalsIgnoreCase(this.envProperties.getCountry())) {
                tenant.setName("\u9ad4\u9a57\u79df\u6236-" + tenant.getCreateById());
            } else {
                tenant.setName("\u4f53\u9a8c\u79df\u6237-" + tenant.getCreateById());
            }
            tenant.setContacts(tenant.getCreateById());
            toUpdate.add(tenant);
        }
        log.info("toUpdate:{}", (Object)toUpdate.size());
        this.tenantCrudService.saveAll(toUpdate);
    }

    private void addDisableNoticeType() {
        String type = "EMP_DISABLE";
        List all = this.sysNoticeTypeCrudService.findAll();
        if (all.stream().noneMatch(a -> type.equals(a.getId()))) {
            SysNoticeType sysNoticeType = new SysNoticeType();
            sysNoticeType.setId(type);
            sysNoticeType.setPath("/api/app/tenant/emp/disabled");
            sysNoticeType.setDescription("\u5458\u5de5\u505c\u7528\u901a\u77e5");
            if ("TW".equals(this.envProperties.getCountry())) {
                sysNoticeType.setDescription("\u54e1\u5de5\u505c\u7528\u901a\u77e5");
            }
            this.sysNoticeTypeCrudService.create((BaseEntity)sysNoticeType);
        }
    }
}

