/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.sys.SysProductCodeResultVO;
import com.digiwin.dap.middleware.iam.entity.IsvRank;
import com.digiwin.dap.middleware.iam.entity.Servicer;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.repository.ServicerRepository;
import com.digiwin.dap.middleware.iam.service.servicer.IsvRankCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
@Order(value=43200)
public class UpgradeDatabaseV431ToV432Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV431ToV432Service.class);
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private IsvRankCrudService isvRankCrudService;
    @Autowired
    private ServicerRepository servicerRepository;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SysCrudService sysCrudService;

    public String version() {
        return "4.32.0.0";
    }

    public void update() {
        log.info("432\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.swapIsvRankTable();
            this.initProfitSharePercentage();
            this.initProductCode();
            log.info("432\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V432\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private void initProductCode() {
        HashMap map = this.getGoodsProductCode().stream().collect(HashMap::new, (m, v) -> m.put(v.getAppId(), v), HashMap::putAll);
        List all = this.sysCrudService.findAll();
        ArrayList<Sys> update = new ArrayList<Sys>();
        for (Sys sys : all) {
            if (!map.containsKey(sys.getId()) || !ObjectUtils.isEmpty((Object)sys.getProductCode()) && !ObjectUtils.isEmpty((Object)sys.getProductName())) continue;
            SysProductCodeResultVO vo = (SysProductCodeResultVO)map.get(sys.getId());
            sys.setProductCode(vo.getProductCode());
            sys.setProductName(vo.getProductName());
            update.add(sys);
        }
        this.sysCrudService.saveAll(update);
    }

    private void initProfitSharePercentage() {
        List all = this.servicerRepository.findAll().stream().filter(a -> StringUtils.hasLength((String)a.getIsvRank())).collect(Collectors.toList());
        List ranks = this.isvRankCrudService.findAll();
        ArrayList<Servicer> toUpdate = new ArrayList<Servicer>();
        for (Servicer servicer : all) {
            Optional<IsvRank> first = ranks.stream().filter(a -> a.getId().equals(servicer.getIsvRank())).findFirst();
            if (!first.isPresent()) continue;
            servicer.setAppSharePercentage(first.get().getAppSharePercentage());
            servicer.setServiceSharePercentage(first.get().getServiceSharePercentage());
            toUpdate.add(servicer);
        }
        this.servicerRepository.saveAll(toUpdate);
    }

    private void swapIsvRankTable() {
        DictDataDTO condition = new DictDataDTO();
        condition.setDictId("ISV_rank");
        List dictData = this.dictDataService.selectDictDataList(condition);
        List all = this.isvRankCrudService.findAll();
        ArrayList<IsvRank> toAdd = new ArrayList<IsvRank>();
        for (DictData dictDatum : dictData) {
            if (all.stream().anyMatch(a -> a.getId().equals(dictDatum.getDictKey()))) continue;
            IsvRank isvRank = new IsvRank();
            isvRank.setId(dictDatum.getDictKey());
            isvRank.setName(dictDatum.getDictValue());
            isvRank.setAppSharePercentage("20");
            isvRank.setServiceSharePercentage("20");
            isvRank.setRemark(dictDatum.getRemark());
            toAdd.add(isvRank);
        }
        this.isvRankCrudService.saveAll(toAdd);
    }

    public List<SysProductCodeResultVO> getGoodsProductCode() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestBody = new HttpEntity((MultiValueMap)headers);
            String url = this.envProperties.getGmcUri() + "/api/cloudgoods/all/product";
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestBody, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.of(responseEntity).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }
}

