/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.repository.MetadataColumnRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=43300)
public class UpgradeDatabaseV432ToV433Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV432ToV433Service.class);
    @Autowired
    private MetadataColumnRepository metadataColumnRepository;

    public String version() {
        return "4.33.0.0";
    }

    public void update() {
        log.info("433\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            List columns = this.metadataColumnRepository.findByCatalogId("integrationUserId");
            ArrayList<MetadataColumn> newColumns = new ArrayList<MetadataColumn>();
            for (ComeFromEnum comeFrom : ComeFromEnum.values()) {
                if (columns.stream().anyMatch(c -> c.getKey().equals(comeFrom.getId()))) continue;
                MetadataColumn metadataColumn = new MetadataColumn();
                metadataColumn.setCatalogId("integrationUserId");
                metadataColumn.setKey(comeFrom.getId());
                metadataColumn.setName(comeFrom.getName());
                metadataColumn.setTenantSid(0L);
                metadataColumn.setType("string");
                metadataColumn.setTypeParameter("[]");
                EntityUtils.setCreateFields((BaseEntity)metadataColumn);
                newColumns.add(metadataColumn);
            }
            if (!newColumns.isEmpty()) {
                this.metadataColumnRepository.saveAll(newColumns);
            }
            log.info("433\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V433\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }
}

