/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.excel.ResignedEmployeeExcelVO;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.iam.support.dump.upgrade.UpgradeDatabaseV433ToV434Service;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=43400)
public class UpgradeDatabaseV433ToV434Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV433ToV434Service.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WhiteListRepository whiteListRepository;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.34.0.0";
    }

    public void update() {
        log.info("434\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.disableUserOfResignedEmployee();
            this.createSkipAuthAppWhite();
            this.newSysNoticeType();
            log.info("434\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V434\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private void newSysNoticeType() {
        String type = "APP_MONTHLY";
        List all = this.sysNoticeTypeCrudService.findAll();
        if (all.stream().noneMatch(a -> type.equals(a.getId()))) {
            SysNoticeType sysNoticeType = new SysNoticeType();
            sysNoticeType.setId(type);
            sysNoticeType.setPath("/api/app/monthly");
            sysNoticeType.setDescription("\u5305\u6708\u6392\u7a0b\u5f00\u901a\u901a\u77e5");
            if ("TW".equals(this.envProperties.getCountry())) {
                sysNoticeType.setDescription("\u5305\u6708\u6392\u7a0b\u958b\u901a\u901a\u77e5");
            }
            this.sysNoticeTypeCrudService.create((BaseEntity)sysNoticeType);
        }
    }

    private void disableUserOfResignedEmployee() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("/static/templates/resignedEmployee.xlsx");
            ResignEmployeeListener resignEmployeeListener = new ResignEmployeeListener();
            EasyExcel.read((InputStream)stream, ResignedEmployeeExcelVO.class, (ReadListener)resignEmployeeListener).sheet().doRead();
            List userIds = resignEmployeeListener.getList().stream().map(ResignedEmployeeExcelVO::getUserId).collect(Collectors.toList());
            if (userIds.isEmpty()) {
                return;
            }
            List partition = Lists.partition(userIds, (int)100);
            partition.forEach(list -> this.userMapper.disableUserAndClearTelephoneByIds(list));
        }
        catch (Exception e) {
            throw new BusinessException("\u521d\u59cb\u5316\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private void createSkipAuthAppWhite() {
        List imageCheckAppWhiteListList;
        List whiteLists = this.whiteListRepository.findById("SKIP_AUTH_APPS");
        if (whiteLists.isEmpty()) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("SKIP_AUTH_APPS");
            whiteList.setName("\u9ed8\u8ba4\u5e94\u7528\u540d\u5355\uff0c\u4e0d\u6821\u9a8c\u662f\u5426\u4e3a\u672c\u5e94\u7528");
            whiteList.setContent("DigiwinCloud");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        }
        if ((imageCheckAppWhiteListList = this.whiteListRepository.findById("LOGIN_IMAGE_CHECK_APP")).isEmpty()) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("LOGIN_IMAGE_CHECK_APP");
            whiteList.setName("\u5f00\u542f\u56fe\u5f62\u9a8c\u8bc1\u7801\u7684\u5e94\u7528\u6e05\u5355");
            whiteList.setContent("DigiwinCloud");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        }
    }
}

