/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=43602)
public class UpgradeDatabaseV43601ToV43602Service
extends AbstractUpdateDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDatabaseV43601ToV43602Service.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.36.2.0";
    }

    public void update() {
        log.info("4362\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.upgradeMetadataColumn();
            Dict refundContact = this.dictService.selectDictById("refund_contact");
            if (refundContact == null) {
                Dict dict = new Dict();
                dict.setId("refund_contact");
                dict.setName("\u9000\u6b3e\u8054\u7cfb\u54a8\u8be2");
                dict.setRemark("\u9000\u6b3e\u8054\u7cfb\u54a8\u8be2");
                this.dictService.insertDict(dict);
            }
            log.info("4362\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V4362\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private void upgradeMetadataColumn() {
        MetadataColumn column = (MetadataColumn)this.metadataColumnCrudService.findByUnionKey(new Object[]{"contact", "open_wecom"});
        if (column == null) {
            MetadataColumn metadataColumn = new MetadataColumn();
            metadataColumn.setCatalogId("contact");
            metadataColumn.setKey("open_wecom");
            metadataColumn.setName(this.envProperties.getLocale().equals(Locale.TRADITIONAL_CHINESE) ? "\u52a0\u5bc6\u4f01\u5fae\u6210\u54e1\u5fae\u4fe1" : "\u52a0\u5bc6\u4f01\u5fae\u6210\u5458\u5fae\u4fe1");
            metadataColumn.setType("string");
            metadataColumn.setTypeParameter("[]");
            this.metadataColumnCrudService.create((BaseEntity)metadataColumn);
        }
    }
}

