/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43603)
@Service
public class UpgradeDatabaseV43602ToV43603Service
extends AbstractUpdateDatabaseService {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private WhiteListRepository whiteListRepository;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;

    public String version() {
        return "4.36.3.0";
    }

    public void update() {
        this.upgradeTenantMetadataColumn();
        this.loginIpCheckAppWhite();
        this.tenantMetadataColumnCrudService.saveDefaultAll();
        this.upgradeMetadataColumn();
    }

    private void upgradeMetadataColumn() {
        MetadataColumn column = (MetadataColumn)this.metadataColumnCrudService.findByUnionKey(new Object[]{"contact", "open_wecom"});
        if (column == null) {
            MetadataColumn metadataColumn = new MetadataColumn();
            metadataColumn.setCatalogId("contact");
            metadataColumn.setKey("open_wecom");
            metadataColumn.setName(this.envProperties.getLocale().equals(Locale.TRADITIONAL_CHINESE) ? "\u52a0\u5bc6\u4f01\u5fae\u6210\u54e1\u5fae\u4fe1" : "\u52a0\u5bc6\u4f01\u5fae\u6210\u5458\u5fae\u4fe1");
            metadataColumn.setType("string");
            metadataColumn.setTypeParameter("[]");
            this.metadataColumnCrudService.create((BaseEntity)metadataColumn);
        }
    }

    private void upgradeTenantMetadataColumn() {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "whiteip"});
        if (column == null) {
            TenantMetadataColumn column1 = new TenantMetadataColumn();
            column1.setCatalogId("basic");
            column1.setKey("whiteip");
            column1.setName(this.envProperties.getLocale().equals(Locale.TRADITIONAL_CHINESE) ? "IP\u767d\u540d\u55ae" : "IP\u767d\u540d\u5355");
            column1.setType("string");
            column1.setTypeParameter("[]");
            this.tenantMetadataColumnCrudService.create((BaseEntity)column1);
        }
    }

    private void loginIpCheckAppWhite() {
        List whiteLists = this.whiteListRepository.findById("LOGIN_IP_CHECK_APP");
        if (whiteLists.isEmpty()) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("LOGIN_IP_CHECK_APP");
            whiteList.setName("\u5f00\u542f\u6821\u9a8cIP\u767d\u540d\u5355\u7684\u5e94\u7528");
            whiteList.setContent("Athena");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        }
    }
}

