/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.impl.TenantMetadataCrudServiceImpl;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.impl.TenantMetadataUpdateServiceImpl;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43604)
@Service
public class UpgradeDatabaseV43603ToV43604Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43603ToV43604Service.class);
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private TenantMetadataCrudServiceImpl tenantMetadataCrudService;
    @Autowired
    private TenantMetadataUpdateServiceImpl tenantMetadataUpdateService;
    @Autowired
    private DictService dictService;

    public String version() {
        return "4.36.4.0";
    }

    public void update() {
        LOGGER.info("436400\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.tenantMetadataColumnCrudService.saveDefaultAll();
        this.updateTenantLdapUrl();
        this.addDict();
        LOGGER.info("436400\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void addDict() {
        Dict refundContact = this.dictService.selectDictById("id_min_length");
        if (refundContact == null) {
            Dict dict = new Dict();
            dict.setId("id_min_length");
            dict.setName("id\u6700\u77ed\u957f\u5ea6");
            dict.setRemark("id\u6700\u77ed\u957f\u5ea6");
            this.dictService.insertDict(dict);
        }
    }

    private void updateTenantLdapUrl() {
        List list = this.tenantRepository.findByAdLogin(Boolean.TRUE);
        if (list.isEmpty()) {
            LOGGER.info("\u5f00\u542fAdLogin\u7684\u79df\u6237\u4e3a\u7a7a\uff0c\u5347\u7ea7\u9000\u51fa <<<---");
            return;
        }
        for (Tenant tenant : list) {
            List metadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "ldap", IamConstants.LDAP_KEY_LIST);
            if (metadataVOList.isEmpty()) continue;
            String host = null;
            String port = null;
            for (TenantMetadataVO x : metadataVOList) {
                if ("host".equals(x.getKey())) {
                    host = x.getValue();
                }
                if (!"port".equals(x.getKey())) continue;
                port = x.getValue();
            }
            if (host == null || port == null) continue;
            String url = "ldap://" + host + ":" + port;
            LOGGER.info("ldap url = {}", (Object)url);
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenant.getSid(), "ldap", "url", url);
        }
    }
}

